/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.linking;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.util.IRawTypeHelper;
import org.eclipse.xtext.common.types.util.ITypeArgumentContext;
import org.eclipse.xtext.common.types.util.TypeConformanceComputationArgument;
import org.eclipse.xtext.common.types.util.TypeConformanceComputer;
import org.eclipse.xtext.common.types.util.TypeConformanceResult;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.util.PolymorphicDispatcher;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XAssignment;
import org.eclipse.xtext.xbase.XBinaryOperation;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.XUnaryOperation;
import org.eclipse.xtext.xbase.impl.FeatureCallToJavaMapping;
import org.eclipse.xtext.xbase.resource.LinkingAssumptions;
import org.eclipse.xtext.xbase.resource.XbaseResource;
import org.eclipse.xtext.xbase.scoping.featurecalls.IValidatedEObjectDescription;
import org.eclipse.xtext.xbase.scoping.featurecalls.JvmFeatureDescription;
import org.eclipse.xtext.xbase.scoping.featurecalls.LocalVarDescription;
import org.eclipse.xtext.xbase.typing.ITypeProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureCallChecker {
    private PolymorphicDispatcher<String> dispatcher = new PolymorphicDispatcher("_case", 4, 4, Collections.singletonList(this));
    @Inject
    private TypeConformanceComputer conformance;
    @Inject
    private ITypeProvider typeProvider;
    @Inject
    private FeatureCallToJavaMapping featureCall2JavaMapping;
    @Inject
    private IRawTypeHelper rawTypeHelper;
    @Inject
    private LinkingAssumptions linkingAssumptions;
    private EObject context;
    private EReference reference;

    public void setTypeProvider(ITypeProvider typeProvider) {
        this.typeProvider = typeProvider;
    }

    protected ITypeProvider getTypeProvider() {
        return this.typeProvider;
    }

    public void initialize(EObject context, EReference reference) {
        this.context = context;
        this.reference = reference;
    }

    public boolean checkTypesWithGenerics(IEObjectDescription input) {
        JvmFeatureDescription featureDescription;
        boolean result = false;
        if (input instanceof JvmFeatureDescription && !(featureDescription = (JvmFeatureDescription)input).isGenericsChecked()) {
            Provider<Boolean> validator = new Provider<Boolean>(){

                public Boolean get() {
                    Boolean result = Boolean.FALSE;
                    ITypeArgumentContext typeContext = featureDescription.getGenericTypeContext();
                    if (typeContext != null) {
                        if (FeatureCallChecker.this.context instanceof XAbstractFeatureCall && featureDescription.getEObjectOrProxy() instanceof JvmExecutable) {
                            JvmExecutable executable = (JvmExecutable)featureDescription.getEObjectOrProxy();
                            List<XExpression> actualArguments = FeatureCallChecker.this.featureCall2JavaMapping.getActualArguments((XAbstractFeatureCall)FeatureCallChecker.this.context, (JvmIdentifiableElement)executable, featureDescription.getImplicitReceiver(), featureDescription.getImplicitArgument());
                            result = FeatureCallChecker.this.checkTypesWithGenerics(featureDescription, executable, actualArguments, typeContext);
                        } else if (FeatureCallChecker.this.context instanceof XConstructorCall && featureDescription.getEObjectOrProxy() instanceof JvmConstructor) {
                            EList<XExpression> arguments = ((XConstructorCall)FeatureCallChecker.this.context).getArguments();
                            result = FeatureCallChecker.this.checkTypesWithGenerics(featureDescription, (JvmExecutable)featureDescription.getEObjectOrProxy(), (List<XExpression>)arguments, typeContext);
                        }
                    }
                    featureDescription.setGenericsChecked();
                    return result;
                }
            };
            result = this.doCheck(featureDescription, validator);
        }
        return result;
    }

    protected boolean checkTypesWithGenerics(JvmFeatureDescription featureDescription, JvmExecutable executable, List<XExpression> actualArguments, ITypeArgumentContext typeContext) {
        List<EnumSet<TypeConformanceResult.Kind>> allConformanceKinds = this.areGenericArgumentTypesValid(executable, actualArguments, typeContext);
        for (EnumSet<TypeConformanceResult.Kind> conformanceKinds : allConformanceKinds) {
            if (!conformanceKinds.contains(TypeConformanceResult.Kind.FAILED) && !conformanceKinds.contains(TypeConformanceResult.Kind.EXCEPTION)) continue;
            featureDescription.setIssueCode("org.eclipse.xtext.xbase.validation.IssueCodes.invalid_generic_argument_types");
            break;
        }
        featureDescription.setArgumentConversionHints(allConformanceKinds);
        boolean result = true;
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String checkWithoutTypes(IEObjectDescription input) {
        String issueCode;
        if (!(input instanceof IValidatedEObjectDescription)) return null;
        IValidatedEObjectDescription validatedDescription = (IValidatedEObjectDescription)input;
        JvmIdentifiableElement identifiable = validatedDescription.getEObjectOrProxy();
        if (identifiable.eIsProxy()) {
            identifiable = (JvmIdentifiableElement)EcoreUtil.resolve((EObject)identifiable, (EObject)this.context);
        }
        if (identifiable.eIsProxy()) {
            issueCode = "org.eclipse.xtext.xbase.validation.IssueCodes.unresolvable_proxy";
        } else if (!validatedDescription.isValid()) {
            if (!Strings.isEmpty((String)validatedDescription.getIssueCode())) return validatedDescription.getIssueCode();
            issueCode = "org.eclipse.xtext.xbase.validation.IssueCodes.invisible_feature";
        } else {
            issueCode = (String)this.dispatcher.invoke(new Object[]{identifiable, this.context, this.reference, validatedDescription});
        }
        validatedDescription.setIssueCode(issueCode);
        return issueCode;
    }

    public boolean checkTypesWithoutGenerics(IEObjectDescription input) {
        JvmFeatureDescription featureDescription;
        boolean result = false;
        if (input instanceof JvmFeatureDescription && !(featureDescription = (JvmFeatureDescription)input).isTypesChecked()) {
            Provider<Boolean> validator = new Provider<Boolean>(){

                public Boolean get() {
                    Boolean result = Boolean.FALSE;
                    if (FeatureCallChecker.this.context instanceof XAbstractFeatureCall && featureDescription.getEObjectOrProxy() instanceof JvmExecutable) {
                        JvmExecutable executable = (JvmExecutable)featureDescription.getEObjectOrProxy();
                        List<XExpression> actualArguments = FeatureCallChecker.this.featureCall2JavaMapping.getActualArguments((XAbstractFeatureCall)FeatureCallChecker.this.context, (JvmIdentifiableElement)executable, featureDescription.getImplicitReceiver(), featureDescription.getImplicitArgument());
                        result = FeatureCallChecker.this.checkTypesWithoutGenerics(featureDescription, executable, actualArguments);
                    } else if (FeatureCallChecker.this.context instanceof XConstructorCall && featureDescription.getEObjectOrProxy() instanceof JvmConstructor) {
                        EList<XExpression> arguments = ((XConstructorCall)FeatureCallChecker.this.context).getArguments();
                        result = FeatureCallChecker.this.checkTypesWithoutGenerics(featureDescription, (JvmExecutable)featureDescription.getEObjectOrProxy(), (List<XExpression>)arguments);
                    }
                    featureDescription.setTypesChecked();
                    return result;
                }
            };
            result = this.doCheck(featureDescription, validator);
        }
        return result;
    }

    protected boolean checkTypesWithoutGenerics(JvmFeatureDescription featureDescription, JvmExecutable executable, List<XExpression> actualArguments) {
        if (!this.areArgumentTypesValid(executable, actualArguments, featureDescription.getRawTypeContext())) {
            featureDescription.setIssueCode("org.eclipse.xtext.xbase.validation.IssueCodes.invalid_argument_types");
        }
        return true;
    }

    protected <T> T doCheck(IValidatedEObjectDescription input, Provider<T> validator) {
        Resource resource = this.context.eResource();
        if (resource instanceof XbaseResource) {
            JvmIdentifiableElement proxy = (JvmIdentifiableElement)this.context.eGet((EStructuralFeature)this.reference, false);
            XAbstractFeatureCall featureCall = null;
            XExpression implicitReceiver = null;
            XExpression implicitArgument = null;
            if (this.context instanceof XAbstractFeatureCall) {
                featureCall = (XAbstractFeatureCall)this.context;
            }
            if (input instanceof JvmFeatureDescription) {
                implicitReceiver = ((JvmFeatureDescription)input).getImplicitReceiver();
                implicitArgument = ((JvmFeatureDescription)input).getImplicitArgument();
            }
            T result = this.linkingAssumptions.assumeLinkedAndRun(resource, this.linkingAssumptions.createAssumption(proxy, input.getEObjectOrProxy(), featureCall, implicitReceiver, implicitArgument), validator);
            return result;
        }
        return (T)validator.get();
    }

    protected String _case(Object input, Object context, EReference ref, IValidatedEObjectDescription description) {
        return null;
    }

    protected String _case(JvmConstructor input, XConstructorCall context, EReference ref, JvmFeatureDescription jvmFeatureDescription) {
        EList<XExpression> arguments = context.getArguments();
        if (!this.isValidNumberOfArguments((JvmExecutable)input, (List<XExpression>)arguments)) {
            return "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_number_of_arguments";
        }
        int expectedTypeArguments = input.getTypeParameters().size() + ((JvmTypeParameterDeclarator)input.getDeclaringType()).getTypeParameters().size();
        if (!context.getTypeArguments().isEmpty() && expectedTypeArguments != context.getTypeArguments().size()) {
            return "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_number_of_type_arguments";
        }
        return null;
    }

    protected String _case(JvmOperation input, XBinaryOperation context, EReference ref, JvmFeatureDescription jvmFeatureDescription) {
        int irrelevantArguments = jvmFeatureDescription.getNumberOfIrrelevantArguments();
        if (input.getParameters().size() - irrelevantArguments != 1) {
            return "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_number_of_arguments";
        }
        if (context.getRightOperand() != null && context.getLeftOperand() != null) {
            JvmTypeReference rightOperandType = this.getTypeProvider().getType(context.getRightOperand(), true);
            if (rightOperandType == null) {
                return "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_argument_types";
            }
            JvmFormalParameter rightParam = (JvmFormalParameter)input.getParameters().get(0 + irrelevantArguments);
            JvmTypeReference parameterType = rightParam.getParameterType();
            JvmTypeReference rawLowerBound = jvmFeatureDescription.getRawTypeContext().getLowerBound(parameterType);
            JvmTypeReference rawTypeReference = this.rawTypeHelper.getRawTypeReference(rawLowerBound, context.eResource());
            if (!this.conformance.isConformant(rawTypeReference, rightOperandType, true)) {
                return "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_argument_types";
            }
            if (jvmFeatureDescription.getGenericTypeContext() != null) {
                rightOperandType = this.getTypeProvider().getType(context.getRightOperand(), false);
                JvmTypeReference lowerBound = jvmFeatureDescription.getGenericTypeContext().getLowerBound(parameterType);
                JvmTypeReference typeReference = this.rawTypeHelper.getRawTypeReference(lowerBound, context.eResource());
                if (!this.conformance.isConformant(typeReference, rightOperandType, false)) {
                    return "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_argument_types";
                }
            }
        }
        return null;
    }

    protected String _case(JvmOperation input, XAssignment context, EReference ref, JvmFeatureDescription jvmFeatureDescription) {
        if (!jvmFeatureDescription.isValidStaticState()) {
            if (input.isStatic()) {
                return "org.eclipse.xtext.xbase.validation.IssueCodes.instance_access_to_static_member";
            }
            return "org.eclipse.xtext.xbase.validation.IssueCodes.static_access_to_instance_member";
        }
        int irrelevantArguments = jvmFeatureDescription.getNumberOfIrrelevantArguments();
        if (input.getParameters().size() != 1 + irrelevantArguments) {
            return "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_number_of_arguments";
        }
        if (context.getValue() != null) {
            JvmTypeReference type = this.getTypeProvider().getType(context.getValue(), false);
            JvmFormalParameter valueParam = (JvmFormalParameter)input.getParameters().get(0 + irrelevantArguments);
            if (!this.conformance.isConformant(valueParam.getParameterType(), type, true)) {
                return "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_argument_types";
            }
            if (!this.conformance.isConformant(valueParam.getParameterType(), type, false)) {
                return "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_generic_argument_types";
            }
        }
        return null;
    }

    protected String _case(JvmField input, XAssignment context, EReference ref, JvmFeatureDescription jvmFeatureDescription) {
        if (input.isFinal()) {
            return "org.eclipse.xtext.xbase.validation.IssueCodes.assignment_target_is_not_writeable";
        }
        if (!jvmFeatureDescription.isValidStaticState()) {
            if (input.isStatic()) {
                return "org.eclipse.xtext.xbase.validation.IssueCodes.instance_access_to_static_member";
            }
            return "org.eclipse.xtext.xbase.validation.IssueCodes.static_access_to_instance_member";
        }
        return null;
    }

    protected String _case(JvmField input, XMemberFeatureCall context, EReference ref, JvmFeatureDescription jvmFeatureDescription) {
        if (!context.getMemberCallArguments().isEmpty()) {
            return "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_number_of_arguments";
        }
        if (context.isExplicitOperationCall()) {
            return "org.eclipse.xtext.xbase.validation.IssueCodes.field_access_with_parentheses";
        }
        if (input.isStatic()) {
            return "org.eclipse.xtext.xbase.validation.IssueCodes.instance_access_to_static_member";
        }
        return null;
    }

    protected String _case(JvmIdentifiableElement input, XFeatureCall context, EReference ref, LocalVarDescription description) {
        if (context.isExplicitOperationCallOrBuilderSyntax()) {
            return "org.eclipse.xtext.xbase.validation.IssueCodes.local_var_access_with_parentheses";
        }
        return null;
    }

    protected String _case(JvmField input, XFeatureCall context, EReference reference, JvmFeatureDescription jvmFeatureDescription) {
        if (!jvmFeatureDescription.isValidStaticState()) {
            if (input.isStatic()) {
                return "org.eclipse.xtext.xbase.validation.IssueCodes.instance_access_to_static_member";
            }
            return "org.eclipse.xtext.xbase.validation.IssueCodes.static_access_to_instance_member";
        }
        if (context.isExplicitOperationCallOrBuilderSyntax()) {
            return "org.eclipse.xtext.xbase.validation.IssueCodes.field_access_with_parentheses";
        }
        return null;
    }

    protected String _case(JvmOperation input, XMemberFeatureCall context, EReference ref, JvmFeatureDescription jvmFeatureDescription) {
        if (!jvmFeatureDescription.isValidStaticState()) {
            if (input.isStatic()) {
                return "org.eclipse.xtext.xbase.validation.IssueCodes.instance_access_to_static_member";
            }
            return "org.eclipse.xtext.xbase.validation.IssueCodes.static_access_to_instance_member";
        }
        return this.checkJvmOperation((JvmExecutable)input, context, context.isExplicitOperationCallOrBuilderSyntax(), jvmFeatureDescription, context.getMemberCallArguments());
    }

    protected String _case(JvmOperation input, XFeatureCall context, EReference reference, JvmFeatureDescription jvmFeatureDescription) {
        if (!jvmFeatureDescription.isValidStaticState() && !input.isStatic()) {
            return "org.eclipse.xtext.xbase.validation.IssueCodes.static_access_to_instance_member";
        }
        return this.checkJvmOperation((JvmExecutable)input, context, context.isExplicitOperationCallOrBuilderSyntax(), jvmFeatureDescription, context.getFeatureCallArguments());
    }

    protected String _case(JvmConstructor input, XFeatureCall context, EReference reference, JvmFeatureDescription jvmFeatureDescription) {
        return this.checkJvmOperation((JvmExecutable)input, context, context.isExplicitOperationCallOrBuilderSyntax(), jvmFeatureDescription, context.getFeatureCallArguments());
    }

    protected String _case(JvmOperation input, XUnaryOperation context, EReference reference, JvmFeatureDescription jvmFeatureDescription) {
        if (input.getParameters().size() != 1) {
            return "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_number_of_arguments";
        }
        if (context.getOperand() != null) {
            JvmTypeReference operandType = this.getTypeProvider().getType(context.getOperand(), true);
            JvmFormalParameter param = (JvmFormalParameter)input.getParameters().get(0);
            if (!this.conformance.isConformant(param.getParameterType(), operandType, true)) {
                return "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_argument_types";
            }
            if (!this.conformance.isConformant(param.getParameterType(), operandType)) {
                return "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_generic_argument_types";
            }
        }
        return null;
    }

    protected String checkJvmOperation(JvmExecutable executable, XAbstractFeatureCall featureCall, boolean isExplicitOperationCall, JvmFeatureDescription jvmFeatureDescription, EList<XExpression> arguments) {
        List<XExpression> actualArguments = this.featureCall2JavaMapping.getActualArguments(featureCall, (JvmIdentifiableElement)executable, jvmFeatureDescription.getImplicitReceiver(), jvmFeatureDescription.getImplicitArgument());
        if (!this.isValidNumberOfArguments(executable, actualArguments)) {
            return "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_number_of_arguments";
        }
        if (!isExplicitOperationCall && !this.isSugaredMethodInvocationWithoutParanthesis(jvmFeatureDescription)) {
            return "org.eclipse.xtext.xbase.validation.IssueCodes.method_access_without_parentheses";
        }
        if (isExplicitOperationCall && this.isSugaredMethodInvocationWithoutParanthesis(jvmFeatureDescription)) {
            return "org.eclipse.xtext.xbase.validation.IssueCodes.method_access_without_parentheses";
        }
        if (!featureCall.getTypeArguments().isEmpty() && executable.getTypeParameters().size() != featureCall.getTypeArguments().size()) {
            return "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_number_of_type_arguments";
        }
        return null;
    }

    protected boolean areArgumentTypesValid(JvmExecutable exectuable, List<XExpression> arguments, ITypeArgumentContext typeArgumentContext) {
        int numberOfParameters = exectuable.getParameters().size();
        int parametersToCheck = exectuable.isVarArgs() ? numberOfParameters - 1 : numberOfParameters;
        int i = 0;
        while (i < parametersToCheck && i < arguments.size()) {
            JvmTypeReference parameterType = ((JvmFormalParameter)exectuable.getParameters().get(i)).getParameterType();
            if (parameterType == null) {
                return true;
            }
            JvmTypeReference lowerBound = typeArgumentContext.getLowerBound(parameterType);
            JvmTypeReference rawType = this.rawTypeHelper.getRawTypeReference(lowerBound, exectuable.eResource());
            XExpression argument = arguments.get(i);
            JvmTypeReference argumentType = this.getTypeProvider().getType(argument, rawType, true);
            if (!this.conformance.isConformant(rawType, argumentType, true)) {
                return false;
            }
            ++i;
        }
        if (exectuable.isVarArgs()) {
            int lastParamIndex = numberOfParameters - 1;
            JvmTypeReference lastParameterType = ((JvmFormalParameter)exectuable.getParameters().get(lastParamIndex)).getParameterType();
            JvmTypeReference lastParameterLowerBound = typeArgumentContext.getLowerBound(lastParameterType);
            JvmTypeReference lastParameterRawType = this.rawTypeHelper.getRawTypeReference(lastParameterLowerBound, exectuable.eResource());
            if (!(lastParameterRawType instanceof JvmGenericArrayTypeReference)) {
                throw new IllegalStateException("Unexpected var arg type: " + lastParameterRawType);
            }
            JvmTypeReference varArgRawType = ((JvmGenericArrayTypeReference)lastParameterRawType).getComponentType();
            if (arguments.size() == numberOfParameters) {
                XExpression lastArgument = arguments.get(lastParamIndex);
                JvmTypeReference lastArgumentType = this.getTypeProvider().getType(lastArgument, lastParameterRawType, true);
                if (this.conformance.isConformant(lastParameterRawType, lastArgumentType, true)) {
                    return true;
                }
                lastArgumentType = this.getTypeProvider().getType(lastArgument, varArgRawType, true);
                if (!this.conformance.isConformant(varArgRawType, lastArgumentType, true)) {
                    return false;
                }
            } else {
                int i2 = lastParamIndex;
                while (i2 < arguments.size()) {
                    XExpression argumentExpression = arguments.get(i2);
                    JvmTypeReference argumentType = this.getTypeProvider().getType(argumentExpression, varArgRawType, true);
                    if (!this.conformance.isConformant(varArgRawType, argumentType, true)) {
                        return false;
                    }
                    ++i2;
                }
            }
        }
        return true;
    }

    protected List<EnumSet<TypeConformanceResult.Kind>> areGenericArgumentTypesValid(JvmExecutable exectuable, List<XExpression> arguments, ITypeArgumentContext typeArgumentContext) {
        ArrayList result = Lists.newArrayList();
        int numberOfParameters = exectuable.getParameters().size();
        int parametersToCheck = exectuable.isVarArgs() ? numberOfParameters - 1 : numberOfParameters;
        int i = 0;
        while (i < parametersToCheck && i < arguments.size()) {
            JvmTypeReference parameterType = ((JvmFormalParameter)exectuable.getParameters().get(i)).getParameterType();
            if (parameterType != null) {
                JvmTypeReference lowerBound = typeArgumentContext.getLowerBound(parameterType);
                XExpression argument = arguments.get(i);
                JvmTypeReference argumentType = this.getTypeProvider().getType(argument);
                TypeConformanceResult conformanceResult = this.conformance.isConformant(lowerBound, argumentType, new TypeConformanceComputationArgument(false, false, true));
                result.add(conformanceResult.getKinds());
            }
            ++i;
        }
        if (exectuable.isVarArgs()) {
            int lastParamIndex = numberOfParameters - 1;
            JvmTypeReference lastParameterType = ((JvmFormalParameter)exectuable.getParameters().get(lastParamIndex)).getParameterType();
            JvmTypeReference lastParameterLowerBound = typeArgumentContext.getLowerBound(lastParameterType);
            if (!(lastParameterLowerBound instanceof JvmGenericArrayTypeReference)) {
                throw new IllegalStateException("Unexpected var arg type: " + lastParameterLowerBound);
            }
            JvmTypeReference varArgRawType = ((JvmGenericArrayTypeReference)lastParameterLowerBound).getComponentType();
            if (arguments.size() == numberOfParameters) {
                XExpression lastArgument = arguments.get(lastParamIndex);
                JvmTypeReference lastArgumentType = this.getTypeProvider().getType(lastArgument, false);
                TypeConformanceResult conformanceResult = this.conformance.isConformant(lastParameterLowerBound, lastArgumentType, new TypeConformanceComputationArgument(false, false, true));
                if (conformanceResult.isConformant()) {
                    result.add(conformanceResult.getKinds());
                } else {
                    conformanceResult = this.conformance.isConformant(varArgRawType, lastArgumentType, new TypeConformanceComputationArgument(false, false, true));
                    result.add(conformanceResult.getKinds());
                }
            } else {
                int i2 = lastParamIndex;
                while (i2 < arguments.size()) {
                    XExpression argumentExpression = arguments.get(i2);
                    JvmTypeReference argumentType = this.getTypeProvider().getType(argumentExpression, false);
                    TypeConformanceResult conformanceResult = this.conformance.isConformant(varArgRawType, argumentType, new TypeConformanceComputationArgument(false, false, true));
                    result.add(conformanceResult.getKinds());
                    ++i2;
                }
            }
        }
        return result;
    }

    protected boolean isValidNumberOfArguments(JvmExecutable executable, List<XExpression> arguments) {
        int numberOfParameters = executable.getParameters().size();
        if (executable.getParameters().size() != arguments.size()) {
            if (!executable.isVarArgs()) {
                return false;
            }
            if (numberOfParameters - 1 > arguments.size()) {
                return false;
            }
        }
        return true;
    }

    protected boolean isSugaredMethodInvocationWithoutParanthesis(JvmFeatureDescription jvmFeatureDescription) {
        return jvmFeatureDescription.getKey().indexOf(40) == -1;
    }
}

