/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.findrefs;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.impl.DefaultReferenceDescription;
import org.eclipse.xtext.ui.editor.findrefs.IReferenceFinder;
import org.eclipse.xtext.ui.editor.findrefs.Messages;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultReferenceFinder
implements IReferenceFinder {
    private IResourceDescriptions index;

    @Inject
    public DefaultReferenceFinder(IResourceDescriptions index) {
        this.index = index;
    }

    @Override
    public void findAllReferences(IReferenceFinder.IQueryData queryData, IReferenceFinder.ILocalResourceAccess localResourceAccess, IAcceptor<IReferenceDescription> acceptor, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        if (!queryData.getTargetURIs().isEmpty()) {
            this.findLocalReferences(queryData, localResourceAccess, acceptor, (IProgressMonitor)subMonitor.newChild(1));
            this.findIndexedReferences(queryData, acceptor, (IProgressMonitor)subMonitor.newChild(1));
        }
    }

    @Override
    public void findIndexedReferences(IReferenceFinder.IQueryData queryData, IAcceptor<IReferenceDescription> acceptor, IProgressMonitor monitor) {
        this.findIndexedReferences(queryData.getTargetURIs(), acceptor, queryData.getResultFilter(), monitor);
    }

    @Override
    public void findIndexedReferences(IReferenceFinder.IQueryData queryData, URI resourceURI, IAcceptor<IReferenceDescription> acceptor, IProgressMonitor progressMonitor) {
        IResourceDescription resourceDescription = this.index.getResourceDescription(resourceURI.trimFragment());
        if (resourceDescription != null) {
            for (IReferenceDescription referenceDescription : resourceDescription.getReferenceDescriptions()) {
                if (!queryData.getTargetURIs().contains(referenceDescription.getTargetEObjectUri()) || queryData.getResultFilter() != null && !queryData.getResultFilter().apply((Object)referenceDescription)) continue;
                acceptor.accept((Object)referenceDescription);
            }
        }
    }

    @Override
    public void findLocalReferences(final IReferenceFinder.IQueryData queryData, IReferenceFinder.ILocalResourceAccess localResourceAccess, final IAcceptor<IReferenceDescription> acceptor, IProgressMonitor monitor) {
        final SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Find references", (int)1);
        localResourceAccess.readOnly(queryData.getLocalContextResourceURI(), new IUnitOfWork<Boolean, ResourceSet>(){

            public Boolean exec(ResourceSet localContext) throws Exception {
                HashSet targets = Sets.newHashSet();
                for (URI targetURI : queryData.getTargetURIs()) {
                    EObject target = localContext.getEObject(targetURI, true);
                    if (target == null) continue;
                    targets.add(target);
                }
                DefaultReferenceFinder.this.findLocalReferences(targets, (IAcceptor<IReferenceDescription>)acceptor, queryData.getResultFilter(), (IProgressMonitor)subMonitor);
                return true;
            }
        });
    }

    public void findLocalReferences(Set<? extends EObject> targets, IAcceptor<IReferenceDescription> acceptor, Predicate<IReferenceDescription> filter, IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        if (targets != null && !targets.isEmpty()) {
            HashSet<Resource> targetResources = new HashSet<Resource>();
            for (EObject eObject : targets) {
                targetResources.add(eObject.eResource());
            }
            Map map = EcoreUtil.CrossReferencer.find(targetResources);
            Map<EObject, URI> exportedElementsMap = null;
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ReferenceQuery_monitor, (int)targets.size());
            for (EObject eObject : targets) {
                Collection crossRefSettings = (Collection)map.get(eObject);
                if (crossRefSettings == null) continue;
                SubMonitor subSubMonitor = subMonitor.newChild(crossRefSettings.size());
                for (EStructuralFeature.Setting crossRefSetting : crossRefSettings) {
                    if (subSubMonitor.isCanceled()) {
                        return;
                    }
                    EObject source = crossRefSetting.getEObject();
                    if (crossRefSetting.getEStructuralFeature() instanceof EReference) {
                        EReference reference = (EReference)crossRefSetting.getEStructuralFeature();
                        int index = 0;
                        if (reference.isMany()) {
                            List values = (List)source.eGet((EStructuralFeature)reference);
                            int i = 0;
                            while (i < values.size()) {
                                if (eObject == values.get(i)) {
                                    index = i;
                                    break;
                                }
                                ++i;
                            }
                        }
                        if (exportedElementsMap == null) {
                            exportedElementsMap = this.createExportedElementsMap(eObject.eResource());
                        }
                        DefaultReferenceDescription localReferenceDescription = new DefaultReferenceDescription(source, eObject, reference, index, this.findClosestExportedContainerURI(source, exportedElementsMap));
                        if (filter == null || filter.apply((Object)localReferenceDescription)) {
                            acceptor.accept((Object)localReferenceDescription);
                        }
                    }
                    subSubMonitor.worked(1);
                }
            }
        }
    }

    protected Map<EObject, URI> createExportedElementsMap(Resource resource) {
        IResourceDescription resourceDescription = this.index.getResourceDescription(EcoreUtil2.getNormalizedURI((Resource)resource));
        HashMap exportedElementMap = Maps.newHashMap();
        if (resourceDescription != null) {
            for (IEObjectDescription exportedEObjectDescription : resourceDescription.getExportedObjects()) {
                EObject eObject = resource.getEObject(exportedEObjectDescription.getEObjectURI().fragment());
                if (eObject == null) continue;
                exportedElementMap.put(eObject, exportedEObjectDescription.getEObjectURI());
            }
        }
        return exportedElementMap;
    }

    protected URI findClosestExportedContainerURI(EObject element, Map<EObject, URI> exportedElementsMap) {
        EObject current = element;
        while (current != null) {
            URI uri = exportedElementsMap.get(current);
            if (uri != null) {
                return uri;
            }
            current = current.eContainer();
        }
        return null;
    }

    protected void findIndexedReferences(Set<URI> targetURIs, IAcceptor<IReferenceDescription> acceptor, Predicate<IReferenceDescription> filter, IProgressMonitor monitor) {
        HashSet targetResourceURIs = Sets.newHashSet((Iterable)Iterables.transform(targetURIs, (Function)new Function<URI, URI>(){

            public URI apply(URI from) {
                return from.trimFragment();
            }
        }));
        int numResources = Iterables.size((Iterable)this.index.getAllResourceDescriptions());
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ReferenceQuery_monitor, (int)numResources);
        for (IResourceDescription resourceDescription : this.index.getAllResourceDescriptions()) {
            if (subMonitor.isCanceled()) {
                return;
            }
            if (!targetResourceURIs.contains(resourceDescription.getURI())) {
                for (IReferenceDescription referenceDescription : resourceDescription.getReferenceDescriptions()) {
                    if (!targetURIs.contains(referenceDescription.getTargetEObjectUri()) || filter != null && !filter.apply((Object)referenceDescription)) continue;
                    acceptor.accept((Object)referenceDescription);
                }
            }
            subMonitor.worked(1);
        }
    }
}

