/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.editor.contentassist;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistEntry;
import org.eclipse.xtext.ide.editor.contentassist.IIdeContentProposalAcceptor;
import org.eclipse.xtext.ide.editor.contentassist.IdeContentProposalCreator;
import org.eclipse.xtext.ide.editor.contentassist.IdeContentProposalPriorities;
import org.eclipse.xtext.ide.editor.contentassist.IdeCrossrefProposalProvider;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.util.TextRegion;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xtext.CurrentTypeFinder;

public class IdeContentProposalProvider {
    @Inject
    private IScopeProvider scopeProvider;
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;
    @Inject
    private IdeCrossrefProposalProvider crossrefProposalProvider;
    @Inject
    private IdeContentProposalCreator proposalCreator;
    @Inject
    private IdeContentProposalPriorities proposalPriorities;
    @Inject
    private CurrentTypeFinder currentTypeFinder;

    public void createProposals(Collection<ContentAssistContext> contexts, IIdeContentProposalAcceptor acceptor) {
        for (ContentAssistContext context : this.getFilteredContexts(contexts)) {
            for (AbstractElement element : context.getFirstSetGrammarElements()) {
                if (!acceptor.canAcceptMoreProposals()) {
                    return;
                }
                this.createProposals(element, context, acceptor);
            }
        }
    }

    protected Iterable<ContentAssistContext> getFilteredContexts(Collection<ContentAssistContext> contexts) {
        return contexts;
    }

    protected void _createProposals(AbstractElement element, ContentAssistContext context, IIdeContentProposalAcceptor acceptor) {
    }

    protected void _createProposals(Assignment assignment, ContentAssistContext context, IIdeContentProposalAcceptor acceptor) {
        AbstractRule rule;
        AbstractElement terminal = assignment.getTerminal();
        if (terminal instanceof CrossReference) {
            this.createProposals(terminal, context, acceptor);
        } else if (terminal instanceof RuleCall && (rule = ((RuleCall)terminal).getRule()) instanceof TerminalRule && context.getPrefix().isEmpty()) {
            String proposal = "STRING".equals(rule.getName()) ? "\"" + assignment.getFeature() + "\"" : assignment.getFeature();
            ContentAssistEntry entry = this.proposalCreator.createProposal(proposal, context, (Procedures.Procedure1<? super ContentAssistEntry>)((Procedures.Procedure1)it -> {
                if ("STRING".equals(rule.getName())) {
                    it.getEditPositions().add(new TextRegion(context.getOffset() + 1, proposal.length() - 2));
                    it.setKind("TEXT");
                } else {
                    it.getEditPositions().add(new TextRegion(context.getOffset(), proposal.length()));
                    it.setKind("VALUE");
                }
                it.setDescription(rule.getName());
            }));
            acceptor.accept(entry, this.proposalPriorities.getDefaultPriority(entry));
        }
    }

    protected void _createProposals(Keyword keyword, ContentAssistContext context, IIdeContentProposalAcceptor acceptor) {
        ContentAssistEntry entry;
        if (this.filterKeyword(keyword, context) && (entry = this.proposalCreator.createProposal(keyword.getValue(), context, "KEYWORD", null)) != null) {
            acceptor.accept(entry, this.proposalPriorities.getKeywordPriority(keyword.getValue(), entry));
        }
    }

    protected boolean filterKeyword(Keyword keyword, ContentAssistContext context) {
        return true;
    }

    protected void _createProposals(RuleCall ruleCall, ContentAssistContext context, IIdeContentProposalAcceptor acceptor) {
    }

    protected void _createProposals(CrossReference reference, ContentAssistContext context, IIdeContentProposalAcceptor acceptor) {
        EClassifier type = this.currentTypeFinder.findCurrentTypeAfter((AbstractElement)reference);
        if (type instanceof EClass) {
            EReference eReference = GrammarUtil.getReference((CrossReference)reference, (EClass)((EClass)type));
            EObject currentModel = context.getCurrentModel();
            if (eReference != null && currentModel != null) {
                IScope scope = this.scopeProvider.getScope(currentModel, eReference);
                this.crossrefProposalProvider.lookupCrossReference(scope, reference, context, acceptor, this.getCrossrefFilter(reference, context));
            }
        }
    }

    protected Predicate<IEObjectDescription> getCrossrefFilter(CrossReference reference, ContentAssistContext context) {
        return Predicates.alwaysTrue();
    }

    protected void createProposals(AbstractElement assignment, ContentAssistContext context, IIdeContentProposalAcceptor acceptor) {
        if (assignment instanceof Assignment) {
            this._createProposals((Assignment)assignment, context, acceptor);
            return;
        }
        if (assignment instanceof CrossReference) {
            this._createProposals((CrossReference)assignment, context, acceptor);
            return;
        }
        if (assignment instanceof Keyword) {
            this._createProposals((Keyword)assignment, context, acceptor);
            return;
        }
        if (assignment instanceof RuleCall) {
            this._createProposals((RuleCall)assignment, context, acceptor);
            return;
        }
        if (assignment != null) {
            this._createProposals(assignment, context, acceptor);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(assignment, context, acceptor).toString());
    }

    protected IScopeProvider getScopeProvider() {
        return this.scopeProvider;
    }

    protected IQualifiedNameConverter getQualifiedNameConverter() {
        return this.qualifiedNameConverter;
    }

    protected IdeCrossrefProposalProvider getCrossrefProposalProvider() {
        return this.crossrefProposalProvider;
    }

    protected IdeContentProposalCreator getProposalCreator() {
        return this.proposalCreator;
    }

    protected IdeContentProposalPriorities getProposalPriorities() {
        return this.proposalPriorities;
    }
}

