/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.standalone;

import com.google.common.hash.HashCode;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.builder.standalone.incremental.BinaryFileHashing;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;

public class StandaloneBuilderFileCallback
implements JavaIoFileSystemAccess.IFileCallback {
    private final List<IPath> generatedFiles = new ArrayList<IPath>();
    private final URI resourceURI;
    private final Map<IPath, HashCode> genFiles;
    private final Map<URI, IPath[]> inputToGenFiles;
    private final Map<IPath, URI> genFileToInput;

    protected StandaloneBuilderFileCallback(URI resourceURI, Map<IPath, HashCode> genFiles, Map<URI, IPath[]> inputToGenFiles, Map<IPath, URI> genFileToInput) {
        this.resourceURI = resourceURI;
        this.inputToGenFiles = inputToGenFiles;
        this.genFiles = genFiles;
        this.genFileToInput = genFileToInput;
    }

    public void fileDeleted(File file) {
        throw new UnsupportedOperationException();
    }

    public void fileAdded(File file) {
        this.generatedFiles.add((IPath)new Path(file.getAbsolutePath()));
    }

    protected void done() {
        IPath[] prev = this.inputToGenFiles.remove(this.resourceURI);
        if (!this.generatedFiles.isEmpty()) {
            this.inputToGenFiles.put(this.resourceURI, this.generatedFiles.toArray(new IPath[0]));
            for (IPath generatedFile : this.generatedFiles) {
                BinaryFileHashing.processFile(generatedFile.toFile(), this.genFiles::put);
                this.genFileToInput.put(generatedFile, this.resourceURI);
            }
        }
        if (prev != null) {
            IPath[] iPathArray = prev;
            int n = prev.length;
            int n2 = 0;
            while (n2 < n) {
                IPath prevPath = iPathArray[n2];
                if (!this.generatedFiles.contains(prevPath) && this.resourceURI.equals(this.genFileToInput.get(prevPath))) {
                    prevPath.toFile().delete();
                    this.genFileToInput.remove(prevPath);
                    this.genFiles.remove(prevPath);
                }
                ++n2;
            }
        }
    }
}

