/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.parser.antlr;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.xpand2.XpandExecutionContext;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.UnorderedGroup;
import org.eclipse.xtext.generator.AbstractGeneratorFragment;
import org.eclipse.xtext.generator.NewlineNormalizer;
import org.eclipse.xtext.generator.parser.antlr.AntlrOptions;
import org.eclipse.xtext.generator.parser.antlr.AntlrToolFacade;
import org.eclipse.xtext.generator.parser.antlr.postProcessing.SuppressWarningsProcessor;
import org.eclipse.xtext.generator.parser.packrat.PackratParserFragment;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xtext.FlattenedGrammarAccess;
import org.eclipse.xtext.xtext.RuleFilter;
import org.eclipse.xtext.xtext.RuleNames;
import org.eclipse.xtext.xtext.generator.parser.antlr.splitting.AntlrCodeQualityHelper;
import org.eclipse.xtext.xtext.generator.parser.antlr.splitting.AntlrLexerSplitter;
import org.eclipse.xtext.xtext.generator.parser.antlr.splitting.AntlrParserSplitter;
import org.eclipse.xtext.xtext.generator.parser.antlr.splitting.BacktrackingGuardForUnorderedGroupsRemover;
import org.eclipse.xtext.xtext.generator.parser.antlr.splitting.PartialClassExtractor;
import org.eclipse.xtext.xtext.generator.parser.antlr.splitting.SyntacticPredicateFixup;
import org.eclipse.xtext.xtext.generator.parser.antlr.splitting.UnorderedGroupsSplitter;

@Deprecated(forRemoval=true)
public abstract class AbstractAntlrGeneratorFragment
extends AbstractGeneratorFragment {
    private AntlrToolFacade antlrTool = new AntlrToolFacade();
    private AntlrOptions options = new AntlrOptions();
    private List<String> antlrParams = Lists.newArrayList();
    private AntlrCodeQualityHelper codeQualityHelper = new AntlrCodeQualityHelper();

    @Override
    public void checkConfiguration(Issues issues) {
        super.checkConfiguration(issues);
        if (!this.antlrTool.isWorkable()) {
            issues.addError("\n\n*ATTENTION*\nIt is highly recommended to use ANTLR's parser generator (get it from 'http://xtext.itemis.com/'). \nAs an alternative to ANTLR you could also use the alternative implementation shipped with Xtext.\nTo do so use the generator fragment '" + PackratParserFragment.class.getName() + "' in your mwe2 file instead.");
        }
    }

    public void setAntlrTool(AntlrToolFacade facade) {
        this.antlrTool = facade;
    }

    public AntlrToolFacade getAntlrTool() {
        return this.antlrTool;
    }

    public void setOptions(AntlrOptions options) {
        this.options = options;
    }

    public AntlrOptions getOptions() {
        return this.options;
    }

    public void addAntlrParam(String param) {
        this.antlrParams.add(param);
    }

    public String[] getAntlrParams() {
        ArrayList<String> params = new ArrayList<String>(this.antlrParams);
        if (!params.contains("-Xconversiontimeout")) {
            params.add(0, "-Xconversiontimeout");
            params.add(1, "100000");
        }
        String[] result = params.toArray(new String[params.size()]);
        return result;
    }

    public void setCodeQualityHelper(AntlrCodeQualityHelper codeQualityHelper) {
        this.codeQualityHelper = codeQualityHelper;
    }

    public AntlrCodeQualityHelper getCodeQualityHelper() {
        return this.codeQualityHelper;
    }

    protected String getEncoding(XpandExecutionContext xpt, String outlet) {
        return xpt.getOutput().getOutlet(outlet).getFileEncoding();
    }

    @Override
    protected List<Object> getParameters(Grammar grammar) {
        return Collections.singletonList(this.options);
    }

    @Override
    public void generate(Grammar grammar, XpandExecutionContext ctx) {
        this.checkGrammar(grammar);
        RuleFilter filter = new RuleFilter();
        filter.setDiscardUnreachableRules(this.getOptions().isSkipUnusedRules());
        RuleNames ruleNames = RuleNames.getRuleNames((Grammar)grammar, (boolean)true);
        Grammar flattened = new FlattenedGrammarAccess(ruleNames, filter).getFlattenedGrammar();
        super.generate(flattened, ctx);
    }

    protected void checkGrammar(Grammar grammar) {
        if (!this.hasProductionRules(grammar)) {
            throw new IllegalArgumentException("You may not generate an ANTLR parser for a grammar without production rules.");
        }
    }

    protected boolean hasProductionRules(Grammar grammar) {
        AbstractRule firstRule = (AbstractRule)grammar.getRules().get(0);
        return firstRule instanceof ParserRule && !GrammarUtil.isDatatypeRule((ParserRule)((ParserRule)firstRule));
    }

    protected void splitLexerClassFile(String filename, Charset encoding) throws IOException {
        String content = this.readFileIntoString(filename, encoding);
        AntlrLexerSplitter splitter = new AntlrLexerSplitter(content);
        splitter.setCasesPerSpecialStateSwitch(this.options.getCasesPerSpecialStateSwitch());
        this.writeStringIntoFile(filename, splitter.transform(), encoding);
    }

    @Deprecated(forRemoval=true)
    protected void splitLexerClassFile(String filename) throws IOException {
        this.splitLexerClassFile(filename, Charset.defaultCharset());
    }

    protected void splitParserClassFile(String filename, Charset encoding) throws IOException {
        String content = this.readFileIntoString(filename, encoding);
        AntlrParserSplitter splitter = new AntlrParserSplitter(content, this.getOptions().getFieldsPerClass());
        PartialClassExtractor extractor = new PartialClassExtractor(splitter.transform(), this.getOptions().getMethodsPerClass());
        this.writeStringIntoFile(filename, extractor.transform(), encoding);
    }

    @Deprecated(forRemoval=true)
    protected void splitParserClassFile(String filename) throws IOException {
        this.splitParserClassFile(filename, Charset.defaultCharset());
    }

    protected void simplifyUnorderedGroupPredicatesIfRequired(Grammar grammar, String absoluteParserFileName, Charset encoding) {
        try {
            if (this.containsUnorderedGroup(grammar) || this.hasParameterizedRules(grammar)) {
                String javaFile = absoluteParserFileName.replaceAll("\\.g$", this.getParserFileNameSuffix());
                this.simplifyUnorderedGroupPredicates(javaFile, encoding);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected boolean hasParameterizedRules(Grammar grammar) {
        for (ParserRule rule : GrammarUtil.allParserRules((Grammar)grammar)) {
            if (rule.getParameters().isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Deprecated(forRemoval=true)
    protected void simplifyUnorderedGroupPredicatesIfRequired(Grammar grammar, String absoluteParserFileName) {
        this.simplifyUnorderedGroupPredicatesIfRequired(grammar, absoluteParserFileName, Charset.defaultCharset());
    }

    protected String getParserFileNameSuffix() {
        return "Parser.java";
    }

    protected void simplifyUnorderedGroupPredicates(String javaFile, Charset encoding) throws IOException {
        String content = this.readFileIntoString(javaFile, encoding);
        UnorderedGroupsSplitter splitter = new UnorderedGroupsSplitter(content);
        String transformed = splitter.transform();
        SyntacticPredicateFixup fixup = new SyntacticPredicateFixup(transformed);
        transformed = fixup.transform();
        BacktrackingGuardForUnorderedGroupsRemover remover = new BacktrackingGuardForUnorderedGroupsRemover(transformed);
        String newContent = remover.transform();
        this.writeStringIntoFile(javaFile, newContent, encoding);
    }

    @Deprecated(forRemoval=true)
    protected void simplifyUnorderedGroupPredicates(String javaFile) throws IOException {
        this.simplifyUnorderedGroupPredicates(javaFile, Charset.defaultCharset());
    }

    private void suppressWarningsImpl(String javaFile, Charset encoding) {
        String content = this.readFileIntoString(javaFile, encoding);
        content = new SuppressWarningsProcessor().process(content);
        this.writeStringIntoFile(javaFile, content, encoding);
    }

    protected void suppressWarnings(String grammarFileName, Charset encoding) {
        this.suppressWarnings(grammarFileName, grammarFileName, encoding);
    }

    protected void suppressWarnings(String absoluteLexerGrammarFileName, String absoluteParserGrammarFileName, Charset encoding) {
        this.suppressWarningsImpl(absoluteLexerGrammarFileName.replaceAll("\\.g$", this.getLexerFileNameSuffix()), encoding);
        this.suppressWarningsImpl(absoluteParserGrammarFileName.replaceAll("\\.g$", this.getParserFileNameSuffix()), encoding);
    }

    @Deprecated(forRemoval=true)
    protected void suppressWarnings(String grammarFileName) {
        this.suppressWarnings(grammarFileName, Charset.defaultCharset());
    }

    @Deprecated(forRemoval=true)
    protected void suppressWarnings(String absoluteLexerGrammarFileName, String absoluteParserGrammarFileName) {
        this.suppressWarnings(absoluteLexerGrammarFileName, absoluteParserGrammarFileName, Charset.defaultCharset());
    }

    private void normalizeLineDelimitersImpl(String textFile, Charset encoding) {
        String content = this.readFileIntoString(textFile, encoding);
        content = new NewlineNormalizer(this.getLineDelimiter()){

            @Override
            public String normalizeLineDelimiters(CharSequence content) {
                String result = super.normalizeLineDelimiters(content);
                result = result.replaceAll("\"\\+(\\r)?\\n\\s+\"", "");
                return result;
            }
        }.normalizeLineDelimiters(content);
        this.writeStringIntoFile(textFile, content, encoding);
    }

    protected String getLineDelimiter() {
        return this.getNaming().getLineDelimiter();
    }

    protected void normalizeLineDelimiters(String grammarFileName, Charset encoding) {
        this.normalizeLineDelimiters(grammarFileName, grammarFileName, encoding);
    }

    protected void normalizeTokens(String grammarFileName, Charset encoding) {
        String tokenFile = this.toTokenFileName(grammarFileName);
        String content = this.readFileIntoString(tokenFile, encoding);
        content = new NewlineNormalizer(this.getLineDelimiter()).normalizeLineDelimiters(content);
        List splitted = Strings.split((String)content, (String)this.getLineDelimiter());
        Collections.sort(splitted);
        content = String.valueOf(Strings.concat((String)this.getLineDelimiter(), (List)splitted)) + this.getLineDelimiter();
        this.writeStringIntoFile(tokenFile, content, encoding);
    }

    private String toTokenFileName(String grammarFileName) {
        return grammarFileName.replaceAll("\\.g$", ".tokens");
    }

    protected void normalizeLineDelimiters(String absoluteLexerGrammarFileName, String absoluteParserGrammarFileName, Charset encoding) {
        this.normalizeLineDelimitersImpl(absoluteLexerGrammarFileName.replaceAll("\\.g$", this.getLexerFileNameSuffix()), encoding);
        this.normalizeLineDelimitersImpl(absoluteParserGrammarFileName.replaceAll("\\.g$", this.getParserFileNameSuffix()), encoding);
    }

    protected String getLexerFileNameSuffix() {
        return "Lexer.java";
    }

    protected void splitParserAndLexerIfEnabled(String absoluteLexerGrammarFileName, String absoluteParserGrammarFileName, Charset encoding) {
        String lexerJavaFile = absoluteLexerGrammarFileName.replaceAll("\\.g$", this.getLexerFileNameSuffix());
        String parserJavaFile = absoluteParserGrammarFileName.replaceAll("\\.g$", this.getParserFileNameSuffix());
        this.improveCodeQuality(lexerJavaFile, parserJavaFile, encoding);
        if (this.getOptions().isClassSplitting()) {
            try {
                this.splitLexerClassFile(lexerJavaFile, encoding);
                this.splitParserClassFile(parserJavaFile, encoding);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected void improveCodeQuality(String lexerJavaFile, String parserJavaFile, Charset encoding) {
        String lexerContent = this.readFileIntoString(lexerJavaFile, encoding);
        lexerContent = this.codeQualityHelper.stripUnnecessaryComments(lexerContent, (org.eclipse.xtext.xtext.generator.parser.antlr.AntlrOptions)this.getOptions());
        this.writeStringIntoFile(lexerJavaFile, lexerContent, encoding);
        String parserContent = this.readFileIntoString(parserJavaFile, encoding);
        parserContent = this.codeQualityHelper.stripUnnecessaryComments(parserContent, (org.eclipse.xtext.xtext.generator.parser.antlr.AntlrOptions)this.getOptions());
        parserContent = this.codeQualityHelper.removeDuplicateBitsets(parserContent, (org.eclipse.xtext.xtext.generator.parser.antlr.AntlrOptions)this.getOptions());
        parserContent = this.codeQualityHelper.removeDuplicateDFAs(parserContent, (org.eclipse.xtext.xtext.generator.parser.antlr.AntlrOptions)this.getOptions());
        this.writeStringIntoFile(parserJavaFile, parserContent, encoding);
    }

    protected void splitParserAndLexerIfEnabled(String absoluteGrammarFileName, Charset encoding) {
        this.splitParserAndLexerIfEnabled(absoluteGrammarFileName, absoluteGrammarFileName, encoding);
    }

    @Deprecated(forRemoval=true)
    protected void splitParserAndLexerIfEnabled(String absoluteLexerGrammarFileName, String absoluteParserGrammarFileName) {
        this.splitParserAndLexerIfEnabled(absoluteLexerGrammarFileName, absoluteParserGrammarFileName, Charset.defaultCharset());
    }

    @Deprecated(forRemoval=true)
    protected void splitParserAndLexerIfEnabled(String absoluteGrammarFileName) {
        this.splitParserAndLexerIfEnabled(absoluteGrammarFileName, absoluteGrammarFileName, Charset.defaultCharset());
    }

    protected boolean containsUnorderedGroup(Grammar grammar) {
        for (ParserRule rule : GrammarUtil.allParserRules((Grammar)grammar)) {
            if (!Iterators.filter((Iterator)rule.eAllContents(), UnorderedGroup.class).hasNext()) continue;
            return true;
        }
        return false;
    }
}

