/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.validation;

import com.google.inject.Inject;
import java.util.HashMap;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionProvider;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.validation.Issue;

public class MarkerCreator {
    private static final String FIXABLE_KEY = "FIXABLE_KEY";
    @Inject(optional=true)
    private IssueResolutionProvider resolutionProvider;

    public void createMarker(Issue issue, IResource resource, String markerType) throws CoreException {
        IMarker marker = resource.createMarker(markerType);
        this.setMarkerAttributes(issue, resource, marker);
    }

    protected void setMarkerAttributes(Issue issue, IResource resource, IMarker marker) throws CoreException {
        HashMap<String, Object> attributes = new HashMap<String, Object>(16);
        String lineNR = "";
        if (issue.getLineNumber() != null) {
            lineNR = "line: " + issue.getLineNumber() + " ";
        }
        attributes.put("location", String.valueOf(lineNR) + resource.getFullPath().toString());
        attributes.put("CODE_KEY", issue.getCode());
        attributes.put("severity", this.getSeverity(issue));
        attributes.put("charStart", issue.getOffset());
        if (issue.getOffset() != null && issue.getLength() != null) {
            attributes.put("charEnd", issue.getOffset() + issue.getLength());
        }
        attributes.put("lineNumber", issue.getLineNumber());
        attributes.put("COLUMN_KEY", issue.getColumn());
        attributes.put("message", issue.getMessage());
        if (issue.getUriToProblem() != null) {
            attributes.put("URI_KEY", issue.getUriToProblem().toString());
        }
        if (issue.getData() != null && issue.getData().length > 0) {
            attributes.put("DATA_KEY", Strings.pack((String[])issue.getData()));
        }
        if (this.resolutionProvider != null && this.resolutionProvider.hasResolutionFor(issue.getCode())) {
            attributes.put(FIXABLE_KEY, true);
        }
        marker.setAttributes(attributes);
    }

    private Object getSeverity(Issue issue) {
        switch (issue.getSeverity()) {
            case ERROR: {
                return 2;
            }
            case WARNING: {
                return 1;
            }
            case INFO: {
                return 0;
            }
        }
        throw new IllegalArgumentException(String.valueOf(issue.getSeverity()));
    }
}

