/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.view;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.eclipse.core.resources.IStorage;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.xtend.ide.view.DerivedSourceSelection;
import org.eclipse.xtend.ide.view.DerivedSourceView;
import org.eclipse.xtext.ui.views.IWorkbenchPartSelection;

public class DerivedSourceDropDownAction
extends Action
implements IMenuCreator {
    private static final int RESULTS_IN_DROP_DOWN = 10;
    private DerivedSourceView derivedSourceView;
    private Menu menu;

    public DerivedSourceDropDownAction(DerivedSourceView derivedSourceView) {
        this.derivedSourceView = derivedSourceView;
        this.setToolTipText("Show all derived sources");
        this.setImageDescriptor(derivedSourceView.getXtendImages().forFilter());
        this.setMenuCreator(this);
    }

    public Menu getMenu(Control parent) {
        if (this.menu != null) {
            this.menu.dispose();
        }
        this.menu = new Menu(parent);
        if (this.derivedSourceView.getSelectedSource() == null) {
            return this.menu;
        }
        ArrayList derivedSources = Lists.newArrayList(this.derivedSourceView.getDerivedSources());
        int min = Math.min(derivedSources.size(), 10);
        SelectDerivedSourceAction action = new SelectDerivedSourceAction(this.derivedSourceView.getSelectedSource());
        action.setChecked(true);
        this.addActionToMenu(this.menu, action);
        new MenuItem(this.menu, 2);
        int i = 0;
        while (i < min) {
            IStorage resource = (IStorage)derivedSources.get(i);
            if (!resource.equals(this.derivedSourceView.getSelectedSource())) {
                action = new SelectDerivedSourceAction(resource);
                this.addActionToMenu(this.menu, action);
            }
            ++i;
        }
        return this.menu;
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    public void dispose() {
        if (this.menu != null) {
            this.menu.dispose();
            this.menu = null;
        }
    }

    private void addActionToMenu(Menu parent, Action action) {
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        item.fill(parent, -1);
    }

    private final class SelectDerivedSourceAction
    extends Action {
        private IStorage derivedSource;

        public SelectDerivedSourceAction(IStorage derivedSource) {
            this.derivedSource = derivedSource;
            this.setText(derivedSource.getName());
        }

        public void run() {
            DerivedSourceView derivedSourceView = DerivedSourceDropDownAction.this.derivedSourceView;
            IWorkbenchPartSelection workbenchPartSelection = derivedSourceView.getWorkbenchPartSelection();
            derivedSourceView.computeAndSetInput((IWorkbenchPartSelection)new DerivedSourceSelection(workbenchPartSelection, this.derivedSource));
        }
    }
}

