/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.purexbase.ui.autoedit;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.purexbase.pureXbase.Model;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.XtextDocumentUtil;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.interpreter.IEvaluationContext;
import org.eclipse.xtext.xbase.interpreter.IEvaluationResult;
import org.eclipse.xtext.xbase.interpreter.impl.DefaultEvaluationContext;
import org.eclipse.xtext.xbase.interpreter.impl.XbaseInterpreter;
import org.eclipse.xtext.xbase.typesystem.IBatchTypeResolver;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

public class ReplAutoEdit
implements IAutoEditStrategy {
    @Inject
    private Provider<XbaseInterpreter> interpreterProvider;
    @Inject
    private IBatchTypeResolver typeResolver;
    @Inject
    private IResourceValidator validator;
    @Inject
    private XtextDocumentUtil xtextDocumentUtil;

    public void customizeDocumentCommand(final IDocument document, final DocumentCommand command) {
        if (!this.isLineDelimiter(document, command)) {
            return;
        }
        try {
            IXtextDocument doc = this.xtextDocumentUtil.getXtextDocument(document);
            String result = (String)doc.tryReadOnly((IUnitOfWork)new IUnitOfWork<String, XtextResource>(){

                public String exec(XtextResource resource) throws Exception {
                    return ReplAutoEdit.this.computeResultText(document, command, resource);
                }
            });
            if (result == null) {
                return;
            }
            command.text = result;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean isLineDelimiter(IDocument document, DocumentCommand command) {
        if (command.length != 0) {
            return false;
        }
        String originalText = command.text;
        String[] lineDelimiters = document.getLegalLineDelimiters();
        int delimiterIndex = TextUtilities.startsWith((String[])lineDelimiters, (String)originalText);
        return delimiterIndex != -1 && originalText.trim().length() == 0;
    }

    protected String computeResultText(IDocument document, DocumentCommand command, XtextResource resource) throws BadLocationException {
        LightweightTypeReference expressionType;
        if (resource.getContents().isEmpty()) {
            return null;
        }
        if (!(resource.getContents().get(0) instanceof Model)) {
            return null;
        }
        Model model = (Model)resource.getContents().get(0);
        if (model.getBlock() == null) {
            return null;
        }
        EList expressions = model.getBlock().getExpressions();
        if (expressions.isEmpty()) {
            return null;
        }
        XExpression expression = (XExpression)expressions.get(expressions.size() - 1);
        if (expression == null) {
            return null;
        }
        ICompositeNode node = NodeModelUtils.getNode((EObject)expression);
        if (node == null || document.getLineOfOffset(command.offset) + 1 != node.getEndLine()) {
            return null;
        }
        List issues = this.validator.validate((Resource)resource, CheckMode.NORMAL_AND_FAST, CancelIndicator.NullImpl);
        if (issues.stream().anyMatch(i -> i.getSeverity() == Severity.ERROR)) {
            return null;
        }
        XbaseInterpreter xbaseInterpreter = this.getConfiguredInterpreter(resource);
        IEvaluationResult result = xbaseInterpreter.evaluate((XExpression)model.getBlock(), (IEvaluationContext)new DefaultEvaluationContext(), new CancelIndicator(){
            private long stopAt = System.currentTimeMillis() + 2000L;

            public boolean isCanceled() {
                return System.currentTimeMillis() > this.stopAt;
            }
        });
        if (result == null) {
            return null;
        }
        String value = String.valueOf(result.getResult());
        if (result.getException() != null) {
            value = "threw " + result.getException().getClass().getSimpleName();
        }
        if ((expressionType = this.typeResolver.resolveTypes((EObject)expression).getActualType(expression)) != null) {
            String newText = command.text + "// " + value + " (" + expressionType.getSimpleName() + ")" + command.text;
            return newText;
        }
        return command.text + "// " + value;
    }

    protected XbaseInterpreter getConfiguredInterpreter(XtextResource resource) {
        Object context;
        XbaseInterpreter interpreter2 = (XbaseInterpreter)this.interpreterProvider.get();
        ResourceSet set = resource.getResourceSet();
        ClassLoader cl = this.getClass().getClassLoader();
        if (set instanceof XtextResourceSet && (context = ((XtextResourceSet)set).getClasspathURIContext()) instanceof IJavaProject) {
            try {
                IJavaProject jp = (IJavaProject)context;
                IClasspathEntry[] classpath = jp.getResolvedClasspath(true);
                IWorkspaceRoot root = jp.getProject().getWorkspace().getRoot();
                HashSet urls = Sets.newHashSet();
                int i = 0;
                while (i < classpath.length) {
                    IFolder folder;
                    IPath outputLocation;
                    IClasspathEntry entry = classpath[i];
                    if (entry.getEntryKind() == 3) {
                        outputLocation = entry.getOutputLocation();
                        if (outputLocation == null) {
                            outputLocation = jp.getOutputLocation();
                        }
                        if ((folder = root.getFolder(outputLocation)).exists()) {
                            urls.add(new URL(folder.getRawLocationURI().toASCIIString() + "/"));
                        }
                    } else if (entry.getEntryKind() == 2) {
                        outputLocation = entry.getOutputLocation();
                        if (outputLocation == null) {
                            IProject project = (IProject)jp.getProject().getWorkspace().getRoot().getContainerForLocation(entry.getPath());
                            IJavaProject javaProject = JavaCore.create((IProject)project);
                            outputLocation = javaProject.getOutputLocation();
                        }
                        if ((folder = root.getFolder(outputLocation)).exists()) {
                            urls.add(new URL(folder.getRawLocationURI().toASCIIString() + "/"));
                        }
                    } else {
                        urls.add(entry.getPath().toFile().toURI().toURL());
                    }
                    ++i;
                }
                cl = new URLClassLoader(urls.toArray(new URL[urls.size()]));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        interpreter2.setClassLoader(cl);
        return interpreter2;
    }
}

