/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.testing;

import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.xtext.util.JavaVersion;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.testing.JavaSource;

public class InMemoryJavaCompiler {
    private static final Logger logger = Logger.getLogger(InMemoryJavaCompiler.class);
    private final INameEnvironment nameEnv;
    private final ClassLoader parentClassLoader;
    private final CompilerOptions compilerOptions;

    public InMemoryJavaCompiler(ClassLoader parent, JavaVersion javaVersion) {
        this.nameEnv = new ClassLoaderBasedNameEnvironment(parent);
        this.parentClassLoader = parent;
        this.compilerOptions = new CompilerOptions();
        this.setJavaVersion(javaVersion);
        this.compilerOptions.inlineJsrBytecode = true;
        this.compilerOptions.preserveAllLocalVariables = true;
    }

    public InMemoryJavaCompiler(ClassLoader parent, CompilerOptions compilerOptions) {
        this.nameEnv = new ClassLoaderBasedNameEnvironment(parent);
        this.parentClassLoader = parent;
        this.compilerOptions = new CompilerOptions(compilerOptions.getMap());
    }

    public long setJavaVersion(JavaVersion javaVersion) {
        long classFmt = this.toClassFmt(javaVersion);
        this.setSourceLevel(classFmt);
        this.setComplianceLevel(classFmt);
        this.compilerOptions.targetJDK = classFmt;
        return this.compilerOptions.targetJDK;
    }

    private long toClassFmt(JavaVersion version) {
        if (JavaVersion.JAVA8.compareTo((Enum)version) > 0) {
            logger.error((Object)"Ignored attempt to set JavaVersion lower than 8", (Throwable)new IllegalArgumentException(version.toString()));
            version = JavaVersion.JAVA8;
        }
        return version.toJdtClassFileConstant();
    }

    private void setSourceLevel(long jdkVersion) {
        this.compilerOptions.sourceLevel = jdkVersion;
        this.compilerOptions.originalSourceLevel = jdkVersion;
    }

    private void setComplianceLevel(long jdkVersion) {
        this.compilerOptions.complianceLevel = jdkVersion;
        this.compilerOptions.originalComplianceLevel = jdkVersion;
    }

    public Result compile(JavaSource ... sources) {
        final Result result = new Result(this.parentClassLoader);
        ICompilerRequestor requestor = it -> {
            ClassFile[] classFileArray = it.getClassFiles();
            int n = classFileArray.length;
            int n2 = 0;
            while (n2 < n) {
                ClassFile cf = classFileArray[n2];
                result.classMap.put(CharOperation.toString((char[][])cf.getCompoundName()), cf.getBytes());
                ++n2;
            }
        };
        Compiler compiler = new Compiler(this.nameEnv, DefaultErrorHandlingPolicies.proceedWithAllProblems(), this.compilerOptions, requestor, (IProblemFactory)new DefaultProblemFactory(){

            public CategorizedProblem createProblem(char[] originatingFileName, int problemId, String[] problemArguments, int elaborationId, String[] messageArguments, int severity, int startPosition, int endPosition, int lineNumber, int columnNumber) {
                CategorizedProblem problem = super.createProblem(originatingFileName, problemId, problemArguments, elaborationId, messageArguments, severity, startPosition, endPosition, lineNumber, columnNumber);
                result.compilationProblems.add(problem);
                return problem;
            }

            public CategorizedProblem createProblem(char[] originatingFileName, int problemId, String[] problemArguments, String[] messageArguments, int severity, int startPosition, int endPosition, int lineNumber, int columnNumber) {
                CategorizedProblem problem = super.createProblem(originatingFileName, problemId, problemArguments, messageArguments, severity, startPosition, endPosition, lineNumber, columnNumber);
                result.compilationProblems.add(problem);
                return problem;
            }
        });
        List unitsLists = Lists.transform(Arrays.asList(sources), it -> new CompilationUnit(it.getCode().toCharArray(), it.getFileName(), null));
        ICompilationUnit[] units = unitsLists.toArray(new ICompilationUnit[unitsLists.size()]);
        compiler.compile(units);
        return result;
    }

    static class ByteClassLoader
    extends ClassLoader {
        private Map<String, byte[]> classMap;

        public ByteClassLoader(Map<String, byte[]> classMap, ClassLoader parent) {
            super(parent);
            this.classMap = classMap;
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            byte[] bytes = this.classMap.get(name);
            if (bytes == null) {
                return super.findClass(name);
            }
            return this.defineClass(name, bytes, 0, bytes.length);
        }

        @Override
        protected URL findResource(String path) {
            try {
                byte[] bytes;
                if (path.endsWith(".class") && (bytes = this.classMap.get(path.substring(0, path.length() - 6).replace("/", "."))) != null) {
                    return new URL("in-memory", null, -1, path, new URLStreamHandler(){

                        @Override
                        protected URLConnection openConnection(URL it) throws IOException {
                            return new URLConnection(it){

                                @Override
                                public void connect() {
                                }

                                @Override
                                public InputStream getInputStream() {
                                    return new ByteArrayInputStream(bytes);
                                }
                            };
                        }
                    });
                }
                return null;
            }
            catch (MalformedURLException e) {
                throw Exceptions.sneakyThrow((Throwable)e);
            }
        }
    }

    private static class ClassLoaderBasedNameEnvironment
    implements INameEnvironment {
        private final ClassLoader classLoader;
        private Map<String, NameEnvironmentAnswer> cache = new HashMap<String, NameEnvironmentAnswer>();

        public ClassLoaderBasedNameEnvironment(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        public void cleanup() {
            this.cache.clear();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public NameEnvironmentAnswer findType(char[][] compoundTypeName) {
            try {
                String fileName = new String(CharOperation.concatWith((char[][])compoundTypeName, (char)'/')) + ".class";
                if (this.cache.containsKey(fileName)) {
                    return this.cache.get(fileName);
                }
                URL url = this.classLoader.getResource(fileName);
                if (url == null) {
                    this.cache.put(fileName, null);
                    return null;
                }
                ClassFileReader reader = null;
                Throwable throwable = null;
                Object var6_8 = null;
                try (InputStream in = url.openStream();){
                    reader = ClassFileReader.read((InputStream)in, (String)fileName);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                        throw throwable;
                    }
                    if (throwable == throwable2) throw throwable;
                    throwable.addSuppressed(throwable2);
                    throw throwable;
                }
                if (reader == null) {
                    return null;
                }
                NameEnvironmentAnswer result = new NameEnvironmentAnswer((IBinaryType)reader, null);
                this.cache.put(fileName, result);
                return result;
            }
            catch (IOException | ClassFormatException e) {
                throw Exceptions.sneakyThrow((Throwable)e);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName) {
            try {
                String fileName = new String(CharOperation.concatWith((char[][])packageName, (char)'/')) + "/" + String.valueOf(typeName) + ".class";
                if (this.cache.containsKey(fileName)) {
                    return this.cache.get(fileName);
                }
                URL url = this.classLoader.getResource(fileName);
                if (url == null) {
                    this.cache.put(fileName, null);
                    return null;
                }
                ClassFileReader reader = null;
                Throwable throwable = null;
                Object var7_9 = null;
                try (InputStream in = url.openStream();){
                    reader = ClassFileReader.read((InputStream)in, (String)fileName);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                        throw throwable;
                    }
                    if (throwable == throwable2) throw throwable;
                    throwable.addSuppressed(throwable2);
                    throw throwable;
                }
                if (reader == null) {
                    return null;
                }
                NameEnvironmentAnswer result = new NameEnvironmentAnswer((IBinaryType)reader, null);
                this.cache.put(fileName, result);
                return result;
            }
            catch (IOException | ClassFormatException e) {
                throw Exceptions.sneakyThrow((Throwable)e);
            }
        }

        public boolean isPackage(char[][] parentPackageName, char[] packageName) {
            return Character.isLowerCase(packageName[0]);
        }
    }

    public static class Result {
        private final Set<CategorizedProblem> compilationProblems = new LinkedHashSet<CategorizedProblem>();
        private final HashMap<String, byte[]> classMap = new HashMap();
        private final ClassLoader parentClassLoader;

        public Result(ClassLoader parentClassLoader) {
            this.parentClassLoader = parentClassLoader;
        }

        public ClassLoader getClassLoader() {
            return new ByteClassLoader(this.classMap, this.parentClassLoader);
        }

        public Set<CategorizedProblem> getCompilationProblems() {
            return this.compilationProblems;
        }
    }
}

