/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.editor.folding;

import java.util.Objects;
import org.eclipse.xtext.ide.editor.folding.FoldingRangeKind;
import org.eclipse.xtext.util.ITextRegion;

public class FoldingRange {
    private final int offset;
    private final int length;
    private final FoldingRangeKind kind;
    private final boolean initiallyFolded;
    private final ITextRegion visualPlaceholderRegion;

    public FoldingRange(int offset, int length) {
        this(offset, length, null);
    }

    public FoldingRange(int offset, int length, FoldingRangeKind kind) {
        this(offset, length, kind, false, null);
    }

    public FoldingRange(int offset, int length, FoldingRangeKind kind, boolean initiallyFolded, ITextRegion visualPlaceholderRegion) {
        this.offset = offset;
        this.length = length;
        this.kind = kind;
        this.initiallyFolded = initiallyFolded;
        this.visualPlaceholderRegion = visualPlaceholderRegion;
    }

    public boolean isInitiallyFolded() {
        return this.initiallyFolded;
    }

    public ITextRegion getVisualPlaceholderRegion() {
        return this.visualPlaceholderRegion;
    }

    public FoldingRangeKind getKind() {
        return this.kind;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public boolean equals(Object other) {
        if (other instanceof FoldingRange) {
            FoldingRange range = (FoldingRange)other;
            return this.offset == range.offset && this.length == range.length && this.initiallyFolded == range.initiallyFolded && Objects.equals(this.kind, range.kind) && Objects.equals(this.visualPlaceholderRegion, range.visualPlaceholderRegion);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.offset, this.length, this.initiallyFolded, this.kind, this.visualPlaceholderRegion);
    }

    public String toString() {
        StringBuilder content = new StringBuilder();
        content.append("offset=").append(this.offset);
        content.append(", length=").append(this.length);
        content.append(", kind=").append(this.kind);
        content.append(", initiallyFolded=").append(this.initiallyFolded);
        return content.toString();
    }
}

