/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.formatting;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Stack;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtend.core.formatting.Chunk;
import org.eclipse.xtend.core.formatting.Line;
import org.eclipse.xtend.core.formatting.LineModel;
import org.eclipse.xtend.core.formatting.SemanticWhitespace;
import org.eclipse.xtend.core.formatting.TemplateWhitespace;
import org.eclipse.xtend.core.richstring.AbstractRichStringPartAcceptor;
import org.eclipse.xtend.core.xtend.RichString;
import org.eclipse.xtend.core.xtend.RichStringLiteral;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.formatting.NodeModelAccess;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IntegerRange;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class RichStringToLineModel
extends AbstractRichStringPartAcceptor.ForLoopOnce {
    private final RichString string;
    private final String document;
    private final NodeModelAccess nodeModelAccess;
    private final LineModel _model = new Functions.Function0<LineModel>(){

        public LineModel apply() {
            LineModel _lineModel = new LineModel();
            return _lineModel;
        }
    }.apply();
    private int offset = new Functions.Function0<Integer>(){

        public Integer apply() {
            int _minus = -1;
            return _minus;
        }
    }.apply();
    private int contentStartOffset = new Functions.Function0<Integer>(){

        public Integer apply() {
            int _minus = -1;
            return _minus;
        }
    }.apply();
    private int contentStartColumn = new Functions.Function0<Integer>(){

        public Integer apply() {
            int _minus = -1;
            return _minus;
        }
    }.apply();
    private Stack<Chunk> indentationStack = new Functions.Function0<Stack<Chunk>>(){

        public Stack<Chunk> apply() {
            Stack<Chunk> _stack = new Stack<Chunk>();
            return _stack;
        }
    }.apply();
    private boolean content = false;
    private boolean indentNextLine = false;
    private boolean _outdentThisLine = false;
    private int lastLiteralEndOffset;

    public LineModel getModel() {
        return this._model;
    }

    public RichStringToLineModel(NodeModelAccess nodeModelAccess, RichString string) {
        String _text;
        this.nodeModelAccess = nodeModelAccess;
        this.string = string;
        INode _nodeForEObject = nodeModelAccess.nodeForEObject((EObject)string);
        ICompositeNode _rootNode = _nodeForEObject.getRootNode();
        this.document = _text = _rootNode.getText();
    }

    public boolean outdentThisLine() {
        boolean _xifexpression = false;
        if (this.indentNextLine) {
            boolean _indentNextLine;
            this.indentNextLine = false;
            _xifexpression = _indentNextLine = false;
        } else {
            boolean __outdentThisLine;
            this._outdentThisLine = true;
            _xifexpression = __outdentThisLine = true;
        }
        return _xifexpression;
    }

    public void finish() {
        this.acceptLineBreak(0, false, false);
    }

    protected int literalPrefixLenght(INode node) {
        boolean _startsWith_2;
        boolean _startsWith_1;
        boolean _startsWith;
        String _text;
        int _switchResult = 0;
        String t = _text = node.getText();
        boolean _matched = false;
        if (!_matched && (_startsWith = t.startsWith("'''"))) {
            _matched = true;
            _switchResult = 3;
        }
        if (!_matched && (_startsWith_1 = t.startsWith("\u00bb\u00bb"))) {
            _matched = true;
            _switchResult = 2;
        }
        if (!_matched && (_startsWith_2 = t.startsWith("\u00bb"))) {
            _matched = true;
            _switchResult = 1;
        }
        if (!_matched) {
            _switchResult = 1;
        }
        return _switchResult;
    }

    protected int literalPostfixLenght(INode node) {
        boolean _endsWith_2;
        boolean _endsWith_1;
        boolean _endsWith;
        String _text;
        int _switchResult = 0;
        String t = _text = node.getText();
        boolean _matched = false;
        if (!_matched && (_endsWith = t.endsWith("'''"))) {
            _matched = true;
            _switchResult = 3;
        }
        if (!_matched && (_endsWith_1 = t.endsWith("\u00ab\u00ab"))) {
            _matched = true;
            _switchResult = 2;
        }
        if (!_matched && (_endsWith_2 = t.endsWith("\u00ab"))) {
            _matched = true;
            _switchResult = 1;
        }
        if (!_matched) {
            _switchResult = 1;
        }
        return _switchResult;
    }

    public void announceNextLiteral(RichStringLiteral object) {
        INode node;
        boolean _notEquals;
        boolean _greaterThan;
        super.announceNextLiteral(object);
        boolean _and = false;
        boolean bl = _greaterThan = this.lastLiteralEndOffset > 0;
        if (!_greaterThan) {
            _and = false;
        } else {
            boolean _lessThan = this.contentStartOffset < 0;
            boolean bl2 = _and = _greaterThan && _lessThan;
        }
        if (_and) {
            this.contentStartOffset = this.lastLiteralEndOffset;
        }
        boolean bl3 = _notEquals = !Objects.equal((Object)(node = this.nodeModelAccess.nodeForFeature((EObject)object, (EStructuralFeature)XbasePackage.Literals.XSTRING_LITERAL__VALUE)), null);
        if (_notEquals) {
            int _minus;
            int _plus;
            int _offset = node.getOffset();
            int _literalPrefixLenght = this.literalPrefixLenght(node);
            this.offset = _plus = _offset + _literalPrefixLenght;
            int _offset_1 = node.getOffset();
            int _length = node.getLength();
            int _plus_1 = _offset_1 + _length;
            int _literalPostfixLenght = this.literalPostfixLenght(node);
            this.lastLiteralEndOffset = _minus = _plus_1 - _literalPostfixLenght;
        }
        this.content = true;
    }

    public void acceptSemanticLineBreak(int charCount, RichStringLiteral origin, boolean controlStructureSeen) {
        int _plus;
        super.acceptSemanticLineBreak(charCount, origin, controlStructureSeen);
        this.acceptLineBreak(charCount, true, true);
        this.offset = _plus = this.offset + charCount;
    }

    public void acceptTemplateLineBreak(int charCount, RichStringLiteral origin) {
        int _plus;
        super.acceptTemplateLineBreak(charCount, origin);
        this.acceptLineBreak(charCount, false, true);
        this.offset = _plus = this.offset + charCount;
    }

    public void acceptLineBreak(int charCount, boolean semantic, boolean startNewLine) {
        int _minus_1;
        boolean _greaterThan;
        this.startContent();
        boolean bl = _greaterThan = this.contentStartOffset > 0;
        if (_greaterThan) {
            String lastLinesContent = this.document.substring(this.contentStartOffset, this.offset);
            LineModel _model = this.getModel();
            List<Line> _lines = _model.getLines();
            boolean _isEmpty = _lines.isEmpty();
            if (_isEmpty) {
                LineModel _model_1 = this.getModel();
                _model_1.setLeadingText(lastLinesContent);
                this.contentStartColumn = 0;
            } else {
                boolean _notEquals;
                boolean _lessThan;
                LineModel _model_2 = this.getModel();
                List<Line> _lines_1 = _model_2.getLines();
                Line lastLine = (Line)IterableExtensions.last(_lines_1);
                lastLine.setContent(lastLinesContent);
                int _offset = lastLine.getOffset();
                int _newLineCharCount = lastLine.getNewLineCharCount();
                int _plus = _offset + _newLineCharCount;
                int newContentStartColumn = this.contentStartOffset - _plus;
                boolean _isLeadingSemanticNewLine = lastLine.isLeadingSemanticNewLine();
                if (_isLeadingSemanticNewLine) {
                    boolean _greaterThan_1;
                    boolean bl2 = _greaterThan_1 = newContentStartColumn > this.contentStartColumn;
                    if (_greaterThan_1) {
                        int length = newContentStartColumn - this.contentStartColumn;
                        int _minus = this.contentStartOffset - length;
                        String text = this.document.substring(_minus, this.contentStartOffset);
                        SemanticWhitespace _semanticWhitespace = new SemanticWhitespace(text, newContentStartColumn);
                        this.indentationStack.push(_semanticWhitespace);
                    }
                }
                boolean bl3 = _lessThan = newContentStartColumn < this.contentStartColumn;
                if (_lessThan) {
                    Iterable _filter = Iterables.filter(this.indentationStack, SemanticWhitespace.class);
                    List _list = IterableExtensions.toList((Iterable)_filter);
                    for (SemanticWhitespace ws : _list) {
                        boolean _greaterThan_2;
                        int _column = ws.getColumn();
                        boolean bl4 = _greaterThan_2 = _column > newContentStartColumn;
                        if (!_greaterThan_2) continue;
                        this.indentationStack.remove(ws);
                    }
                }
                if (this._outdentThisLine) {
                    boolean _not;
                    boolean _empty = this.indentationStack.empty();
                    boolean bl5 = _not = !_empty;
                    if (_not) {
                        this.indentationStack.pop();
                    }
                    this._outdentThisLine = false;
                }
                lastLine.setIndentLength(newContentStartColumn);
                boolean bl6 = _notEquals = newContentStartColumn != 0;
                if (_notEquals) {
                    this.contentStartColumn = newContentStartColumn;
                }
                LineModel _model_3 = this.getModel();
                List<Line> _lines_2 = _model_3.getLines();
                Line _last = (Line)IterableExtensions.last(_lines_2);
                List<Chunk> _chunks = _last.getChunks();
                Iterables.addAll(_chunks, this.indentationStack);
            }
        }
        if (this.indentNextLine) {
            TemplateWhitespace _templateWhitespace = new TemplateWhitespace("");
            this.indentationStack.push(_templateWhitespace);
            this.indentNextLine = false;
        }
        this.contentStartOffset = _minus_1 = -1;
        this.content = false;
        if (startNewLine) {
            LineModel _model_4 = this.getModel();
            List<Line> _lines_3 = _model_4.getLines();
            Line _line = new Line(this.offset, semantic, charCount);
            _lines_3.add(_line);
        }
    }

    public void startContent() {
        boolean _not;
        boolean bl = _not = !this.content;
        if (_not) {
            this.contentStartOffset = this.offset;
            this.content = true;
        }
    }

    public void acceptSemanticText(final CharSequence text, RichStringLiteral origin) {
        int _plus;
        boolean _not;
        super.acceptSemanticText(text, origin);
        boolean bl = _not = !this.content;
        if (_not) {
            boolean _greaterThan;
            boolean _and = false;
            int _length = text.length();
            boolean bl2 = _greaterThan = _length > 0;
            if (!_greaterThan) {
                _and = false;
            } else {
                int _length_1 = text.length();
                int _minus = _length_1 - 1;
                IntegerRange _upTo = new IntegerRange(0, _minus);
                Functions.Function2<Boolean, Integer, Boolean> _function = new Functions.Function2<Boolean, Integer, Boolean>(){

                    public Boolean apply(Boolean v, Integer i) {
                        boolean _or = false;
                        if (v.booleanValue()) {
                            _or = true;
                        } else {
                            char _charAt = text.charAt(i);
                            boolean _isWhitespace = Character.isWhitespace(_charAt);
                            boolean _not = !_isWhitespace;
                            _or = v != false || _not;
                        }
                        return _or;
                    }
                };
                Boolean _fold = (Boolean)IterableExtensions.fold((Iterable)_upTo, (Object)false, (Functions.Function2)_function);
                boolean bl3 = _and = _greaterThan && _fold != false;
            }
            if (_and) {
                this.startContent();
            }
        }
        int _length_2 = text.length();
        this.offset = _plus = this.offset + _length_2;
    }

    public void acceptTemplateText(CharSequence text, RichStringLiteral origin) {
        int _plus;
        boolean _not;
        super.acceptTemplateText(text, origin);
        boolean bl = _not = !this.content;
        if (_not) {
            boolean _lessThan;
            LineModel _model = this.getModel();
            int _rootIndentLenght = _model.getRootIndentLenght();
            boolean bl2 = _lessThan = _rootIndentLenght < 0;
            if (_lessThan) {
                int _length_1;
                LineModel _model_1 = this.getModel();
                int _length = text.length();
                _model_1.setRootIndentLenght(_length);
                this.contentStartColumn = _length_1 = text.length();
            }
        }
        int _length_2 = text.length();
        this.offset = _plus = this.offset + _length_2;
    }

    public void acceptExpression(XExpression expression, CharSequence indentation) {
        super.acceptExpression(expression, indentation);
        this.startContent();
    }

    public void acceptIfCondition(XExpression condition) {
        super.acceptIfCondition(condition);
        this.startContent();
        this.indentNextLine = true;
    }

    public void acceptElseIfCondition(XExpression condition) {
        super.acceptElseIfCondition(condition);
        this.outdentThisLine();
        this.startContent();
        this.indentNextLine = true;
    }

    public void acceptElse() {
        super.acceptElse();
        this.outdentThisLine();
        this.startContent();
        this.indentNextLine = true;
    }

    public void acceptEndIf() {
        super.acceptEndIf();
        this.outdentThisLine();
        this.startContent();
    }

    public void acceptForLoop(JvmFormalParameter parameter, XExpression expression) {
        super.acceptForLoop(parameter, expression);
        this.startContent();
        this.indentNextLine = true;
    }

    public void acceptEndFor(XExpression after, CharSequence indentation) {
        super.acceptEndFor(after, indentation);
        this.outdentThisLine();
        this.startContent();
    }
}

