/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.macro;

import com.google.common.base.Objects;
import com.google.inject.Singleton;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;

@Singleton
public class ProcessorInstanceForJvmTypeProvider {
    private static final Logger logger = new Functions.Function0<Logger>(){

        public Logger apply() {
            Logger _logger = Logger.getLogger(ProcessorInstanceForJvmTypeProvider.class);
            return _logger;
        }
    }.apply();
    private ClassLoader classLoader;

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public Object getProcessorInstance(JvmType type) {
        try {
            ClassLoader _classLoader = this.getClassLoader((EObject)type);
            Class<?> _loadClass = null;
            if (_classLoader != null) {
                String _identifier = type.getIdentifier();
                _loadClass = _classLoader.loadClass(_identifier);
            }
            Class<?> loadClass = _loadClass;
            try {
                Object _newInstance = null;
                if (loadClass != null) {
                    _newInstance = loadClass.newInstance();
                }
                return _newInstance;
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e = (Exception)_t;
                String _string = e.toString();
                logger.error((Object)_string);
                return null;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    protected ClassLoader getClassLoader(EObject ctx) {
        boolean _notEquals;
        boolean bl = _notEquals = !Objects.equal((Object)this.classLoader, null);
        if (_notEquals) {
            return this.classLoader;
        }
        Resource _eResource = ctx.eResource();
        ResourceSet resourceSet = _eResource.getResourceSet();
        boolean _matched = false;
        if (!_matched && resourceSet instanceof XtextResourceSet) {
            XtextResourceSet _xtextResourceSet = (XtextResourceSet)resourceSet;
            _matched = true;
            Object classLoaderCtx = _xtextResourceSet.getClasspathURIContext();
            boolean _matched_1 = false;
            if (!_matched_1 && classLoaderCtx instanceof ClassLoader) {
                ClassLoader _classLoader = (ClassLoader)classLoaderCtx;
                _matched_1 = true;
                return _classLoader;
            }
            if (!_matched_1 && classLoaderCtx instanceof Class) {
                Class _class = (Class)classLoaderCtx;
                _matched_1 = true;
                return _class.getClassLoader();
            }
        }
        logger.info((Object)"No class loader configured. Trying with this class' classloader.");
        Class<?> _class = this.getClass();
        return _class.getClassLoader();
    }
}

