/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.access.jdt;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.SegmentSequence;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.xtext.common.types.access.impl.URIHelperConstants;

public class TypeURIHelper
implements URIHelperConstants {
    static final URI[] PRIMITIVE_URIS;
    static final String[] COMMON_CLASS_NAMES;
    static final String[][] COMMON_ANNOTATIONS;
    static final Map<String, URI> COMMON_URIS;
    static final Map<String, URI[]> COMMON_METHOD_URIS;
    static final Map<String, URI> COMMON_SIGNATURE_URIS;

    /*
     * WARNING - void declaration
     */
    static {
        void var0_6;
        void var0_3;
        void var0_1;
        URI[] uRIArray = new URI[25];
        uRIArray[0] = PRIMITIVES_URI.appendFragment("byte");
        uRIArray[1] = PRIMITIVES_URI.appendFragment("char");
        uRIArray[2] = PRIMITIVES_URI.appendFragment("double");
        uRIArray[4] = PRIMITIVES_URI.appendFragment("float");
        uRIArray[7] = PRIMITIVES_URI.appendFragment("int");
        uRIArray[8] = PRIMITIVES_URI.appendFragment("long");
        uRIArray[17] = PRIMITIVES_URI.appendFragment("short");
        uRIArray[20] = PRIMITIVES_URI.appendFragment("void");
        uRIArray[24] = PRIMITIVES_URI.appendFragment("boolean");
        PRIMITIVE_URIS = uRIArray;
        COMMON_CLASS_NAMES = new String[]{"java.lang.annotation.Annotation", "java.io.Serializable", "java.io.IOException", "java.lang.Boolean", "java.lang.Byte", "java.lang.Character", "java.lang.CharSequence", "java.lang.Class", "java.lang.Comparable", "java.lang.Double", "java.lang.Exception", "java.lang.Float", "java.lang.Integer", "java.lang.Iterable", "java.lang.Long", "java.lang.Math", "java.lang.Object", "java.lang.Short", "java.lang.String", "java.lang.StringBuilder", "java.lang.StringBuffer", "java.lang.Throwable", "java.lang.Void", "java.math.BigDecimal", "java.math.BigInteger", "java.util.ArrayList", "java.util.Collection", "java.util.HashMap", "java.util.HashSet", "java.util.Iterator", "java.util.List", "java.util.Map", "java.util.Set"};
        COMMON_ANNOTATIONS = new String[][]{{"com.google.common.annotations.Beta"}, {"com.google.common.annotations.GwtCompatible", "emulated", "serializable"}, {"com.google.common.annotations.GwtIncompatible", "value"}, {"java.lang.annotation.Documented"}, {"java.lang.annotation.Target", "value"}, {"java.lang.annotation.Retention", "value"}, {"java.lang.Deprecated"}, {"java.lang.Override"}, {"java.lang.SuppressWarnings", "value"}, {"org.eclipse.xtext.xbase.lib.Inline", "value", "imported", "statementExpression"}, {"org.eclipse.xtext.xbase.lib.Pure"}};
        COMMON_URIS = new HashMap<String, URI>();
        COMMON_METHOD_URIS = new HashMap<String, URI[]>();
        boolean bl = false;
        while (var0_1 < COMMON_CLASS_NAMES.length) {
            String segment = COMMON_CLASS_NAMES[var0_1];
            COMMON_URIS.put(segment, OBJECTS_URI.appendSegment(segment).appendFragment(segment));
            ++var0_1;
        }
        boolean bl2 = false;
        while (var0_3 < COMMON_ANNOTATIONS.length) {
            String[] annotations = COMMON_ANNOTATIONS[var0_3];
            String annotation = annotations[0];
            COMMON_URIS.put(annotation, OBJECTS_URI.appendSegment(annotation).appendFragment(annotation));
            if (annotations.length > 1) {
                URI[] methodURIs = new URI[annotations.length - 1];
                int j = 1;
                while (j < annotations.length) {
                    String method = String.valueOf(annotation) + "." + (String)annotations[j] + "()";
                    methodURIs[j - 1] = OBJECTS_URI.appendSegment(annotation).appendFragment(method);
                    ++j;
                }
                COMMON_METHOD_URIS.put(annotation, methodURIs);
            }
            ++var0_3;
        }
        COMMON_SIGNATURE_URIS = new HashMap<String, URI>();
        for (Map.Entry entry : COMMON_URIS.entrySet()) {
            COMMON_SIGNATURE_URIS.put(Signature.createTypeSignature((String)((String)entry.getKey()), (boolean)true), ((URI)entry.getValue()).trimFragment());
        }
        boolean bl3 = false;
        while (var0_6 < PRIMITIVE_URIS.length) {
            URI uri = PRIMITIVE_URIS[var0_6];
            if (uri != null) {
                COMMON_SIGNATURE_URIS.put(uri.fragment(), PRIMITIVES_URI);
            }
            ++var0_6;
        }
    }

    public String getFragment(String signature) {
        StringBuilder uriBuilder = new StringBuilder(32);
        this.createFragment(signature, uriBuilder);
        return uriBuilder.toString();
    }

    public URI createResourceURI(String signature) {
        URI uri = COMMON_SIGNATURE_URIS.get(signature);
        if (uri != null) {
            return uri;
        }
        StringBuilder uriBuilder = this.createURIBuilder();
        this.createResourceURI(signature, uriBuilder);
        return this.createURI(uriBuilder);
    }

    public URI createResourceURIFromString(String withoutProtocol) {
        StringBuilder uriBuilder = new StringBuilder("java".length() + 1 + withoutProtocol.length());
        uriBuilder.append("java").append(":").append(withoutProtocol);
        return this.createURI(uriBuilder);
    }

    public URI createResourceURIForFQN(String fqn) {
        return OBJECTS_URI.appendSegment(fqn);
    }

    public StringBuilder createURIBuilder() {
        StringBuilder builder = new StringBuilder(48);
        builder.append("java");
        builder.append(':');
        return builder;
    }

    protected URI createURI(StringBuilder uriBuilder) {
        return URI.createURI((String)uriBuilder.toString());
    }

    public URI getFullURI(ITypeBinding typeBinding) {
        if (typeBinding.isPrimitive()) {
            return PRIMITIVE_URIS[typeBinding.getKey().charAt(0) - 66];
        }
        if (typeBinding.isClass() || typeBinding.isInterface() || typeBinding.isAnnotation() || typeBinding.isEnum()) {
            ITypeBinding declaringClass = typeBinding.getDeclaringClass();
            if (declaringClass == null) {
                String qualifiedName = typeBinding.getErasure().getQualifiedName();
                URI uri = COMMON_URIS.get(qualifiedName);
                if (uri != null) {
                    return uri;
                }
                uri = OBJECTS_URI.appendSegment(qualifiedName);
                return uri.appendFragment(uri.lastSegment());
            }
            SegmentSequence.Builder builder = SegmentSequence.newBuilder((String)"");
            URI uri = this.getFullURI(declaringClass, builder);
            builder.append("$");
            builder.append(typeBinding.getName());
            return uri.appendFragment(builder.toString());
        }
        SegmentSequence.Builder builder = SegmentSequence.newBuilder((String)"");
        URI uri = this.getFullURI(typeBinding, builder);
        return uri.appendFragment(builder.toString());
    }

    protected URI getFullURI(ITypeBinding typeBinding, SegmentSequence.Builder builder) {
        if (typeBinding.isPrimitive()) {
            builder.append(PRIMITIVE_URIS[typeBinding.getKey().charAt(0) - 66].fragment());
            return PRIMITIVES_URI;
        }
        if (typeBinding.isClass() || typeBinding.isInterface() || typeBinding.isAnnotation() || typeBinding.isEnum()) {
            ITypeBinding declaringClass = typeBinding.getDeclaringClass();
            if (declaringClass != null) {
                URI uri = this.getFullURI(declaringClass, builder);
                builder.append("$");
                builder.append(typeBinding.getName());
                return uri;
            }
            String qualifiedName = typeBinding.getErasure().getQualifiedName();
            URI uri = COMMON_URIS.get(qualifiedName);
            if (uri == null) {
                uri = OBJECTS_URI.appendSegment(qualifiedName);
            }
            builder.append(uri.lastSegment());
            return uri;
        }
        if (typeBinding.isArray()) {
            URI uri = this.getFullURI(typeBinding.getComponentType(), builder);
            builder.append("[]");
            return uri;
        }
        if (typeBinding.isTypeVariable()) {
            ITypeBinding declaringClass = typeBinding.getDeclaringClass();
            if (declaringClass != null) {
                URI uri = this.getFullURI(declaringClass, builder);
                builder.append("/");
                builder.append(typeBinding.getName());
                return uri;
            }
            IMethodBinding declaringMethod = typeBinding.getDeclaringMethod();
            URI uri = this.getFullURI(declaringMethod.getDeclaringClass(), builder);
            builder.append(".");
            builder.append(declaringMethod.getName());
            builder.append("(");
            ITypeBinding[] parameterTypes = declaringMethod.getParameterTypes();
            int i = 0;
            while (i < parameterTypes.length) {
                if (i != 0) {
                    builder.append(",");
                }
                this.getQualifiedName(parameterTypes[i], builder);
                ++i;
            }
            builder.append(")");
            builder.append("/");
            builder.append(typeBinding.getName());
            return uri;
        }
        throw new IllegalStateException("Unexpected type: " + typeBinding);
    }

    protected void getFullURI(ITypeBinding typeBinding, StringBuilder uriBuilder) {
        this.createResourceURI(typeBinding, uriBuilder);
        uriBuilder.append('#');
        this.createFragment(typeBinding, uriBuilder);
    }

    public URI getFullURI(IVariableBinding binding) {
        SegmentSequence.Builder builder = SegmentSequence.newBuilder((String)"");
        URI uri = this.getFullURI(binding.getDeclaringClass(), builder);
        builder.append(".");
        builder.append(binding.getName());
        return uri.appendFragment(builder.toString());
    }

    public URI getFullURI(IMethodBinding binding) {
        StringBuilder uriBuilder = this.createURIBuilder();
        this.getFullURI(binding.getDeclaringClass(), uriBuilder);
        uriBuilder.append(".");
        uriBuilder.append(binding.getName());
        uriBuilder.append("(");
        ITypeBinding[] parameterTypes = binding.getParameterTypes();
        int i = 0;
        while (i < parameterTypes.length) {
            if (i != 0) {
                uriBuilder.append(',');
            }
            uriBuilder.append(this.getQualifiedName(parameterTypes[i]));
            ++i;
        }
        uriBuilder.append(")");
        return this.createURI(uriBuilder);
    }

    public URI getFullURI(IBinding binding) {
        if (binding instanceof ITypeBinding) {
            return this.getFullURI((ITypeBinding)binding);
        }
        if (binding instanceof IMethodBinding) {
            return this.getFullURI((IMethodBinding)binding);
        }
        if (binding instanceof IVariableBinding) {
            return this.getFullURI((IVariableBinding)binding);
        }
        return null;
    }

    public URI getFullURI(IJavaElement javaElement) {
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setProject(javaElement.getJavaProject());
        IBinding[] bindings = parser.createBindings(new IJavaElement[]{javaElement}, null);
        if (bindings[0] != null) {
            return this.getFullURI(bindings[0]);
        }
        return null;
    }

    public URI getFullURIForClass(String fqn) {
        StringBuilder uriBuilder = this.createURIBuilder();
        this.createResourceURIForClassImpl2(fqn, uriBuilder);
        uriBuilder.append('#');
        this.createFragmentForClass2(fqn, uriBuilder);
        return this.createURI(uriBuilder);
    }

    public URI getFullURI(ITypeBinding typeBinding, String method) {
        SegmentSequence.Builder builder = SegmentSequence.newBuilder((String)"");
        URI uri = this.getFullURI(typeBinding, builder);
        URI[] uris = COMMON_METHOD_URIS.get(uri.lastSegment());
        if (uris != null) {
            URI[] uRIArray = uris;
            int n = uris.length;
            int n2 = 0;
            while (n2 < n) {
                URI methodURI = uRIArray[n2];
                String fragment = methodURI.fragment();
                if (fragment.startsWith(method, fragment.length() - method.length() - 2)) {
                    return methodURI;
                }
                ++n2;
            }
        }
        builder.append(".").append(method).append("()");
        return uri.appendFragment(builder.toString());
    }

    protected void createFragment(ITypeBinding typeBinding, StringBuilder uriBuilder) {
        if (typeBinding.isPrimitive()) {
            this.createFragmentForPrimitive(typeBinding, uriBuilder);
            return;
        }
        if (typeBinding.isArray()) {
            this.createFragmentForArray(typeBinding, uriBuilder);
            return;
        }
        if (typeBinding.isTypeVariable()) {
            this.createFragmentForTypeVariable(typeBinding, uriBuilder);
            return;
        }
        if (typeBinding.isAnnotation() || typeBinding.isClass() || typeBinding.isInterface() || typeBinding.isEnum()) {
            this.createFragmentForClass(typeBinding, uriBuilder);
            return;
        }
        throw new IllegalStateException("Unexpected type binding: " + typeBinding);
    }

    protected void createFragment(String signature, StringBuilder uriBuilder) {
        int signatureKind = Signature.getTypeSignatureKind((String)signature);
        switch (signatureKind) {
            case 2: {
                this.createFragmentForPrimitive(signature, uriBuilder);
                return;
            }
            case 1: {
                this.createFragmentForClass(signature, uriBuilder);
                return;
            }
            case 4: {
                this.createFragmentForArray(signature, uriBuilder);
                return;
            }
            case 3: {
                this.createFragmentForTypeVariable(signature, uriBuilder);
                return;
            }
        }
        throw new IllegalStateException("Unexpected Signature: " + signature);
    }

    protected void createFragmentForTypeVariable(ITypeBinding typeBinding, StringBuilder uriBuilder) {
        if (typeBinding.getDeclaringMethod() != null) {
            this.createFragmentForMethod(typeBinding.getDeclaringMethod(), uriBuilder);
        } else {
            this.createFragment(typeBinding.getDeclaringClass(), uriBuilder);
        }
        uriBuilder.append('/');
        uriBuilder.append(typeBinding.getName());
    }

    protected void createFragmentForTypeVariable(String signature, StringBuilder uriBuilder) {
        String readable = Signature.toString((String)signature);
        uriBuilder.append('/');
        uriBuilder.append(readable);
    }

    protected void createFragmentForMethod(IMethodBinding method, StringBuilder uriBuilder) {
        ITypeBinding declaringType = method.getDeclaringClass();
        this.createFragmentForClass(declaringType, uriBuilder);
        uriBuilder.append('.');
        uriBuilder.append(method.getName());
        uriBuilder.append('(');
        ITypeBinding[] parameterTypes = method.getParameterTypes();
        int i = 0;
        while (i < parameterTypes.length) {
            if (i != 0) {
                uriBuilder.append(',');
            }
            this.getQualifiedName(parameterTypes[i], uriBuilder);
            ++i;
        }
        uriBuilder.append(')');
    }

    public String getQualifiedName(ITypeBinding binding) {
        if (binding.isParameterizedType()) {
            return this.getQualifiedName(binding.getErasure());
        }
        if (binding.isArray()) {
            return this.getQualifiedName(binding.getComponentType(), new StringBuilder()).append("[]").toString();
        }
        if (binding.isTopLevel() || binding.isTypeVariable() || binding.isPrimitive()) {
            return binding.getQualifiedName();
        }
        return this.getQualifiedName(binding.getDeclaringClass(), new StringBuilder()).append('$').append(binding.getName()).toString();
    }

    public StringBuilder getQualifiedName(ITypeBinding binding, StringBuilder stringBuilder) {
        if (binding.isParameterizedType()) {
            this.getQualifiedName(binding.getErasure(), stringBuilder);
        } else if (binding.isArray()) {
            this.getQualifiedName(binding.getComponentType(), stringBuilder).append("[]");
        } else if (binding.isTopLevel() || binding.isTypeVariable() || binding.isPrimitive()) {
            stringBuilder.append(binding.getQualifiedName());
        } else {
            this.getQualifiedName(binding.getDeclaringClass(), stringBuilder).append('$').append(binding.getName());
        }
        return stringBuilder;
    }

    protected SegmentSequence.Builder getQualifiedName(ITypeBinding binding, SegmentSequence.Builder builder) {
        if (binding.isParameterizedType()) {
            this.getQualifiedName(binding.getErasure(), builder);
        } else if (binding.isArray()) {
            this.getQualifiedName(binding.getComponentType(), builder).append("[]");
        } else if (binding.isTopLevel() || binding.isTypeVariable() || binding.isPrimitive()) {
            builder.append(binding.getQualifiedName());
        } else {
            this.getQualifiedName(binding.getDeclaringClass(), builder).append('$').append(binding.getName());
        }
        return builder;
    }

    public String computeTypeName(String signature) {
        StringBuilder result = new StringBuilder(64);
        this.computeTypeName(signature, result);
        return result.toString();
    }

    public void computeTypeName(String signature, StringBuilder uriBuilder) {
        int signatureKind = Signature.getTypeSignatureKind((String)signature);
        switch (signatureKind) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                String erased = this.getTypeErasure(signature);
                uriBuilder.append(Signature.toString((String)erased));
                return;
            }
        }
        throw new IllegalStateException("Unexpected Signature: " + signature);
    }

    public String getTypeErasure(String signature) {
        String fixedSignature = signature.replaceAll(">\\.", ">\\$");
        return Signature.getTypeErasure((String)fixedSignature);
    }

    public String computeParameterizedTypeName(String signature) {
        StringBuilder result = new StringBuilder(64);
        this.computeParameterizedTypeName(signature, result);
        return result.toString();
    }

    public void computeParameterizedTypeName(String signature, StringBuilder uriBuilder) {
        this.computeTypeName(signature, uriBuilder);
        String[] typeArguments = Signature.getTypeArguments((String)signature);
        if (typeArguments.length != 0) {
            uriBuilder.append('<');
            int i = 0;
            while (i < typeArguments.length) {
                if (i != 0) {
                    uriBuilder.append(',');
                }
                this.computeParameter(typeArguments[i], uriBuilder);
                ++i;
            }
            uriBuilder.append('>');
        }
    }

    public void computeParameter(String signature, StringBuilder uriBuilder) {
        block6: {
            block5: {
                int signatureKind = Signature.getTypeSignatureKind((String)signature);
                if (signatureKind != 5) break block5;
                switch (signature.charAt(0)) {
                    case '*': {
                        uriBuilder.append("? extends java.lang.Object");
                        break block6;
                    }
                    case '+': {
                        uriBuilder.append("? extends ");
                        String upperBoundSignature = signature.substring(1);
                        this.computeParameterizedTypeName(upperBoundSignature, uriBuilder);
                        break block6;
                    }
                    case '-': {
                        uriBuilder.append("? extends java.lang.Object & super ");
                        String lowerBoundSignature = signature.substring(1);
                        this.computeParameterizedTypeName(lowerBoundSignature, uriBuilder);
                        break block6;
                    }
                    default: {
                        throw new IllegalArgumentException("Signature: " + signature);
                    }
                }
            }
            this.computeParameterizedTypeName(signature, uriBuilder);
        }
    }

    protected void createFragmentForPrimitive(ITypeBinding typeBinding, StringBuilder uriBuilder) {
        uriBuilder.append(typeBinding.getName());
    }

    protected void createFragmentForPrimitive(String signature, StringBuilder uriBuilder) {
        uriBuilder.append(Signature.toString((String)signature));
    }

    protected void createFragmentForArray(ITypeBinding typeBinding, StringBuilder uriBuilder) {
        this.createFragment(typeBinding.getComponentType(), uriBuilder);
        uriBuilder.append("[]");
    }

    protected void createFragmentForArray(String signature, StringBuilder uriBuilder) {
        String elementType = Signature.getElementType((String)signature);
        this.createFragment(elementType, uriBuilder);
        int dim = Signature.getArrayCount((String)signature);
        int i = 0;
        while (i < dim) {
            uriBuilder.append("[]");
            ++i;
        }
    }

    protected void createFragmentForClass(ITypeBinding typeBinding, StringBuilder uriBuilder) {
        this.createFragmentForClass2(this.getQualifiedName(typeBinding), uriBuilder);
    }

    protected void createFragmentForClass2(String fqn, StringBuilder uriBuilder) {
        uriBuilder.append(fqn);
    }

    protected void createFragmentForClass(String signature, StringBuilder uriBuilder) {
        String fragment = Signature.toString((String)signature);
        int start = signature.length();
        int lastDot = fragment.length();
        while ((start = signature.lastIndexOf(36, start)) >= 0) {
            lastDot = fragment.lastIndexOf(46, lastDot);
            fragment = String.valueOf(fragment.substring(0, lastDot)) + '$' + fragment.substring(lastDot + 1);
            --start;
        }
        uriBuilder.append(fragment);
    }

    protected void createResourceURI(ITypeBinding typeBinding, StringBuilder uriBuilder) {
        if (typeBinding.isPrimitive()) {
            this.createResourceURIForPrimitive(uriBuilder);
            return;
        }
        if (typeBinding.isClass() || typeBinding.isInterface() || typeBinding.isAnnotation() || typeBinding.isEnum()) {
            this.createResourceURIForClass(typeBinding, uriBuilder);
            return;
        }
        if (typeBinding.isArray()) {
            this.createResourceURIForArray(typeBinding, uriBuilder);
            return;
        }
        if (typeBinding.isTypeVariable()) {
            this.createResourceURIForTypeVariable(typeBinding, uriBuilder);
            return;
        }
        throw new IllegalStateException("Unexpected type: " + typeBinding);
    }

    protected void createResourceURI(String signature, StringBuilder uriBuilder) {
        try {
            int signatureKind = Signature.getTypeSignatureKind((String)signature);
            switch (signatureKind) {
                case 2: {
                    this.createResourceURIForPrimitive(uriBuilder);
                    return;
                }
                case 1: {
                    this.createResourceURIForClass(signature, uriBuilder);
                    return;
                }
                case 4: {
                    this.createResourceURIForArray(signature, uriBuilder);
                    return;
                }
            }
            throw new IllegalStateException("Unexpected Signature: " + signature);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.valueOf(e.getMessage()) + " was: " + signature, e);
        }
    }

    protected URI createResourceURIForPrimitive() {
        return PRIMITIVES_URI;
    }

    protected void createResourceURIForPrimitive(StringBuilder uriBuilder) {
        uriBuilder.append("/Primitives");
    }

    protected void createResourceURIForArray(ITypeBinding typeBinding, StringBuilder uriBuilder) {
        ITypeBinding componentType = typeBinding.getComponentType();
        this.createResourceURI(componentType, uriBuilder);
    }

    protected void createResourceURIForArray(String signature, StringBuilder uriBuilder) {
        String elementType = Signature.getElementType((String)signature);
        this.createResourceURI(elementType, uriBuilder);
    }

    protected void createResourceURIForClass(ITypeBinding typeBinding, StringBuilder uriBuilder) {
        ITypeBinding declaringClass = typeBinding.getDeclaringClass();
        if (declaringClass != null) {
            this.createResourceURIForClass(declaringClass, uriBuilder);
        } else {
            this.createResourceURIForClassImpl2(typeBinding.getErasure().getQualifiedName(), uriBuilder);
        }
    }

    protected void createResourceURIForClass(String signature, StringBuilder uriBuilder) {
        this.createResourceURIForClassImpl(signature, uriBuilder);
    }

    protected void createResourceURIForClassImpl2(String fqn, StringBuilder uriBuilder) {
        uriBuilder.append("/Objects/").append(fqn);
    }

    protected void createResourceURIForClassImpl(String signature, StringBuilder uriBuilder) {
        String topLevel = signature;
        int idx = topLevel.indexOf(36);
        topLevel = idx != -1 ? ((topLevel = String.valueOf(topLevel.substring(0, idx)) + ';').endsWith(".;") || topLevel.endsWith("$;") ? signature.substring(1, signature.length() - 1) : Signature.toString((String)topLevel)) : Signature.toString((String)topLevel);
        uriBuilder.append("/Objects/").append(topLevel);
    }

    protected void createResourceURIForTypeVariable(ITypeBinding typeBinding, StringBuilder uriBuilder) {
        if (typeBinding.getDeclaringClass() != null) {
            ITypeBinding declaringClass = typeBinding.getDeclaringClass();
            this.createResourceURIForClass(declaringClass, uriBuilder);
        } else {
            IMethodBinding declaringMethod = typeBinding.getDeclaringMethod();
            ITypeBinding declaringClass = declaringMethod.getDeclaringClass();
            this.createResourceURIForClass(declaringClass, uriBuilder);
        }
    }
}

