/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.ui.refactoring;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.refactoring.descriptors.RenameJavaElementDescriptor;
import org.eclipse.jdt.ui.refactoring.RenameSupport;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.common.types.ui.refactoring.JdtRefactoringContext;
import org.eclipse.xtext.common.types.ui.refactoring.JvmRenameRefactoringProvider;
import org.eclipse.xtext.ui.refactoring.ui.DefaultRenameSupport;
import org.eclipse.xtext.ui.refactoring.ui.IRenameSupport;

public class JdtRenameSupport
implements IRenameSupport {
    private RenameSupport renameSupport;
    private JdtRefactoringContext renameParticipantContext;

    @Deprecated
    public JdtRenameSupport(RenameJavaElementDescriptor renameDescriptor) throws CoreException {
        this.renameSupport = RenameSupport.create((RenameJavaElementDescriptor)renameDescriptor);
    }

    public JdtRenameSupport() {
    }

    protected void initialize(JdtRefactoringContext renameParticipantContext, RenameJavaElementDescriptor renameDescriptor) throws CoreException {
        this.renameParticipantContext = renameParticipantContext;
        this.renameSupport = RenameSupport.create((RenameJavaElementDescriptor)renameDescriptor);
    }

    public void startRefactoringWithDialog(boolean previewOnly) throws InterruptedException {
        try {
            this.renameSupport.openDialog(this.getShell(), previewOnly);
        }
        catch (CoreException e) {
            throw new WrappedException((Exception)((Object)e));
        }
    }

    public void startDirectRefactoring() throws InterruptedException {
        try {
            this.renameSupport.perform(this.getShell(), (IRunnableContext)PlatformUI.getWorkbench().getActiveWorkbenchWindow());
        }
        catch (InvocationTargetException e) {
            throw new WrappedException((Exception)e);
        }
    }

    protected Shell getShell() {
        Shell activeShell = Display.getDefault().getActiveShell();
        return activeShell != null ? activeShell : Display.getDefault().getShells()[0];
    }

    public static class Factory
    extends DefaultRenameSupport.Factory {
        @Inject
        private JvmRenameRefactoringProvider jvmRenameRefactorigProvider;
        @Inject
        private Provider<JdtRenameSupport> jdtRenameSupportProvider;

        public IRenameSupport create(Object context, String newName) {
            if (context instanceof JdtRefactoringContext) {
                try {
                    RenameJavaElementDescriptor descriptor = this.createDescriptor((JdtRefactoringContext)((Object)context), newName);
                    JdtRenameSupport jdtRenameSupport = (JdtRenameSupport)this.jdtRenameSupportProvider.get();
                    jdtRenameSupport.initialize((JdtRefactoringContext)((Object)context), descriptor);
                    return jdtRenameSupport;
                }
                catch (Exception exc) {
                    throw new WrappedException(exc);
                }
            }
            return super.create(context, newName);
        }

        @Deprecated
        protected RenameJavaElementDescriptor createDescriptor(JdtRefactoringContext renameElementContext, String newName) throws JavaModelException {
            return this.jvmRenameRefactorigProvider.createRenameDescriptor(renameElementContext.getJavaElement(), newName);
        }
    }
}

