/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.access.binary;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.access.TypeResource;
import org.eclipse.xtext.common.types.access.binary.BinaryClass;
import org.eclipse.xtext.common.types.access.impl.AbstractClassMirror;
import org.eclipse.xtext.common.types.access.impl.ITypeFactory;

public class BinaryClassMirror
extends AbstractClassMirror {
    private final BinaryClass binaryClass;
    private final boolean sealed;
    private final ITypeFactory<BinaryClass, JvmDeclaredType> typeFactory;

    public static BinaryClassMirror createClassMirror(BinaryClass binaryClass, ITypeFactory<BinaryClass, JvmDeclaredType> typeFactory) {
        return BinaryClassMirror.createClassMirror(binaryClass, typeFactory, true);
    }

    public static BinaryClassMirror createClassMirror(BinaryClass binaryClass, ITypeFactory<BinaryClass, JvmDeclaredType> typeFactory, boolean sealed) {
        if (binaryClass.isPrimitive() || binaryClass.isArray()) {
            throw new IllegalArgumentException("Cannot create class mirror for " + binaryClass.getName());
        }
        return new BinaryClassMirror(binaryClass, typeFactory, sealed);
    }

    protected BinaryClassMirror(BinaryClass binaryClass, ITypeFactory<BinaryClass, JvmDeclaredType> typeFactory, boolean sealed) {
        this.binaryClass = binaryClass;
        this.typeFactory = typeFactory;
        this.sealed = sealed;
    }

    @Deprecated
    protected BinaryClassMirror(BinaryClass binaryClass, ITypeFactory<BinaryClass, JvmDeclaredType> typeFactory) {
        this(binaryClass, typeFactory, true);
    }

    @Override
    protected String getTypeName() {
        return this.binaryClass.getName();
    }

    @Override
    public void initialize(TypeResource typeResource) {
        typeResource.getContents().add((Object)this.typeFactory.createType(this.binaryClass));
    }

    public BinaryClass getMirroredBinaryClass() {
        return this.binaryClass;
    }

    @Override
    public URI getLocationURI(Resource resource) {
        return this.binaryClass.getLocationURI();
    }

    public Class<?> getMirroredClass() {
        try {
            return Class.forName(this.binaryClass.getName(), false, this.binaryClass.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public boolean isSealed() {
        return this.sealed;
    }
}

