/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.highlighting;

import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.ui.css.swt.theme.ITheme;
import org.eclipse.e4.ui.css.swt.theme.IThemeEngine;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtend.ide.highlighting.XtendHighlightingConfiguration;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class XtendThemeManager
implements EventHandler {
    public void handleEvent(Event event) {
        if (!"org/eclipse/e4/ui/css/swt/theme/ThemeManager/themeChanged".equals(event.getTopic())) {
            return;
        }
        IThemeEngine themeEngine = (IThemeEngine)PlatformUI.getWorkbench().getService(IThemeEngine.class);
        ITheme theme = themeEngine.getActiveTheme();
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.xtend.core.Xtend");
        if (!theme.getId().contains("dark")) {
            XtendHighlightingConfiguration highlightingConfiguration = new XtendHighlightingConfiguration();
            highlightingConfiguration.configure((id, name, style) -> {
                this.setColorPreference(preferences, this.getSyntaxHightlightingPreferenceKey(id, "color"), style.getColor());
                this.setColorPreference(preferences, this.getSyntaxHightlightingPreferenceKey(id, "bgColor"), style.getBackgroundColor());
                String styleKey = this.getSyntaxHightlightingPreferenceKey(id, "style");
                int styleMask = style.getStyle();
                if (preferences.getInt(styleKey, -1) != -1) {
                    preferences.remove(styleKey);
                }
                if (styleMask > 0) {
                    preferences.putInt(styleKey, styleMask);
                }
            });
        }
        themeEngine.applyStyles((Object)preferences, false);
    }

    private void setColorPreference(IEclipsePreferences preferences, String colorPreferenceKey, RGB color) {
        if (color != null) {
            preferences.put(colorPreferenceKey, this.encodeColor(color));
        } else if (preferences.get(colorPreferenceKey, null) != null) {
            preferences.remove(colorPreferenceKey);
        }
    }

    private String getSyntaxHightlightingPreferenceKey(String id, String suffix) {
        return String.format("%s.%s.%s.%s.%s", "org.eclipse.xtend.core.Xtend", "syntaxColorer", "tokenStyles", id, suffix);
    }

    private String encodeColor(RGB color) {
        return String.format("%d,%d,%d", color.red, color.green, color.blue);
    }
}

