/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.formatting2.internal;

import org.eclipse.xtext.formatting2.AbstractFormatter2;
import org.eclipse.xtext.formatting2.FormatterPreferenceKeys;
import org.eclipse.xtext.formatting2.FormatterRequest;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.formatting2.IFormattableSubDocument;
import org.eclipse.xtext.formatting2.ITextReplacerContext;
import org.eclipse.xtext.formatting2.ITextSegment;
import org.eclipse.xtext.formatting2.internal.FormattableDocument;
import org.eclipse.xtext.formatting2.internal.ICompositeTextReplacer;
import org.eclipse.xtext.formatting2.internal.MaxLineWidthDocument;
import org.eclipse.xtext.formatting2.internal.TextReplacerContext;
import org.eclipse.xtext.formatting2.internal.TextSegment;

public class SubDocument
extends FormattableDocument
implements IFormattableSubDocument,
ICompositeTextReplacer {
    private final IFormattableDocument parent;
    private final ITextSegment region;

    public SubDocument(ITextSegment region, IFormattableDocument parent) {
        this.region = region;
        this.parent = parent;
    }

    @Override
    public ITextReplacerContext createReplacements(ITextReplacerContext previous) {
        ITextReplacerContext context = ((TextReplacerContext)previous).withDocument(this);
        context.setNextReplacerIsChild();
        return ((TextReplacerContext)super.createReplacements(context)).withDocument(previous.getDocument());
    }

    @Override
    public AbstractFormatter2 getFormatter() {
        return this.parent.getFormatter();
    }

    @Override
    public ITextSegment getRegion() {
        return this.region;
    }

    @Override
    public FormatterRequest getRequest() {
        return this.parent.getRequest();
    }

    @Override
    public IFormattableSubDocument requireFitsInLine() {
        return this.requireFitsInLine(this.region.getOffset(), this.region.getLength());
    }

    public IFormattableSubDocument requireFitsInLine(int offset, int length) {
        Integer maxLineWidth = this.getRequest().getPreferences().getPreference(FormatterPreferenceKeys.maxLineWidth);
        return this.requireFitsInLine(offset, length, maxLineWidth);
    }

    @Override
    public IFormattableSubDocument requireFitsInLine(int offset, int length, int maxLineWidth) {
        TextSegment segment = new TextSegment(this.getTextRegionAccess(), offset, length);
        MaxLineWidthDocument document = new MaxLineWidthDocument(segment, this, maxLineWidth);
        this.addReplacer(document);
        return document;
    }
}

