/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.formatting2.internal;

import com.google.common.base.Preconditions;
import org.eclipse.xtext.formatting2.ITextReplacement;
import org.eclipse.xtext.formatting2.internal.AbstractTextSegment;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionAccess;

public class TextReplacement
extends AbstractTextSegment
implements ITextReplacement {
    private final int length;
    private final int offset;
    private final String replacement;
    private final ITextRegionAccess tokens;

    public TextReplacement(ITextRegionAccess tokens, int offset, int length, String text) {
        Preconditions.checkArgument((offset >= 0 ? 1 : 0) != 0, (Object)"offset must be >= 0");
        Preconditions.checkArgument((length >= 0 ? 1 : 0) != 0, (Object)"length must be >= 0");
        this.tokens = tokens;
        this.offset = offset;
        this.length = length;
        this.replacement = text;
    }

    public int getLength() {
        return this.length;
    }

    public int getOffset() {
        return this.offset;
    }

    @Override
    public String getReplacementText() {
        return this.replacement;
    }

    @Override
    public ITextRegionAccess getTextRegionAccess() {
        return this.tokens;
    }

    public String toString() {
        return "[" + this.getText() + "|" + this.getReplacementText() + "]";
    }
}

