/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.macro;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.macro.file.FileLocations;
import org.eclipse.xtend.lib.macro.file.Path;
import org.eclipse.xtext.generator.IContextualOutputConfigurationProvider;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.workspace.IProjectConfig;
import org.eclipse.xtext.workspace.IProjectConfigProvider;
import org.eclipse.xtext.workspace.ISourceFolder;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;

public class FileLocationsImpl
implements FileLocations {
    @Inject
    @Accessors
    private IProjectConfigProvider projectInformationProvider;
    @Inject
    @Accessors
    private IContextualOutputConfigurationProvider outputConfigurationProvider;
    @Accessors
    private Resource context;

    protected IProjectConfig getProjectConfig(Path path) {
        String _name;
        boolean _notEquals;
        List _segments = path.getSegments();
        String firstSegment = (String)_segments.get(0);
        ResourceSet _resourceSet = this.context.getResourceSet();
        IProjectConfig projectConfig = this.projectInformationProvider.getProjectConfig(_resourceSet);
        boolean _or = false;
        _or = projectConfig == null ? true : (_notEquals = !Objects.equal((Object)(_name = projectConfig.getName()), (Object)firstSegment));
        if (_or) {
            throw new IllegalArgumentException("The project '" + firstSegment + "' has not been configured.");
        }
        return projectConfig;
    }

    public Path getSourceFolder(final Path path) {
        Set<Path> _projectSourceFolders = this.getProjectSourceFolders(path);
        Functions.Function1<Path, Boolean> _function = new Functions.Function1<Path, Boolean>(){

            public Boolean apply(Path sourceFolder) {
                return path.startsWith(sourceFolder);
            }
        };
        return (Path)IterableExtensions.findFirst(_projectSourceFolders, (Functions.Function1)_function);
    }

    public Path getTargetFolder(Path path) {
        Path _xblockexpression = null;
        Path projectFolder = this.getProjectFolder(path);
        boolean _equals = Objects.equal((Object)projectFolder, null);
        if (_equals) {
            return null;
        }
        Set _outputConfigurations = this.outputConfigurationProvider.getOutputConfigurations(this.context);
        OutputConfiguration outputConfiguration = (OutputConfiguration)IterableExtensions.head((Iterable)_outputConfigurations);
        Path sourceFolder = this.getSourceFolder(path);
        String _xifexpression = null;
        boolean _equals_1 = Objects.equal((Object)sourceFolder, null);
        if (_equals_1) {
            _xifexpression = outputConfiguration.getOutputDirectory();
        } else {
            String _xblockexpression_1 = null;
            List _segments = sourceFolder.getSegments();
            Iterable _tail = IterableExtensions.tail((Iterable)_segments);
            String projectRelativeSourceFolder = IterableExtensions.join((Iterable)_tail, (CharSequence)"/");
            _xifexpression = _xblockexpression_1 = outputConfiguration.getOutputDirectory(projectRelativeSourceFolder);
        }
        String outputFolder = _xifexpression;
        _xblockexpression = projectFolder.append(outputFolder);
        return _xblockexpression;
    }

    public Path getProjectFolder(Path path) {
        IProjectConfig config = this.getProjectConfig(path);
        String _name = config.getName();
        return Path.ROOT.append(_name);
    }

    public Set<Path> getProjectSourceFolders(final Path path) {
        IProjectConfig _projectConfig = this.getProjectConfig(path);
        Set _sourceFolders = _projectConfig.getSourceFolders();
        Functions.Function1<ISourceFolder, Path> _function = new Functions.Function1<ISourceFolder, Path>(){

            public Path apply(ISourceFolder it) {
                Path _projectFolder = FileLocationsImpl.this.getProjectFolder(path);
                String _name = it.getName();
                return _projectFolder.append(_name);
            }
        };
        Iterable _map = IterableExtensions.map((Iterable)_sourceFolders, (Functions.Function1)_function);
        return IterableExtensions.toSet((Iterable)_map);
    }

    @Pure
    public IProjectConfigProvider getProjectInformationProvider() {
        return this.projectInformationProvider;
    }

    public void setProjectInformationProvider(IProjectConfigProvider projectInformationProvider) {
        this.projectInformationProvider = projectInformationProvider;
    }

    @Pure
    public IContextualOutputConfigurationProvider getOutputConfigurationProvider() {
        return this.outputConfigurationProvider;
    }

    public void setOutputConfigurationProvider(IContextualOutputConfigurationProvider outputConfigurationProvider) {
        this.outputConfigurationProvider = outputConfigurationProvider;
    }

    @Pure
    public Resource getContext() {
        return this.context;
    }

    public void setContext(Resource context) {
        this.context = context;
    }
}

