/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext;

import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.xtext.AbstractMetamodelDeclaration;
import org.eclipse.xtext.GeneratedMetamodel;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.ReferencedMetamodel;
import org.eclipse.xtext.TypeRef;
import org.eclipse.xtext.XtextPackage;
import org.eclipse.xtext.conversion.IValueConverterService;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.impl.GeneratedMetamodelImpl;
import org.eclipse.xtext.linking.impl.DefaultLinkingService;
import org.eclipse.xtext.linking.impl.IllegalNodeException;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.BidiIterator;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.ClasspathUriResolutionException;
import org.eclipse.xtext.resource.DerivedStateAwareResource;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsProvider;
import org.eclipse.xtext.scoping.IGlobalScopeProvider;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.xtext.XtextMetamodelReferenceHelper;

public class XtextLinkingService
extends DefaultLinkingService {
    private static final Logger log = Logger.getLogger(XtextLinkingService.class);
    @Inject
    private IValueConverterService valueConverterService;
    @Inject
    private IGlobalScopeProvider scopeProvider;
    @Inject
    private ResourceDescriptionsProvider descriptionsProvider;
    private String fileExtension = "xtext";

    @Inject
    public void setFileExtension(@Named(value="file.extensions") String fileExtension) {
        this.fileExtension = fileExtension.split(",")[0];
    }

    @Override
    public List<EObject> getLinkedObjects(EObject context, EReference ref, INode node) throws IllegalNodeException {
        if (ref == XtextPackage.eINSTANCE.getGrammar_UsedGrammars()) {
            return this.getUsedGrammar((Grammar)context, node);
        }
        if (ref == XtextPackage.eINSTANCE.getTypeRef_Metamodel()) {
            return this.getLinkedMetaModel((TypeRef)context, ref, (ILeafNode)node);
        }
        if (ref == XtextPackage.eINSTANCE.getAbstractMetamodelDeclaration_EPackage() && context instanceof GeneratedMetamodel) {
            return this.createPackage((GeneratedMetamodel)context, (ILeafNode)node);
        }
        if (ref == XtextPackage.eINSTANCE.getAbstractMetamodelDeclaration_EPackage() && context instanceof ReferencedMetamodel) {
            return this.getPackage((ReferencedMetamodel)context, (ILeafNode)node);
        }
        return super.getLinkedObjects(context, ref, node);
    }

    private List<EObject> getUsedGrammar(Grammar grammar, INode node) {
        try {
            String grammarName = (String)this.valueConverterService.toValue("", "GrammarID", node);
            if (grammarName != null) {
                Grammar usedGrammar;
                ResourceSet resourceSet = grammar.eResource().getResourceSet();
                EList resources = resourceSet.getResources();
                int i = 0;
                while (i < resources.size()) {
                    Grammar otherGrammar;
                    Resource resource = (Resource)resources.get(i);
                    EObject rootElement = null;
                    if (resource instanceof XtextResource) {
                        IParseResult parseResult = ((XtextResource)resource).getParseResult();
                        if (parseResult != null) {
                            rootElement = parseResult.getRootASTElement();
                        }
                    } else if (!resource.getContents().isEmpty()) {
                        rootElement = (EObject)resource.getContents().get(0);
                    }
                    if (rootElement instanceof Grammar && grammarName.equals((otherGrammar = (Grammar)rootElement).getName())) {
                        if (resource instanceof DerivedStateAwareResource) {
                            resource.getContents();
                        }
                        return Collections.singletonList(otherGrammar);
                    }
                    ++i;
                }
                URI classpathURI = URI.createURI((String)("classpath:/" + grammarName.replace('.', '/') + "." + this.fileExtension));
                URI normalizedURI = null;
                if (resourceSet instanceof XtextResourceSet) {
                    XtextResourceSet set = (XtextResourceSet)resourceSet;
                    normalizedURI = set.getClasspathUriResolver().resolve(set.getClasspathURIContext(), classpathURI);
                } else {
                    normalizedURI = resourceSet.getURIConverter().normalize(classpathURI);
                }
                Resource resource = resourceSet.getResource(normalizedURI, true);
                if (!resource.getContents().isEmpty() && grammarName.equals((usedGrammar = (Grammar)resource.getContents().get(0)).getName())) {
                    return Collections.singletonList(usedGrammar);
                }
            }
            return Collections.emptyList();
        }
        catch (ClasspathUriResolutionException e) {
            log.debug((Object)"Cannot load used grammar.", (Throwable)e);
            return Collections.emptyList();
        }
        catch (ValueConverterException e) {
            log.debug((Object)"Cannot load used grammar.", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private List<EObject> getPackage(ReferencedMetamodel context, ILeafNode text) {
        String nsUri = this.getMetamodelNsURI(text);
        if (nsUri == null) {
            return Collections.emptyList();
        }
        Grammar grammar = GrammarUtil.getGrammar(context);
        HashSet<Grammar> visitedGrammars = new HashSet<Grammar>();
        for (Grammar usedGrammar : grammar.getUsedGrammars()) {
            List<EObject> result = this.getPackage(nsUri, usedGrammar, visitedGrammars);
            if (result == null) continue;
            return result;
        }
        QualifiedName packageNsURI = QualifiedName.create(nsUri);
        EPackage pack = this.findPackageInScope(context, packageNsURI);
        if (pack == null && (pack = this.findPackageInAllDescriptions(context, packageNsURI)) == null) {
            pack = this.loadEPackage(nsUri, context.eResource().getResourceSet());
        }
        if (pack != null) {
            return Collections.singletonList(pack);
        }
        return Collections.emptyList();
    }

    private EPackage findPackageInScope(EObject context, QualifiedName packageNsURI) {
        IScope scopedPackages = this.scopeProvider.getScope(context.eResource(), XtextPackage.Literals.ABSTRACT_METAMODEL_DECLARATION__EPACKAGE, new Predicate<IEObjectDescription>(){

            public boolean apply(IEObjectDescription input) {
                return XtextLinkingService.this.isNsUriIndexEntry(input);
            }
        });
        IEObjectDescription description = scopedPackages.getSingleElement(packageNsURI);
        if (description != null) {
            return this.getResolvedEPackage(description, context);
        }
        return null;
    }

    private EPackage getResolvedEPackage(IEObjectDescription description, EObject context) {
        EObject resolved = EcoreUtil.resolve((EObject)description.getEObjectOrProxy(), (EObject)context);
        if (resolved != null && !resolved.eIsProxy() && resolved instanceof EPackage) {
            return (EPackage)resolved;
        }
        return null;
    }

    private EPackage findPackageInAllDescriptions(EObject context, QualifiedName packageNsURI) {
        IResourceDescriptions descriptions = this.descriptionsProvider.getResourceDescriptions(context.eResource());
        if (descriptions != null) {
            Iterable<IEObjectDescription> exported = descriptions.getExportedObjects(EcorePackage.Literals.EPACKAGE, packageNsURI, false);
            for (IEObjectDescription candidate : exported) {
                EPackage result;
                if (!this.isNsUriIndexEntry(candidate) || (result = this.getResolvedEPackage(candidate, context)) == null) continue;
                return result;
            }
        }
        return null;
    }

    private boolean isNsUriIndexEntry(IEObjectDescription candidate) {
        return Boolean.TRUE.toString().equalsIgnoreCase(candidate.getUserData("nsURI"));
    }

    private List<EObject> getPackage(String nsUri, Grammar grammar, Set<Grammar> visitedGrammars) {
        if (!visitedGrammars.add(grammar)) {
            return null;
        }
        for (AbstractMetamodelDeclaration declaration : grammar.getMetamodelDeclarations()) {
            EPackage pack = declaration.getEPackage();
            if (pack == null || !nsUri.equals(pack.getNsURI())) continue;
            return Collections.singletonList(pack);
        }
        for (Grammar usedGrammar : grammar.getUsedGrammars()) {
            List<EObject> result = this.getPackage(nsUri, usedGrammar, visitedGrammars);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private String getMetamodelNsURI(ILeafNode text) {
        try {
            return (String)this.valueConverterService.toValue(text.getText(), this.getLinkingHelper().getRuleNameFrom(text.getGrammarElement()), text);
        }
        catch (ValueConverterException e) {
            log.debug((Object)("Exception on leaf '" + text.getText() + "'"), (Throwable)e);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private EPackage loadEPackage(String resourceOrNsURI, ResourceSet resourceSet) {
        Resource resource;
        block7: {
            URI uri;
            block6: {
                if (resourceSet.getPackageRegistry().containsKey((Object)resourceOrNsURI)) {
                    return resourceSet.getPackageRegistry().getEPackage(resourceOrNsURI);
                }
                uri = URI.createURI((String)resourceOrNsURI);
                try {
                    if (!"http".equalsIgnoreCase(uri.scheme())) break block6;
                    return null;
                }
                catch (RuntimeException ex) {
                    if (uri.isPlatformResource()) {
                        String platformString = uri.toPlatformString(true);
                        URI platformPluginURI = URI.createPlatformPluginURI((String)platformString, (boolean)true);
                        return this.loadEPackage(platformPluginURI.toString(), resourceSet);
                    }
                    log.trace((Object)("Cannot load package with URI '" + resourceOrNsURI + "'"), (Throwable)ex);
                    return null;
                }
            }
            if (uri.fragment() != null) return (EPackage)resourceSet.getEObject(uri, true);
            resource = resourceSet.getResource(uri, true);
            if (!resource.getContents().isEmpty()) break block7;
            return null;
        }
        return (EPackage)resource.getContents().get(0);
    }

    private List<EObject> createPackage(GeneratedMetamodel generatedMetamodel, ILeafNode text) {
        String nsURI = this.getMetamodelNsURI(text);
        URI uri = URI.createURI((String)nsURI);
        if (uri == null || this.isReferencedByUsedGrammar(generatedMetamodel, nsURI)) {
            return Collections.emptyList();
        }
        EPackage pack = ((GeneratedMetamodelImpl)generatedMetamodel).basicGetEPackage();
        if (pack != null && !pack.eIsProxy()) {
            return Collections.singletonList(pack);
        }
        EPackage generatedEPackage = EcoreFactory.eINSTANCE.createEPackage();
        generatedEPackage.setName(generatedMetamodel.getName());
        generatedEPackage.setNsPrefix(generatedMetamodel.getName());
        generatedEPackage.setNsURI(nsURI);
        Resource generatedPackageResource = new EcoreResourceFactoryImpl().createResource(uri);
        XtextResourceSet resourceSet = (XtextResourceSet)generatedMetamodel.eResource().getResourceSet();
        if (!resourceSet.getURIResourceMap().containsKey(generatedPackageResource.getURI())) {
            generatedMetamodel.eResource().getResourceSet().getResources().add((Object)generatedPackageResource);
        } else {
            generatedPackageResource.setURI(URI.createURI((String)(String.valueOf(nsURI) + "_" + generatedMetamodel.hashCode())));
            generatedMetamodel.eResource().getResourceSet().getResources().add((Object)generatedPackageResource);
        }
        generatedPackageResource.getContents().add((Object)generatedEPackage);
        return Collections.singletonList(generatedEPackage);
    }

    private boolean isReferencedByUsedGrammar(GeneratedMetamodel generatedMetamodel, String nsURI) {
        Grammar grammar = GrammarUtil.getGrammar(generatedMetamodel);
        if (grammar != null) {
            HashSet visitedGrammars = Sets.newHashSet((Object[])new Grammar[]{grammar});
            for (Grammar usedGrammar : grammar.getUsedGrammars()) {
                if (!this.isReferencedByUsedGrammar(usedGrammar, nsURI, visitedGrammars)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isReferencedByUsedGrammar(Grammar grammar, String nsURI, Set<Grammar> visitedGrammars) {
        if (!visitedGrammars.add(grammar)) {
            return false;
        }
        for (AbstractMetamodelDeclaration decl : grammar.getMetamodelDeclarations()) {
            EPackage pack = decl.getEPackage();
            if (pack == null || !nsURI.equals(pack.getNsURI())) continue;
            return true;
        }
        for (Grammar usedGrammar : grammar.getUsedGrammars()) {
            if (!this.isReferencedByUsedGrammar(usedGrammar, nsURI, visitedGrammars)) continue;
            return true;
        }
        return false;
    }

    private List<EObject> getLinkedMetaModel(TypeRef context, EReference ref, ILeafNode text) throws IllegalNodeException {
        ICompositeNode parentNode = text.getParent();
        BidiIterator<INode> iterator = parentNode.getChildren().iterator();
        while (iterator.hasPrevious()) {
            INode child = iterator.previous();
            if (!(child instanceof ILeafNode)) continue;
            ILeafNode leaf = (ILeafNode)child;
            if (text == leaf) {
                return super.getLinkedObjects(context, ref, text);
            }
            if (leaf.getGrammarElement() instanceof Keyword || leaf.isHidden()) continue;
            IScope scope = this.getScope(context, ref);
            return XtextMetamodelReferenceHelper.findBestMetamodelForType(context, text.getText(), leaf.getText(), scope);
        }
        return Collections.emptyList();
    }
}

