/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.wizard;

import com.google.common.base.Splitter;
import java.util.Iterator;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class LanguageDescriptor {
    private String name;
    private FileExtensions fileExtensions;

    public String getBasePackage() {
        int i = this.name.lastIndexOf(".");
        int endIndex = 0;
        endIndex = i == -1 ? this.name.length() : i;
        return this.name.substring(0, endIndex);
    }

    public String getBasePackagePath() {
        return this.getBasePackage().replaceAll("\\.", "/");
    }

    public String getSimpleName() {
        String[] segments = this.name.split("\\.");
        return StringExtensions.toFirstUpper((String)segments[segments.length - 1]);
    }

    public String getNsURI() {
        String[] strings = this.name.split("\\.");
        if (strings.length < 2) {
            return "http://www." + this.name;
        }
        String s = "http://www." + strings[1] + "." + strings[0];
        for (int i = 2; i < strings.length; ++i) {
            s = s + "/" + strings[i];
        }
        return s;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public FileExtensions getFileExtensions() {
        return this.fileExtensions;
    }

    public void setFileExtensions(FileExtensions fileExtensions) {
        this.fileExtensions = fileExtensions;
    }

    public static class FileExtensions
    implements Iterable<String> {
        private final Iterable<String> fileExtensions;

        public FileExtensions(Iterable<String> fileExtensions) {
            this.fileExtensions = fileExtensions;
        }

        public static FileExtensions fromString(String fileExtensions) {
            Iterable splitFileExtensions = Splitter.on((String)",").trimResults().omitEmptyStrings().split((CharSequence)fileExtensions);
            return new FileExtensions(splitFileExtensions);
        }

        @Override
        public Iterator<String> iterator() {
            return this.fileExtensions.iterator();
        }

        public String toString() {
            return IterableExtensions.join(this.fileExtensions, (CharSequence)",");
        }
    }
}

