/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.hyperlinking;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.log4j.Logger;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.JFaceTextUtil;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.MultipleHyperlinkPresenter;
import org.eclipse.xtext.xbase.lib.util.ReflectExtensions;

public class SingleHoverShowingHyperlinkPresenter
implements InvocationHandler {
    private static final Logger log = Logger.getLogger(SingleHoverShowingHyperlinkPresenter.class);
    private ReflectExtensions reflect = new ReflectExtensions();
    public static final String SHOW_ALWAYS = "SHOW_ALWAYS";
    private final MultipleHyperlinkPresenter delegate;

    public SingleHoverShowingHyperlinkPresenter(MultipleHyperlinkPresenter delegate) {
        this.delegate = delegate;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getName().startsWith("showHyperlinks") && args.length >= 1 && args[0] instanceof IHyperlink[]) {
            IHyperlink[] nullsafe = this.makeNullsafe((IHyperlink[])args[0]);
            if (nullsafe.length > 0) {
                IHyperlink singleHyperlink;
                args[0] = nullsafe;
                Object result = method.invoke((Object)this.delegate, args);
                IHyperlink[] activeHyperlinks = nullsafe;
                if (activeHyperlinks.length == 1 && SHOW_ALWAYS.equals((singleHyperlink = activeHyperlinks[0]).getTypeLabel())) {
                    int start = singleHyperlink.getHyperlinkRegion().getOffset();
                    int length = singleHyperlink.getHyperlinkRegion().getLength();
                    int end = start + length;
                    this.reflect.set((Object)this.delegate, "fSubjectRegion", (Object)new Region(start, end - start));
                    this.reflect.set((Object)this.delegate, "fCursorOffset", (Object)JFaceTextUtil.getOffsetForCursorLocation((ITextViewer)((ITextViewer)this.reflect.get((Object)this.delegate, "fTextViewer"))));
                    ((AbstractInformationControlManager)this.reflect.get((Object)this.delegate, "fManager")).showInformation();
                }
                return result;
            }
            return null;
        }
        return method.invoke((Object)this.delegate, args);
    }

    protected IHyperlink[] makeNullsafe(IHyperlink[] hyperlinks) {
        if (Arrays.stream(hyperlinks).anyMatch(hyperLink -> hyperLink == null || hyperLink.getHyperlinkRegion() == null)) {
            ArrayList nullSafeList = new ArrayList();
            Arrays.stream(hyperlinks).forEach(hyperLink -> {
                if (hyperLink != null && hyperLink.getHyperlinkRegion() != null) {
                    nullSafeList.add(hyperLink);
                } else {
                    Class<?> clazz = null;
                    if (hyperLink != null) {
                        clazz = hyperLink.getClass();
                    }
                    String name = null;
                    if (clazz != null) {
                        name = clazz.getName();
                    }
                    log.warn((Object)("Filtered invalid hyperlink: " + name));
                }
            });
            return nullSafeList.toArray(new IHyperlink[nullSafeList.size()]);
        }
        return hyperlinks;
    }
}

