/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.testing;

import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.intro.IIntroManager;
import org.eclipse.ui.intro.IIntroPart;
import org.eclipse.xtext.ui.testing.util.IResourcesSetupUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;

public abstract class AbstractWorkbenchTest
extends Assert {
    @BeforeClass
    @BeforeAll
    public static void prepareWorkbench() throws Exception {
        AbstractWorkbenchTest.closeWelcomePage();
        AbstractWorkbenchTest.closeEditors();
    }

    @Before
    @BeforeEach
    public void setUp() throws Exception {
        this.waitForEventProcessing();
        IResourcesSetupUtil.cleanWorkspace();
        IResourcesSetupUtil.waitForBuild();
        this.waitForEventProcessing();
    }

    @After
    @AfterEach
    public void tearDown() throws Exception {
        this.waitForEventProcessing();
        AbstractWorkbenchTest.closeEditors();
        IResourcesSetupUtil.cleanWorkspace();
        IResourcesSetupUtil.waitForBuild();
        this.waitForEventProcessing();
    }

    protected void waitForEventProcessing() {
        while (Display.getDefault().readAndDispatch()) {
        }
    }

    protected static void closeEditors() {
        AbstractWorkbenchTest.getActivePage().closeAllEditors(false);
    }

    protected static void closeWelcomePage() throws InterruptedException {
        IIntroManager introManager = AbstractWorkbenchTest.getWorkbench().getIntroManager();
        IIntroPart intro = introManager.getIntro();
        if (intro != null) {
            introManager.closeIntro(intro);
        }
    }

    @Deprecated
    protected void sleep(long i) throws InterruptedException {
        Display displ = Display.getCurrent();
        if (displ != null) {
            long timeToGo = System.currentTimeMillis() + i;
            while (System.currentTimeMillis() < timeToGo) {
                if (displ.readAndDispatch()) continue;
                displ.sleep();
            }
            displ.update();
        } else {
            Thread.sleep(i);
        }
    }

    protected static IWorkbenchPage getActivePage() {
        return AbstractWorkbenchTest.getWorkbenchWindow().getActivePage();
    }

    protected static IWorkbenchWindow getWorkbenchWindow() {
        return AbstractWorkbenchTest.getWorkbench().getActiveWorkbenchWindow();
    }

    protected static IWorkbench getWorkbench() {
        return PlatformUI.getWorkbench();
    }
}

