/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.trace;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.xtext.builder.trace.AbstractTrace;

public class ZipFileAwareTrace
extends AbstractTrace {
    private static final Logger log = Logger.getLogger(ZipFileAwareTrace.class);
    private IProject project;
    private URI uri;
    private IPath zipFilePath;

    @Override
    public IProject getLocalProject() {
        return this.project;
    }

    @Override
    public URI getLocalURI() {
        return this.uri;
    }

    protected void setProject(IProject project) {
        this.project = project;
    }

    protected void setUri(URI uri) {
        this.uri = uri;
    }

    @Override
    protected IStorage findStorage(URI uri, IProject project) {
        return null;
    }

    protected void setZipFilePath(IPath zipFilePath) {
        this.zipFilePath = zipFilePath;
    }

    @Override
    protected URI resolvePath(URI path) {
        IResource member = this.getWorkspace().getRoot().findMember(this.zipFilePath);
        if (member != null) {
            return URI.createURI((String)("archive:platform:/resource" + member.getFullPath().toString() + "!/" + path));
        }
        return URI.createURI((String)("archive:file:" + this.zipFilePath.toString() + "!/" + path));
    }

    @Override
    protected InputStream getContents(URI uri, IProject project) {
        JavaModelManager modelManager = JavaModelManager.getJavaModelManager();
        ZipFile zipFile = null;
        try {
            zipFile = modelManager.getZipFile(this.zipFilePath);
            ZipEntry zipEntry = zipFile.getEntry(uri.toString());
            if (zipEntry != null) {
                byte[] contents = Util.getZipEntryByteContent((ZipEntry)zipEntry, (ZipFile)zipFile);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(contents);
                return byteArrayInputStream;
            }
        }
        catch (IOException e) {
            log.debug((Object)("Could not read zip file " + uri), (Throwable)e);
        }
        catch (CoreException e) {
            log.debug((Object)("Could not read zip file " + uri), (Throwable)e);
        }
        finally {
            if (zipFile != null) {
                modelManager.closeZipFile(zipFile);
            }
        }
        return null;
    }
}

