/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.computation;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.xbase.XCollectionLiteral;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XListLiteral;
import org.eclipse.xtext.xbase.XSetLiteral;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.typesystem.computation.AbstractTypeComputer;
import org.eclipse.xtext.xbase.typesystem.computation.ElementOrComponentTypeComputer;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeComputationResult;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeComputationState;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeExpectation;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.UnboundTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.WildcardTypeReference;

public class CollectionLiteralsTypeComputer
extends AbstractTypeComputer {
    public void computeType(XSetLiteral literal, ITypeComputationState state) {
        JvmGenericType setType = (JvmGenericType)this.findDeclaredType(Set.class, state);
        if (setType == null) {
            this.handleCollectionTypeNotAvailable(literal, state, Set.class);
            return;
        }
        JvmGenericType mapType = (JvmGenericType)this.findDeclaredType(Map.class, state);
        for (ITypeExpectation iTypeExpectation : state.getExpectations()) {
            this.computeType(literal, setType, mapType, iTypeExpectation, state);
        }
    }

    public void computeType(XListLiteral literal, ITypeComputationState state) {
        JvmGenericType listType = (JvmGenericType)this.findDeclaredType(List.class, state);
        if (listType == null) {
            this.handleCollectionTypeNotAvailable(literal, state, List.class);
            return;
        }
        for (ITypeExpectation iTypeExpectation : state.getExpectations()) {
            this.computeType(literal, listType, iTypeExpectation, state);
        }
    }

    @Override
    protected LightweightTypeReference getCommonSuperType(List<LightweightTypeReference> types, ITypeComputationState state) {
        if (types.isEmpty()) {
            return null;
        }
        LightweightTypeReference result = super.getCommonSuperType(types, state);
        return result;
    }

    protected void computeType(XSetLiteral literal, JvmGenericType setType, JvmGenericType mapType, ITypeExpectation expectation, ITypeComputationState state) {
        LightweightTypeReference elementTypeExpectation = null;
        LightweightTypeReference expectedType = expectation.getExpectedType();
        if (expectedType != null) {
            elementTypeExpectation = this.getElementOrComponentType(expectedType, state);
        }
        List<LightweightTypeReference> setTypeCandidates = this.computeCollectionTypeCandidates(literal, setType, elementTypeExpectation, state);
        LightweightTypeReference commonSetType = this.getCommonSuperType(setTypeCandidates, state);
        ITypeReferenceOwner owner = state.getReferenceOwner();
        if (commonSetType != null) {
            LightweightTypeReference commonElementType = commonSetType.getTypeArguments().get(0).getInvariantBoundSubstitute();
            if (this.isMapLiteral(expectedType, commonElementType)) {
                LightweightTypeReference mapTypeReference = this.createMapTypeReference(mapType, commonElementType, expectedType, owner);
                expectation.acceptActualType(mapTypeReference, 0x400000);
                commonElementType = this.createNormalizedPairType(commonElementType, mapTypeReference, owner);
                this.refineElementTypeExpectation(literal, commonElementType, state);
            } else {
                commonElementType = this.normalizeElementType(commonElementType, expectedType, owner);
                if (expectedType != null) {
                    commonSetType = this.createCollectionTypeReference(setType, commonElementType, expectedType, owner);
                }
                expectation.acceptActualType(commonSetType, 0x400000);
                this.refineElementTypeExpectation(literal, commonElementType, state);
            }
        } else if (this.isMapExpectation(expectedType)) {
            ParameterizedTypeReference unboundCollectionType = owner.newParameterizedTypeReference((JvmType)mapType);
            unboundCollectionType.addTypeArgument(expectation.createUnboundTypeReference(literal, (JvmTypeParameter)mapType.getTypeParameters().get(0)));
            unboundCollectionType.addTypeArgument(expectation.createUnboundTypeReference(literal, (JvmTypeParameter)mapType.getTypeParameters().get(1)));
            expectation.acceptActualType((LightweightTypeReference)unboundCollectionType, 0x400000);
        } else {
            this.setUnboundCollectionType(literal, setType, expectation, elementTypeExpectation, state);
        }
    }

    protected void setUnboundCollectionType(XCollectionLiteral literal, JvmGenericType collectionType, ITypeExpectation expectation, LightweightTypeReference elementTypeExpectation, ITypeComputationState state) {
        ParameterizedTypeReference unboundCollectionType = state.getReferenceOwner().newParameterizedTypeReference((JvmType)collectionType);
        if (elementTypeExpectation != null) {
            unboundCollectionType.addTypeArgument(elementTypeExpectation);
        } else {
            UnboundTypeReference unboundTypeArgument = expectation.createUnboundTypeReference(literal, (JvmTypeParameter)collectionType.getTypeParameters().get(0));
            unboundCollectionType.addTypeArgument(unboundTypeArgument);
        }
        expectation.acceptActualType((LightweightTypeReference)unboundCollectionType, 0x400000);
    }

    protected void refineElementTypeExpectation(XCollectionLiteral literal, LightweightTypeReference expectation, ITypeComputationState state) {
        for (XExpression element : literal.getElements()) {
            state.refineExpectedType(element, expectation);
        }
    }

    protected boolean isMapLiteral(LightweightTypeReference expectation, LightweightTypeReference elementType) {
        if (this.isIterableExpectation(expectation)) {
            return false;
        }
        return elementType.isType(Pair.class) && elementType.getTypeArguments().size() == 2;
    }

    protected boolean isMapExpectation(LightweightTypeReference expectation) {
        return this.isExpectedType(expectation, Map.class);
    }

    protected void computeType(XListLiteral literal, JvmGenericType listType, ITypeExpectation expectation, ITypeComputationState state) {
        List<LightweightTypeReference> listTypeCandidates;
        LightweightTypeReference commonListType;
        LightweightTypeReference elementTypeExpectation = null;
        LightweightTypeReference expectedType = expectation.getExpectedType();
        if (expectedType != null) {
            if (expectedType.isArray()) {
                this.computeArrayLiteralType(literal, expectedType, expectation, state);
                return;
            }
            elementTypeExpectation = this.getElementOrComponentType(expectedType, state);
        }
        if ((commonListType = this.getCommonSuperType(listTypeCandidates = this.computeCollectionTypeCandidates(literal, listType, elementTypeExpectation, state), state)) != null) {
            LightweightTypeReference commonElementType = this.getElementOrComponentType(commonListType, state);
            ITypeReferenceOwner owner = state.getReferenceOwner();
            commonElementType = this.normalizeElementType(commonElementType, expectedType, owner);
            if (expectedType != null) {
                commonListType = this.createCollectionTypeReference(listType, commonElementType, expectedType, owner);
            }
            expectation.acceptActualType(commonListType, 0x400000);
            this.refineElementTypeExpectation(literal, commonElementType, state);
        } else {
            this.setUnboundCollectionType(literal, listType, expectation, elementTypeExpectation, state);
        }
    }

    protected void computeArrayLiteralType(XListLiteral literal, LightweightTypeReference expectedArrayType, ITypeExpectation expectation, ITypeComputationState state) {
        LightweightTypeReference elementTypeExpectation = expectedArrayType.getComponentType();
        int allFlags = 0;
        for (XExpression element : literal.getElements()) {
            ITypeComputationResult elementTypeResult = this.computeTypes(element, elementTypeExpectation, state);
            allFlags |= elementTypeResult.getCheckedConformanceFlags();
        }
        if ((allFlags & 0x40000) != 0) {
            allFlags &= 0xFFFFFDFF;
            expectation.acceptActualType(expectedArrayType, allFlags |= 0x10300000);
        } else if ((allFlags & 0x200) != 0) {
            expectation.acceptActualType(expectedArrayType, allFlags |= 0x300000);
        } else {
            expectation.acceptActualType(expectedArrayType, 0x300200);
        }
    }

    protected ITypeComputationResult computeTypes(XExpression element, LightweightTypeReference expectation, ITypeComputationState state) {
        ITypeComputationResult elementTypeResult = expectation != null ? state.withExpectation(expectation).computeTypes(element) : state.withNonVoidExpectation().computeTypes(element);
        return elementTypeResult;
    }

    protected void handleCollectionTypeNotAvailable(XCollectionLiteral literal, ITypeComputationState state, Class<?> clazz) {
        for (XExpression element : literal.getElements()) {
            state.withNonVoidExpectation().computeTypes(element);
        }
        state.acceptActualType(state.getReferenceOwner().newUnknownTypeReference(clazz.getName()));
    }

    protected LightweightTypeReference createNormalizedPairType(LightweightTypeReference pairType, LightweightTypeReference mapType, ITypeReferenceOwner owner) {
        LightweightTypeReference valueType;
        ParameterizedTypeReference result = new ParameterizedTypeReference(owner, pairType.getType());
        LightweightTypeReference keyType = mapType.getTypeArguments().get(0);
        if (keyType.getKind() != 8) {
            WildcardTypeReference wc = new WildcardTypeReference(owner);
            wc.addUpperBound(keyType);
            keyType = wc;
        }
        if ((valueType = mapType.getTypeArguments().get(1)).getKind() != 8) {
            WildcardTypeReference wc = new WildcardTypeReference(owner);
            wc.addUpperBound(valueType);
            valueType = wc;
        }
        result.addTypeArgument(keyType);
        result.addTypeArgument(valueType);
        return result;
    }

    protected LightweightTypeReference createCollectionTypeReference(JvmGenericType collectionType, LightweightTypeReference elementType, LightweightTypeReference expectedType, ITypeReferenceOwner owner) {
        LightweightTypeReference expectedElementType;
        ParameterizedTypeReference result = new ParameterizedTypeReference(owner, (JvmType)collectionType);
        result.addTypeArgument(elementType);
        if (this.isIterableExpectation(expectedType) && !expectedType.isAssignableFrom(result) && this.matchesExpectation(elementType, expectedElementType = this.getElementOrComponentType(expectedType, owner))) {
            return expectedType;
        }
        return result;
    }

    protected LightweightTypeReference createMapTypeReference(JvmGenericType mapType, LightweightTypeReference pairType, LightweightTypeReference expectation, ITypeReferenceOwner owner) {
        List<LightweightTypeReference> leftAndRight = pairType.getTypeArguments();
        LightweightTypeReference left = leftAndRight.get(0).getInvariantBoundSubstitute();
        LightweightTypeReference right = leftAndRight.get(1).getInvariantBoundSubstitute();
        LightweightTypeReference mapExpectation = this.getMapExpectation(expectation);
        if (mapExpectation != null) {
            List<LightweightTypeReference> typeArguments = expectation.getTypeArguments();
            left = this.doNormalizeElementType(left, typeArguments.get(0));
            right = this.doNormalizeElementType(right, typeArguments.get(1));
        }
        ParameterizedTypeReference result = owner.newParameterizedTypeReference((JvmType)mapType);
        result.addTypeArgument(left.copyInto(owner));
        result.addTypeArgument(right.copyInto(owner));
        if (mapExpectation != null && !expectation.isAssignableFrom(result) && this.matchesExpectation(left, mapExpectation.getTypeArguments().get(0)) && this.matchesExpectation(right, mapExpectation.getTypeArguments().get(1))) {
            return expectation;
        }
        return result;
    }

    protected boolean matchesExpectation(LightweightTypeReference elementType, LightweightTypeReference expectation) {
        return expectation != null && expectation.isResolved() && !expectation.isWildcard() && expectation.isAssignableFrom(elementType);
    }

    protected LightweightTypeReference getMapExpectation(LightweightTypeReference expectation) {
        LightweightTypeReference result;
        if (expectation != null && expectation.isResolved() && (result = expectation.getSuperType(Map.class)) != null && result.getTypeArguments().size() == 2) {
            return result;
        }
        return null;
    }

    protected LightweightTypeReference normalizeElementType(LightweightTypeReference collectionElementType, LightweightTypeReference expectedCollectionType, ITypeReferenceOwner owner) {
        if (this.isIterableExpectation(expectedCollectionType)) {
            LightweightTypeReference expectedElementType = this.getElementOrComponentType(expectedCollectionType, owner);
            return this.doNormalizeElementType(collectionElementType, expectedElementType);
        }
        return this.normalizeFunctionTypeReference(collectionElementType);
    }

    protected boolean isIterableExpectation(LightweightTypeReference expectation) {
        return this.isExpectedType(expectation, Iterable.class);
    }

    protected boolean isExpectedType(LightweightTypeReference expectation, Class<?> clazz) {
        if (expectation != null) {
            if (expectation.isResolved() && expectation.isSubtypeOf(clazz)) {
                return true;
            }
            if (expectation instanceof UnboundTypeReference) {
                if (expectation.getOwner().newParameterizedTypeReference((JvmType)((UnboundTypeReference)expectation).getTypeParameter()).isSubtypeOf(clazz)) {
                    return true;
                }
                List<LightweightBoundTypeArgument> hints = ((UnboundTypeReference)expectation).getAllHints();
                for (LightweightBoundTypeArgument hint : hints) {
                    LightweightTypeReference hintReference = hint.getTypeReference();
                    if (hintReference == null || !hintReference.isSubtypeOf(clazz)) continue;
                    return true;
                }
            } else if (expectation instanceof ParameterizedTypeReference) {
                return expectation.isSubtypeOf(clazz);
            }
        }
        return false;
    }

    protected LightweightTypeReference normalizeFunctionTypeReference(LightweightTypeReference type) {
        if (type.getKind() == 9) {
            ParameterizedTypeReference parameterized = new ParameterizedTypeReference(type.getOwner(), type.getType());
            for (LightweightTypeReference argument : type.getTypeArguments()) {
                parameterized.addTypeArgument(argument);
            }
            type = parameterized.tryConvertToFunctionTypeReference(false);
        }
        return type;
    }

    protected LightweightTypeReference doNormalizeElementType(LightweightTypeReference actual, LightweightTypeReference expected) {
        if (this.matchesExpectation(actual, expected)) {
            return expected;
        }
        return this.normalizeFunctionTypeReference(actual);
    }

    protected List<LightweightTypeReference> computeCollectionTypeCandidates(XCollectionLiteral literal, JvmGenericType collectionType, LightweightTypeReference elementTypeExpectation, ITypeComputationState state) {
        EList<XExpression> elements = literal.getElements();
        if (!elements.isEmpty()) {
            ArrayList elementTypes = Lists.newArrayListWithCapacity((int)elements.size());
            for (XExpression element : elements) {
                ITypeComputationResult elementType = this.computeTypes(element, elementTypeExpectation, state);
                LightweightTypeReference actualType = elementType.getActualExpressionType();
                if (actualType == null || actualType.isAny()) continue;
                ParameterizedTypeReference collectionTypeCandidate = state.getReferenceOwner().newParameterizedTypeReference((JvmType)collectionType);
                collectionTypeCandidate.addTypeArgument(actualType.getWrapperTypeIfPrimitive());
                elementTypes.add(collectionTypeCandidate);
            }
            return elementTypes;
        }
        return Collections.emptyList();
    }

    protected LightweightTypeReference getElementOrComponentType(LightweightTypeReference iterableOrArray, ITypeComputationState state) {
        return this.getElementOrComponentType(iterableOrArray, state.getReferenceOwner());
    }

    protected LightweightTypeReference getElementOrComponentType(LightweightTypeReference iterableOrArray, ITypeReferenceOwner owner) {
        return ElementOrComponentTypeComputer.compute(iterableOrArray, owner);
    }
}

