/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.refactoring;

import com.google.common.base.Predicate;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.internal.corext.refactoring.ParameterInfo;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.xtend.core.jvmmodel.IXtendJvmAssociations;
import org.eclipse.xtend.core.xtend.RichString;
import org.eclipse.xtend.core.xtend.RichStringForLoop;
import org.eclipse.xtend.core.xtend.RichStringIf;
import org.eclipse.xtend.core.xtend.RichStringLiteral;
import org.eclipse.xtend.core.xtend.XtendClass;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.refactoring.impl.EditorDocumentChange;
import org.eclipse.xtext.ui.refactoring.impl.StatusWrapper;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.ReplaceRegion;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.util.TextRegion;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.XReturnExpression;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.compiler.ISourceAppender;
import org.eclipse.xtext.xbase.compiler.StringBuilderBasedAppendable;
import org.eclipse.xtext.xbase.typesystem.IBatchTypeResolver;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.StandardTypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;
import org.eclipse.xtext.xbase.ui.document.DocumentRewriter;
import org.eclipse.xtext.xbase.ui.imports.ReplaceConverter;
import org.eclipse.xtext.xbase.ui.refactoring.ExpressionUtil;
import org.eclipse.xtext.xbase.ui.refactoring.NewFeatureNameUtil;

public class ExtractMethodRefactoring
extends Refactoring {
    public static final Logger LOG = Logger.getLogger(ExtractMethodRefactoring.class);
    @Inject
    private Provider<StatusWrapper> statusProvider;
    @Inject
    private ILocationInFileProvider locationInFileProvider;
    @Inject
    private IBatchTypeResolver typeResolver;
    @Inject
    private CommonTypeComputationServices typeComputationServices;
    @Inject
    private ExpressionUtil expressionUtil;
    @Inject
    private NewFeatureNameUtil nameUtil;
    @Inject
    private IXtendJvmAssociations associations;
    @Inject
    private DocumentRewriter.Factory rewriterFactory;
    @Inject
    private ReplaceConverter replaceConverter;
    private IXtextDocument document;
    private List<XExpression> expressions;
    private String methodName = "";
    private JvmVisibility visibility;
    private boolean isStatic;
    private List<ParameterInfo> parameterInfos = Lists.newArrayList();
    private Map<ParameterInfo, LightweightTypeReference> parameter2type = Maps.newHashMap();
    private boolean isExplicitlyDeclareReturnType;
    private XExpression firstExpression;
    private XExpression lastExpression;
    private URI resourceURI;
    private XtendClass xtendClass;
    private XtendFunction originalMethod;
    private TextEdit textEdit;
    private List<String> localFeatureNames = Lists.newArrayList();
    private Multimap<String, XFeatureCall> externalFeatureCalls = HashMultimap.create();
    private XExpression returnExpression;
    private LightweightTypeReference returnType;
    private Set<JvmTypeParameter> neededTypeParameters = Sets.newHashSet();
    private DocumentRewriter rewriter;
    private XtextEditor editor;
    private boolean doSave;

    public boolean initialize(XtextEditor editor, List<XExpression> selectedExpressions, boolean doSave) {
        if (selectedExpressions.isEmpty() || editor.getDocument() == null) {
            return false;
        }
        this.document = editor.getDocument();
        this.doSave = doSave;
        this.editor = editor;
        this.expressions = this.calculateExpressions(selectedExpressions);
        this.firstExpression = this.expressions.get(0);
        this.originalMethod = (XtendFunction)EcoreUtil2.getContainerOfType((EObject)this.firstExpression, XtendFunction.class);
        this.lastExpression = this.expressions.get(this.expressions.size() - 1);
        this.resourceURI = EcoreUtil2.getPlatformResourceOrNormalizedURI((EObject)this.firstExpression).trimFragment();
        this.xtendClass = (XtendClass)EcoreUtil2.getContainerOfType((EObject)this.firstExpression, XtendClass.class);
        if (this.xtendClass == null || this.originalMethod == null) {
            return false;
        }
        this.visibility = this.originalMethod.getVisibility();
        this.isStatic = this.originalMethod.isStatic();
        XExpression successorExpression = this.expressionUtil.findSuccessorExpressionForVariableDeclaration((EObject)this.lastExpression);
        this.nameUtil.setFeatureScopeContext(successorExpression);
        this.rewriter = this.rewriterFactory.create(this.document, (XtextResource)this.firstExpression.eResource());
        return true;
    }

    protected List<XExpression> calculateExpressions(final List<XExpression> expressions) {
        XExpression firstExpression = expressions.get(0);
        if (expressions.size() == 1 && firstExpression instanceof XVariableDeclaration) {
            XtendFunction originalMethod = (XtendFunction)EcoreUtil2.getContainerOfType((EObject)firstExpression, XtendFunction.class);
            for (EObject element : Iterables.filter((Iterable)EcoreUtil2.eAllContents((EObject)originalMethod.getExpression()), (Predicate)new Predicate<EObject>(){

                public boolean apply(EObject input) {
                    return !EcoreUtil.isAncestor((Collection)expressions, (EObject)input);
                }
            })) {
                XFeatureCall featureCall;
                JvmIdentifiableElement feature;
                if (!(element instanceof XFeatureCall) || !EcoreUtil.isAncestor(expressions, (EObject)(feature = (featureCall = (XFeatureCall)element).getFeature()))) continue;
                return Collections.singletonList(((XVariableDeclaration)firstExpression).getRight());
            }
        }
        return expressions;
    }

    public String getName() {
        return "Extract Method Refactoring";
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public RefactoringStatus validateMethodName(String newMethodName) {
        RefactoringStatus status = new RefactoringStatus();
        this.nameUtil.checkNewFeatureName(newMethodName, true, status);
        return status;
    }

    public JvmVisibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(JvmVisibility visibility) {
        this.visibility = visibility;
    }

    public void setExplicitlyDeclareReturnType(boolean isExplicitlyDeclareReturnType) {
        this.isExplicitlyDeclareReturnType = isExplicitlyDeclareReturnType;
    }

    public boolean isExplicitlyDeclareReturnType() {
        return this.isExplicitlyDeclareReturnType;
    }

    public XtendClass getXtendClass() {
        return this.xtendClass;
    }

    public List<ParameterInfo> getParameterInfos() {
        return this.parameterInfos;
    }

    public RefactoringStatus validateParameters() {
        RefactoringStatus status = new RefactoringStatus();
        HashSet namesSoFar = Sets.newHashSet();
        for (ParameterInfo parameterInfo : this.parameterInfos) {
            String newName = parameterInfo.getNewName();
            if (namesSoFar.contains(newName)) {
                status.addError("Duplicate parameter name '" + newName + "'");
            }
            if (!Strings.equal((String)newName, (String)parameterInfo.getOldName()) && this.localFeatureNames.contains(newName)) {
                status.addError("'" + newName + "' is already used as a name in the selected code");
            }
            this.nameUtil.checkNewFeatureName(newName, false, status);
            namesSoFar.add(newName);
        }
        return status;
    }

    public String getMethodSignature() {
        StringBuilderBasedAppendable appendable = new StringBuilderBasedAppendable();
        this.appendMethodSignature((ISourceAppender)appendable);
        return appendable.toString();
    }

    protected void appendMethodSignature(ISourceAppender appendable) {
        JvmOperation operation;
        if (this.visibility != JvmVisibility.PUBLIC) {
            appendable.append((CharSequence)this.getVisibility().getName().toLowerCase()).append((CharSequence)" ");
        }
        appendable.append((CharSequence)"def ");
        if (this.isStatic) {
            appendable.append((CharSequence)"static ");
        }
        if (!this.neededTypeParameters.isEmpty() && (operation = this.associations.getDirectlyInferredOperation(this.originalMethod)) != null) {
            appendable.append((CharSequence)"<");
            boolean isFirst = true;
            for (JvmTypeParameter typeParameter : operation.getTypeParameters()) {
                if (!this.neededTypeParameters.contains(typeParameter)) continue;
                if (!isFirst) {
                    appendable.append((CharSequence)", ");
                }
                isFirst = false;
                appendable.append((JvmType)typeParameter);
            }
            appendable.append((CharSequence)"> ");
        }
        if (this.isExplicitlyDeclareReturnType) {
            appendable.append(this.returnType).append((CharSequence)" ");
        }
        appendable.append((CharSequence)this.methodName).append((CharSequence)"(");
        boolean isFirst = true;
        for (ParameterInfo parameterInfo : this.getParameterInfos()) {
            if (!isFirst) {
                appendable.append((CharSequence)", ");
            }
            isFirst = false;
            appendable.append(this.parameter2type.get(parameterInfo)).append((CharSequence)" ").append((CharSequence)parameterInfo.getNewName());
        }
        appendable.append((CharSequence)")");
    }

    public RefactoringStatus checkInitialConditions(final IProgressMonitor pm) throws CoreException, OperationCanceledException {
        StatusWrapper status = (StatusWrapper)this.statusProvider.get();
        IResolvedTypes resolvedTypes = this.typeResolver.resolveTypes((EObject)this.firstExpression, new CancelIndicator(){

            public boolean isCanceled() {
                return pm.isCanceled();
            }
        });
        try {
            HashSet calledExternalFeatureNames = Sets.newHashSet();
            this.returnType = this.calculateReturnType(resolvedTypes);
            if (this.returnType != null && !Strings.equal((String)"void", (String)this.returnType.getIdentifier())) {
                this.returnExpression = this.lastExpression;
            }
            boolean isReturnAllowed = this.isEndOfOriginalMethod();
            for (EObject element : EcoreUtil2.eAllContents((EObject)this.originalMethod.getExpression())) {
                if (pm.isCanceled()) {
                    throw new OperationCanceledException();
                }
                boolean isLocalExpression = EcoreUtil.isAncestor(this.expressions, (EObject)element);
                if (element instanceof XFeatureCall) {
                    XFeatureCall featureCall = (XFeatureCall)element;
                    JvmIdentifiableElement feature = featureCall.getFeature();
                    LightweightTypeReference featureType = resolvedTypes.getActualType((XExpression)featureCall);
                    boolean isLocalFeature = EcoreUtil.isAncestor(this.expressions, (EObject)feature);
                    if (!isLocalFeature && isLocalExpression) {
                        if (!(feature instanceof JvmFormalParameter) && !(feature instanceof XVariableDeclaration)) continue;
                        if (!calledExternalFeatureNames.contains(feature.getSimpleName())) {
                            calledExternalFeatureNames.add(feature.getSimpleName());
                            ParameterInfo parameterInfo = new ParameterInfo(featureType.getIdentifier(), feature.getSimpleName(), this.parameterInfos.size());
                            this.parameterInfos.add(parameterInfo);
                            this.parameter2type.put(parameterInfo, featureType);
                        }
                        this.externalFeatureCalls.put((Object)feature.getSimpleName(), (Object)featureCall);
                        continue;
                    }
                    if (!isLocalFeature || isLocalExpression) continue;
                    if (this.returnExpression != null) {
                        status.add(4, "Ambiguous return value: Multiple local variables are accessed in subsequent code.", new Object[0]);
                        break;
                    }
                    this.returnExpression = featureCall;
                    this.returnType = featureType;
                    continue;
                }
                if (!isLocalExpression) continue;
                if (element instanceof XReturnExpression && !isReturnAllowed) {
                    status.add(4, "Extracting method would break control flow due to return statements.", new Object[0]);
                    break;
                }
                if (element instanceof JvmTypeReference) {
                    EList typeParameters;
                    JvmOperation operation;
                    JvmType type = ((JvmTypeReference)element).getType();
                    if (!(type instanceof JvmTypeParameter) || (operation = this.associations.getDirectlyInferredOperation(this.originalMethod)) == null || !(typeParameters = operation.getTypeParameters()).contains(type)) continue;
                    this.neededTypeParameters.add((JvmTypeParameter)type);
                    continue;
                }
                if (element instanceof JvmFormalParameter) {
                    this.localFeatureNames.add(((JvmFormalParameter)element).getName());
                    continue;
                }
                if (!(element instanceof XVariableDeclaration)) continue;
                this.localFeatureNames.add(((XVariableDeclaration)element).getIdentifier());
            }
        }
        catch (OperationCanceledException e) {
            throw e;
        }
        catch (Exception exc) {
            this.handleException(exc, status);
        }
        return status.getRefactoringStatus();
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        StatusWrapper status = (StatusWrapper)this.statusProvider.get();
        try {
            status.merge(this.validateMethodName(this.methodName));
            status.merge(this.validateParameters());
            ITextRegion expressionsRegion = this.getExpressionsRegion();
            ITextRegion predecessorRegion = this.locationInFileProvider.getFullTextRegion((EObject)this.originalMethod);
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            DocumentRewriter.Section expressionSection = this.rewriter.newSection(expressionsRegion.getOffset(), expressionsRegion.getLength());
            DocumentRewriter.Section declarationSection = this.rewriter.newSection(predecessorRegion.getOffset() + predecessorRegion.getLength(), 0);
            this.createMethodCallEdit(expressionSection, expressionsRegion);
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.createMethodDeclarationEdit(declarationSection, expressionSection.getBaseIndentLevel(), expressionsRegion);
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.textEdit = this.replaceConverter.convertToTextEdit(this.rewriter.getChanges());
        }
        catch (OperationCanceledException e) {
            throw e;
        }
        catch (Exception exc) {
            this.handleException(exc, status);
        }
        return status.getRefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        EditorDocumentChange change = new EditorDocumentChange("Extract Method", (ITextEditor)this.editor, this.doSave);
        change.setEdit(this.textEdit);
        change.setTextType(this.resourceURI.fileExtension());
        return change;
    }

    protected void handleException(Exception exc, StatusWrapper status) {
        status.add(4, "Error during refactoring: {0}", exc, LOG);
    }

    protected LightweightTypeReference calculateReturnType(IResolvedTypes resolvedTypes) {
        ArrayList returnTypes = Lists.newArrayList();
        for (XExpression expression : this.expressions) {
            LightweightTypeReference expressionReturnType = resolvedTypes.getReturnType(expression);
            if (expressionReturnType == null) continue;
            returnTypes.add(expressionReturnType);
        }
        LightweightTypeReference actualType = resolvedTypes.getActualType(this.lastExpression);
        if (!actualType.isPrimitiveVoid()) {
            returnTypes.add(actualType);
        }
        StandardTypeReferenceOwner owner = new StandardTypeReferenceOwner(this.typeComputationServices, (EObject)this.xtendClass);
        return this.typeComputationServices.getTypeConformanceComputer().getCommonSuperType((List)returnTypes, (ITypeReferenceOwner)owner);
    }

    protected ITextRegion getExpressionsRegion() {
        ITextRegion firstRegion = this.expressionUtil.getTextRegion((EObject)this.firstExpression);
        ITextRegion lastRegion = this.expressionUtil.getTextRegion((EObject)this.lastExpression);
        TextRegion expressionRegion = new TextRegion(firstRegion.getOffset(), lastRegion.getOffset() + lastRegion.getLength() - firstRegion.getOffset());
        return expressionRegion;
    }

    protected void createMethodDeclarationEdit(DocumentRewriter.Section declarationSection, int expressionIndentLevel, ITextRegion expressionsRegion) throws BadLocationException {
        String expressionsAsString = this.getExtractedMethodBody(expressionsRegion);
        declarationSection.newLine().newLine();
        this.appendMethodSignature((ISourceAppender)declarationSection);
        if (this.firstExpression.eContainer() instanceof RichString && !this.isRichStringXExpressionOrVarDeclaration()) {
            declarationSection.increaseIndentation().newLine().append((CharSequence)"'''");
        } else {
            declarationSection.append((CharSequence)" {").increaseIndentation().newLine();
        }
        declarationSection.append((CharSequence)expressionsAsString, Math.min(0, -expressionIndentLevel));
        if (this.isNeedsReturnExpression()) {
            declarationSection.newLine().append((CharSequence)((XFeatureCall)this.returnExpression).getFeature().getSimpleName());
        }
        if (this.firstExpression.eContainer() instanceof RichString && !this.isRichStringXExpressionOrVarDeclaration()) {
            declarationSection.append((CharSequence)"'''").decreaseIndentation().newLine();
        } else {
            declarationSection.decreaseIndentation().newLine().append((CharSequence)"}");
        }
    }

    protected String getExtractedMethodBody(ITextRegion expressionsRegion) throws BadLocationException {
        int length;
        String methodBody = this.getMethodBodyWithRenamedParameters(expressionsRegion);
        if (this.isRichStringXExpressionOrVarDeclaration() && (length = methodBody.length()) >= 2) {
            methodBody = methodBody.substring(1, length - 1);
        }
        if (!(this.expressions.size() != 1 || !(this.firstExpression instanceof XClosure) || methodBody.startsWith("[") && methodBody.endsWith("]"))) {
            return "[" + methodBody + "]";
        }
        return methodBody;
    }

    protected boolean isRichStringXExpressionOrVarDeclaration() {
        return this.firstExpression == this.lastExpression && this.firstExpression.eContainer() instanceof RichString && !(this.firstExpression instanceof RichStringLiteral) && !(this.firstExpression instanceof RichStringForLoop) && !(this.firstExpression instanceof RichStringIf);
    }

    protected String getMethodBodyWithRenamedParameters(ITextRegion expressionsRegion) throws BadLocationException {
        String expressionsAsString = this.document.get(expressionsRegion.getOffset(), expressionsRegion.getLength());
        ArrayList parameterRenames = Lists.newArrayList();
        for (final String parameterName : this.externalFeatureCalls.keySet()) {
            ParameterInfo parameter = (ParameterInfo)Iterables.find(this.parameterInfos, (Predicate)new Predicate<ParameterInfo>(){

                public boolean apply(ParameterInfo info) {
                    return Strings.equal((String)info.getOldName(), (String)parameterName);
                }
            });
            if (!parameter.isRenamed()) continue;
            for (XFeatureCall featureCall : this.externalFeatureCalls.get((Object)parameterName)) {
                ITextRegion textRegion = this.locationInFileProvider.getSignificantTextRegion((EObject)featureCall, (EStructuralFeature)XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, -1);
                parameterRenames.add(new ReplaceRegion(textRegion, parameter.getNewName()));
            }
        }
        Collections.sort(parameterRenames, new Comparator<ReplaceRegion>(){

            @Override
            public int compare(ReplaceRegion o1, ReplaceRegion o2) {
                return o2.getOffset() - o1.getOffset();
            }
        });
        StringBuffer buffer = new StringBuffer(expressionsAsString);
        for (ReplaceRegion parameterRename : parameterRenames) {
            buffer.replace(parameterRename.getOffset() - expressionsRegion.getOffset(), parameterRename.getEndOffset() - expressionsRegion.getOffset(), parameterRename.getText());
        }
        expressionsAsString = buffer.toString();
        return expressionsAsString;
    }

    protected void createMethodCallEdit(DocumentRewriter.Section methodCallSection, ITextRegion expressionRegion) throws BadLocationException {
        String expressionExpanded;
        if (this.firstExpression.eContainer() instanceof RichString) {
            methodCallSection.append((CharSequence)"\u00ab");
        }
        if (this.isNeedsReturnExpression()) {
            JvmIdentifiableElement returnFeature = ((XFeatureCall)this.returnExpression).getFeature();
            if (this.isFinalFeature(returnFeature)) {
                methodCallSection.append((CharSequence)"val ");
            } else {
                methodCallSection.append((CharSequence)"var ");
            }
            methodCallSection.append((CharSequence)returnFeature.getSimpleName()).append((CharSequence)" = ");
        }
        boolean needsSurroundingParentheses = false;
        if (!(!(this.firstExpression.eContainer() instanceof XMemberFeatureCall) || ((XMemberFeatureCall)this.firstExpression.eContainer()).getMemberCallArguments().size() != 1 || (expressionExpanded = this.document.get(expressionRegion.getOffset() - 1, expressionRegion.getLength() + 2)).startsWith("(") && expressionExpanded.endsWith(")"))) {
            needsSurroundingParentheses = true;
            methodCallSection.append((CharSequence)"(");
        }
        methodCallSection.append((CharSequence)this.methodName).append((CharSequence)"(");
        boolean isFirst = true;
        for (ParameterInfo parameterInfo : this.getParameterInfos()) {
            if (!isFirst) {
                methodCallSection.append((CharSequence)", ");
            }
            isFirst = false;
            methodCallSection.append((CharSequence)parameterInfo.getOldName());
        }
        methodCallSection.append((CharSequence)")");
        if (needsSurroundingParentheses) {
            methodCallSection.append((CharSequence)")");
        }
        if (this.lastExpression.eContainer() instanceof RichString) {
            methodCallSection.append((CharSequence)"\u00bb");
        }
    }

    protected boolean isEndOfOriginalMethod() {
        EObject eContainer = this.lastExpression.eContainer();
        if (eContainer instanceof XBlockExpression && eContainer.eContainer() == this.originalMethod) {
            EList siblings = ((XBlockExpression)eContainer).getExpressions();
            return siblings.indexOf((Object)this.lastExpression) == siblings.size() - 1;
        }
        return false;
    }

    protected boolean isNeedsReturnExpression() {
        return this.returnExpression != null && this.returnExpression != this.lastExpression;
    }

    protected boolean isFinalFeature(JvmIdentifiableElement returnFeature) {
        return returnFeature instanceof JvmFormalParameter || returnFeature instanceof XVariableDeclaration && !((XVariableDeclaration)returnFeature).isWriteable();
    }
}

