/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.scoping.impl;

import org.eclipse.xtext.naming.QualifiedName;

public class ImportNormalizer {
    private final QualifiedName importedNamespacePrefix;
    private final boolean hasWildCard;
    private final boolean ignoreCase;

    public ImportNormalizer(QualifiedName importedNamespace, boolean wildCard, boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
        if (importedNamespace == null || importedNamespace.isEmpty()) {
            throw new IllegalArgumentException("Imported namespace must not be null / empty");
        }
        this.hasWildCard = wildCard;
        this.importedNamespacePrefix = importedNamespace;
    }

    public QualifiedName deresolve(QualifiedName fullyQualifiedName) {
        if (this.hasWildCard) {
            if (!this.ignoreCase ? fullyQualifiedName.startsWith(this.importedNamespacePrefix) && fullyQualifiedName.getSegmentCount() != this.importedNamespacePrefix.getSegmentCount() : fullyQualifiedName.startsWithIgnoreCase(this.importedNamespacePrefix) && fullyQualifiedName.getSegmentCount() != this.importedNamespacePrefix.getSegmentCount()) {
                return fullyQualifiedName.skipFirst(this.importedNamespacePrefix.getSegmentCount());
            }
        } else if (!this.ignoreCase ? fullyQualifiedName.equals(this.importedNamespacePrefix) : fullyQualifiedName.equalsIgnoreCase(this.importedNamespacePrefix)) {
            return QualifiedName.create(fullyQualifiedName.getLastSegment());
        }
        return null;
    }

    public QualifiedName resolve(QualifiedName relativeName) {
        if (relativeName.isEmpty()) {
            return null;
        }
        if (this.hasWildCard) {
            return this.importedNamespacePrefix.append(relativeName);
        }
        if (!this.ignoreCase) {
            if (relativeName.getSegmentCount() == 1 && relativeName.getLastSegment().equals(this.importedNamespacePrefix.getLastSegment())) {
                return this.importedNamespacePrefix;
            }
        } else if (relativeName.getSegmentCount() == 1 && relativeName.getLastSegment().equalsIgnoreCase(this.importedNamespacePrefix.getLastSegment())) {
            return this.importedNamespacePrefix.skipLast(1).append(relativeName.getLastSegment());
        }
        return null;
    }

    public String toString() {
        return String.valueOf(this.importedNamespacePrefix.toString()) + (this.hasWildCard ? ".*" : "");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.hasWildCard ? 1231 : 1237);
        result = 31 * result + (this.ignoreCase ? 1231 : 1237);
        result = 31 * result + (this.ignoreCase ? this.importedNamespacePrefix.toLowerCase().hashCode() : this.importedNamespacePrefix.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof ImportNormalizer) {
            ImportNormalizer other = (ImportNormalizer)obj;
            if (other.hasWildCard != this.hasWildCard || other.ignoreCase != this.ignoreCase) {
                return false;
            }
            if (this.ignoreCase) {
                return other.importedNamespacePrefix.equalsIgnoreCase(this.importedNamespacePrefix);
            }
            return other.importedNamespacePrefix.equals(this.importedNamespacePrefix);
        }
        return false;
    }

    public QualifiedName getImportedNamespacePrefix() {
        return this.importedNamespacePrefix;
    }

    public boolean hasWildCard() {
        return this.hasWildCard;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }
}

