/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.formatting;

import com.google.inject.Inject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.xtext.formatting.INodeModelFormatter;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.formatting.IContentFormatterFactory;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.reconciler.ReplaceRegion;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class ContentFormatterFactory
implements IContentFormatterFactory {
    @Inject
    protected INodeModelFormatter formatter;

    @Override
    public IContentFormatter createConfiguredFormatter(SourceViewerConfiguration configuration, ISourceViewer sourceViewer) {
        return new ContentFormatter();
    }

    protected TextEdit createTextEdit(IXtextDocument doc, ReplaceRegion r) throws BadLocationException {
        String originalText = doc.get(r.getOffset(), r.getLength());
        String newText = r.getText();
        int start = 0;
        int originalEnd = originalText.length() - 1;
        int newEnd = newText.length() - 1;
        int minLen = Math.min(r.getLength(), newText.length());
        while (start < minLen && originalText.charAt(start) == newText.charAt(start)) {
            ++start;
        }
        while (originalEnd >= start && newEnd >= start && originalText.charAt(originalEnd) == newText.charAt(newEnd)) {
            --originalEnd;
            --newEnd;
        }
        return new ReplaceEdit(r.getOffset() + start, originalEnd - start + 1, r.getText().substring(start, newEnd + 1));
    }

    public class ContentFormatter
    implements IContentFormatter {
        public void format(IDocument document, IRegion region) {
            IXtextDocument doc = (IXtextDocument)document;
            ReplaceRegion r = (ReplaceRegion)doc.priorityReadOnly(new FormattingUnitOfWork(region));
            try {
                TextEdit edit;
                if (r != null && (edit = ContentFormatterFactory.this.createTextEdit(doc, r)) != null) {
                    edit.apply((IDocument)doc);
                }
            }
            catch (BadLocationException e) {
                throw new RuntimeException(e);
            }
        }

        public IFormattingStrategy getFormattingStrategy(String contentType) {
            return null;
        }
    }

    public class FormattingUnitOfWork
    implements IUnitOfWork<ReplaceRegion, XtextResource> {
        protected final IRegion region;

        public FormattingUnitOfWork(IRegion region) {
            this.region = region;
        }

        public ReplaceRegion exec(XtextResource state) throws Exception {
            IParseResult parseResult = state.getParseResult();
            if (parseResult == null) {
                return null;
            }
            INodeModelFormatter.IFormattedRegion r = ContentFormatterFactory.this.formatter.format(parseResult.getRootNode(), this.region.getOffset(), this.region.getLength());
            return new ReplaceRegion(r.getOffset(), r.getLength(), r.getFormattedText());
        }
    }
}

