/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.sandbox.search.ui;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mylyn.internal.sandbox.search.ui.DesktopSearchResult;
import org.eclipse.mylyn.internal.sandbox.search.ui.DesktopSearchResultEvent;
import org.eclipse.mylyn.sandbox.search.ui.SearchResult;
import org.eclipse.search.ui.ISearchResultListener;
import org.eclipse.search.ui.SearchResultEvent;
import org.eclipse.swt.widgets.Control;

class ContentProvider
implements ITreeContentProvider,
ISearchResultListener {
    private DesktopSearchResult searchResult;
    private TreeViewer viewer;

    ContentProvider() {
    }

    public void dispose() {
        if (this.searchResult != null) {
            this.searchResult.removeListener(this);
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = (TreeViewer)viewer;
        if (this.searchResult != null) {
            this.searchResult.removeListener(this);
        }
        this.searchResult = (DesktopSearchResult)newInput;
        if (this.searchResult != null) {
            this.searchResult.addListener(this);
        }
    }

    public Object[] getElements(Object inputElement) {
        if (this.searchResult == inputElement) {
            List<SearchResult> items = this.searchResult.getItems();
            return this.convertToContent(items);
        }
        return new Object[0];
    }

    public Object[] getChildren(Object parentElement) {
        return this.getElements(parentElement);
    }

    public Object getParent(Object element) {
        if (element != this.searchResult) {
            return this.searchResult;
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return element == this.searchResult;
    }

    public void searchResultChanged(SearchResultEvent e) {
        final DesktopSearchResultEvent event = (DesktopSearchResultEvent)e;
        final Control control = this.viewer.getControl();
        if (!control.isDisposed()) {
            control.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!control.isDisposed() && ContentProvider.this.viewer.getInput() == event.getSearchResult()) {
                        switch (event.getKind()) {
                            case ADDED: {
                                ContentProvider.this.viewer.add((Object)ContentProvider.this.searchResult, ContentProvider.this.convertToContent(Arrays.asList(event.getItems())));
                                break;
                            }
                            case CLEARED: {
                                ContentProvider.this.viewer.refresh();
                            }
                        }
                    }
                }
            });
        }
    }

    private Object[] convertToContent(List<SearchResult> searchResults) {
        Object[] converted = new Object[searchResults.size()];
        int x = 0;
        while (x < searchResults.size()) {
            converted[x] = this.convertToContent(searchResults.get(x));
            ++x;
        }
        return converted;
    }

    private Object convertToContent(SearchResult result) {
        IResource resource = result.getResource();
        return resource == null ? result : resource;
    }
}

