/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.sandbox.search.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.internal.sandbox.search.ui.DesktopSearchResult;
import org.eclipse.mylyn.internal.sandbox.search.ui.Messages;
import org.eclipse.mylyn.sandbox.search.ui.SearchCallback;
import org.eclipse.mylyn.sandbox.search.ui.SearchCriteria;
import org.eclipse.mylyn.sandbox.search.ui.SearchProvider;
import org.eclipse.mylyn.sandbox.search.ui.SearchResult;
import org.eclipse.osgi.util.NLS;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;

public class DesktopSearchQuery
implements ISearchQuery {
    private final SearchProvider provider;
    private final SearchCriteria criteria;
    private final DesktopSearchResult searchResult;

    public DesktopSearchQuery(SearchProvider provider, SearchCriteria criteria) {
        this.provider = provider;
        this.criteria = criteria;
        this.searchResult = new DesktopSearchResult(this);
    }

    public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        this.searchResult.clear();
        SearchCallback callback = new SearchCallback(){

            @Override
            public void searchResult(SearchResult item) {
                DesktopSearchQuery.this.searchResult.add(item);
            }
        };
        this.searchResult.setSearchInProgres(true);
        try {
            try {
                this.provider.performSearch(this.criteria, callback, monitor);
            }
            catch (CoreException e) {
                IStatus iStatus = e.getStatus();
                this.searchResult.setSearchInProgres(false);
                return iStatus;
            }
        }
        finally {
            this.searchResult.setSearchInProgres(false);
        }
        return Status.OK_STATUS;
    }

    public String getLabel() {
        return Messages.DesktopSearchQuery_Label;
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public ISearchResult getSearchResult() {
        return this.searchResult;
    }

    public String getResultLabel(boolean inProgress, int size) {
        if (inProgress) {
            if (size == 0) {
                return NLS.bind((String)Messages.DesktopSearchQuery_Searching, (Object)this.criteria.getText());
            }
            if (size == 1) {
                return NLS.bind((String)Messages.DesktopSearchQuery_Searching_OneFileMatch, (Object)this.criteria.getText());
            }
            return NLS.bind((String)Messages.DesktopSearchQuery_Searching_NFilesMatching, (Object)this.criteria.getText(), (Object)size);
        }
        if (size == 0) {
            return NLS.bind((String)Messages.DesktopSearchQuery_NoFilesMatching, (Object)this.criteria.getText());
        }
        if (size == 1) {
            return NLS.bind((String)Messages.DesktopSearchQuery_OneFileMatches, (Object)this.criteria.getText());
        }
        if (size >= this.criteria.getMaximumResults()) {
            return NLS.bind((String)Messages.DesktopSearchQuery_NFilesMatching_MaxReached, (Object[])new Object[]{this.criteria.getText(), size, this.criteria.getMaximumResults()});
        }
        return NLS.bind((String)Messages.DesktopSearchQuery_NFilesMatching, (Object)this.criteria.getText(), (Object)size);
    }
}

