/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.sandbox.search.ui.provider;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.regex.Pattern;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.mylyn.internal.sandbox.search.ui.provider.Messages;
import org.eclipse.mylyn.internal.sandbox.search.ui.provider.ReaderCharSequence;
import org.eclipse.mylyn.sandbox.search.ui.SearchCallback;
import org.eclipse.mylyn.sandbox.search.ui.SearchCriteria;
import org.eclipse.mylyn.sandbox.search.ui.SearchProvider;
import org.eclipse.mylyn.sandbox.search.ui.SearchResult;
import org.eclipse.osgi.util.NLS;

public class BasicSearchProvider
extends SearchProvider {
    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void performSearch(SearchCriteria searchSpecification, SearchCallback callback, IProgressMonitor m) throws CoreException {
        monitor = SubMonitor.convert((IProgressMonitor)m);
        monitor.beginTask(NLS.bind((String)Messages.BasicSearchProvider_0, (Object)searchSpecification.getText()), searchSpecification.getMaximumResults() > 0 ? searchSpecification.getMaximumResults() : -1);
        try {
            matcher = this.computeMatcher(searchSpecification);
            roots = File.listRoots();
            if (roots == null) return;
            matchCount = 0;
            state = new Stack<IFileStore>();
            x = roots.length - 1;
            while (x >= 0) {
                if (!monitor.isCanceled()) {
                    root = roots[x];
                    fileStore = EFS.getLocalFileSystem().fromLocalFile(root);
                    state.push(fileStore);
                    --x;
                    continue;
                }
                ** GOTO lbl40
            }
            try {
                if (true) ** GOTO lbl40
                do {
                    if (!this.isDefaultIgnore(fileStore = (IFileStore)state.pop(), fileInfo = fileStore.fetchInfo())) {
                        if (fileInfo.isDirectory()) {
                            monitor.subTask(fileStore.toString());
                            var15_17 = childStores = fileStore.childStores(0, (IProgressMonitor)monitor.newChild(0));
                            var14_16 = childStores.length;
                            var13_15 = 0;
                            while (var13_15 < var14_16) {
                                child = var15_17[var13_15];
                                state.push(child);
                                ++var13_15;
                            }
                        } else if (matcher.matches(fileStore, (IProgressMonitor)monitor.newChild(0))) {
                            monitor.worked(1);
                            callback.searchResult(new SearchResult(fileStore.toLocalFile(0, (IProgressMonitor)monitor.newChild(0))));
                            if (++matchCount >= searchSpecification.getMaximumResults()) {
                                return;
                            }
                        }
                    }
lbl40:
                    // 9 sources

                    if (state.isEmpty()) return;
                } while (!monitor.isCanceled());
                return;
            }
            catch (OperationCanceledException v0) {
                return;
            }
            catch (CoreException e) {
                if (e.getStatus().getSeverity() == 8) return;
                throw e;
            }
        }
        finally {
            monitor.done();
        }
    }

    private boolean isDefaultIgnore(IFileStore fileStore, IFileInfo fileInfo) {
        if (fileInfo.getAttribute(32) || fileInfo.getAttribute(16)) {
            return true;
        }
        String name = fileStore.getName();
        if (fileInfo.isDirectory()) {
            if ((name.equals("Windows") || name.equals("$Recycle.Bin")) && fileStore.getParent() != null && fileStore.getParent().getParent() == null) {
                return true;
            }
            if (name.startsWith(".")) {
                return true;
            }
        } else if (name.endsWith(".dll") || name.endsWith(".exe") || name.endsWith(".sys") || name.endsWith(".zip") || name.endsWith(".jar") || name.endsWith(".bin")) {
            return true;
        }
        return false;
    }

    private FileMatcher computeMatcher(SearchCriteria searchSpecification) {
        ArrayList<FileMatcher> filenameMatchers = new ArrayList<FileMatcher>();
        String[] stringArray = searchSpecification.getFilenamePatterns();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String filenamePattern = stringArray[n2];
            if (filenamePattern.length() > 0) {
                if (filenamePattern.equals("*") || filenamePattern.equals("*.*")) {
                    filenameMatchers.clear();
                    break;
                }
                filenameMatchers.add(new FileNameMatcher(filenamePattern));
            }
            ++n2;
        }
        CompositeFileMatcher fileMatcher = new CompositeFileMatcher(true);
        if (!filenameMatchers.isEmpty()) {
            fileMatcher.add(filenameMatchers.size() == 1 ? (FileMatcher)filenameMatchers.get(0) : new CompositeFileMatcher(filenameMatchers, false));
        }
        if (searchSpecification.getText() != null && searchSpecification.getText().trim().length() > 0) {
            fileMatcher.add(new FileContentMatcher(searchSpecification));
        }
        return fileMatcher;
    }

    private String patternToRegex(String matchPattern) {
        String regex = "";
        char[] cArray = matchPattern.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (Character.isLetterOrDigit(c)) {
                regex = String.valueOf(regex) + c;
            } else if (c == '*') {
                regex = String.valueOf(regex) + ".*";
            } else if (c == '?') {
                regex = String.valueOf(regex) + ".";
            } else {
                regex = String.valueOf(regex) + "\\";
                regex = String.valueOf(regex) + c;
            }
            ++n2;
        }
        return regex;
    }

    private class CompositeFileMatcher
    extends FileMatcher {
        private final List<FileMatcher> delegates;
        private final boolean allMatch;

        public CompositeFileMatcher(boolean allMatch) {
            this.allMatch = allMatch;
            this.delegates = new ArrayList<FileMatcher>();
        }

        public CompositeFileMatcher(List<FileMatcher> delegates, boolean allMatch) {
            this.delegates = delegates;
            this.allMatch = allMatch;
        }

        public void add(FileMatcher matcher) {
            this.delegates.add(matcher);
        }

        @Override
        public boolean matches(IFileStore file, IProgressMonitor monitor) {
            for (FileMatcher matcher : this.delegates) {
                if (monitor.isCanceled()) {
                    return false;
                }
                if (!matcher.matches(file, monitor)) {
                    if (!this.allMatch) continue;
                    return false;
                }
                if (this.allMatch) continue;
                return true;
            }
            return this.allMatch;
        }
    }

    private class FileContentMatcher
    extends FileMatcher {
        private final Pattern pattern;
        private final int maxMatchingCharacters = 16384;

        public FileContentMatcher(SearchCriteria searchSpecification) {
            this.maxMatchingCharacters = 16384;
            this.pattern = Pattern.compile(BasicSearchProvider.this.patternToRegex(searchSpecification.getText().trim()), 2);
        }

        /*
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean matches(IFileStore file, IProgressMonitor monitor) {
            monitor.subTask(file.toString());
            try {
                InputStream inputStream = file.openInputStream(0, monitor);
                try {
                    boolean bl;
                    InputStreamReader reader = new InputStreamReader(new BufferedInputStream(inputStream));
                    try {
                        ReaderCharSequence charSequence = new ReaderCharSequence(16384, reader, monitor);
                        bl = this.pattern.matcher(charSequence).find();
                    }
                    catch (Throwable throwable) {
                        reader.close();
                        throw throwable;
                    }
                    reader.close();
                    return bl;
                }
                finally {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
            }
            catch (CoreException coreException) {}
            return false;
        }
    }

    private abstract class FileMatcher {
        private FileMatcher() {
        }

        public abstract boolean matches(IFileStore var1, IProgressMonitor var2);
    }

    private class FileNameMatcher
    extends FileMatcher {
        private final Pattern pattern;

        public FileNameMatcher(String matchPattern) {
            String regex = ".*?";
            regex = String.valueOf(regex) + BasicSearchProvider.this.patternToRegex(matchPattern);
            regex = String.valueOf(regex) + ".*";
            this.pattern = Pattern.compile(regex, 2);
        }

        @Override
        public boolean matches(IFileStore file, IProgressMonitor monitor) {
            String name = file.getName();
            return this.pattern.matcher(name).matches();
        }
    }
}

