/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.sandbox.ui;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.Person;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.internal.tasks.ui.views.AbstractTaskListView;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListContentProvider;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskContainer;

public class IncomingTaskListContentProvider
extends TaskListContentProvider {
    Set<AbstractTaskContainer> people = new HashSet<AbstractTaskContainer>();

    public IncomingTaskListContentProvider(TaskListView taskListView) {
        super((AbstractTaskListView)taskListView);
    }

    public Object[] getElements(Object parent) {
        this.people.clear();
        if (parent instanceof Person) {
            return this.getChildren(parent);
        }
        for (ITaskContainer container : this.applyFilter(TasksUiPlugin.getTaskList().getRootElements())) {
            for (ITask task : this.getAllTasks(container.getChildren())) {
                if (task.getOwner() == null || !TasksUiInternal.shouldShowIncoming((ITask)task)) continue;
                this.people.add((AbstractTaskContainer)new Person(task.getOwner(), task.getConnectorKind(), task.getRepositoryUrl()));
            }
        }
        return this.people.toArray();
    }

    private Set<ITask> getAllTasks(Collection<ITask> children) {
        if (children != null) {
            HashSet<ITask> alltasks = new HashSet<ITask>(children);
            for (ITask task : children) {
                Set<ITask> childTasks;
                if (!(task instanceof AbstractTask) || (childTasks = this.getAllTasks(((AbstractTask)task).getChildren())) == null) continue;
                alltasks.addAll(childTasks);
            }
            return alltasks;
        }
        return null;
    }

    public Object[] getChildren(TreePath parentPath) {
        return this.getChildren(parentPath.getLastSegment());
    }

    public Object[] getChildren(Object parent) {
        HashSet<ITask> children = new HashSet<ITask>();
        if (parent instanceof Person) {
            for (ITaskContainer container : this.applyFilter(TasksUiPlugin.getTaskList().getRootElements())) {
                for (ITask task : this.getAllTasks(container.getChildren())) {
                    if (task.getOwner() == null || !task.getOwner().equals(((Person)parent).getHandleIdentifier()) || !TasksUiInternal.shouldShowIncoming((ITask)task)) continue;
                    children.add(task);
                }
            }
        }
        return children.toArray();
    }

    public boolean hasChildren(Object parent) {
        return parent instanceof Person;
    }
}

