/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.version.digest;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.oomph.version.IBuildState;
import org.eclipse.oomph.version.IElement;
import org.eclipse.oomph.version.IRelease;
import org.eclipse.oomph.version.IReleaseManager;
import org.eclipse.oomph.version.VersionUtil;
import org.eclipse.oomph.version.VersionValidator;
import org.eclipse.oomph.version.digest.Activator;
import org.eclipse.oomph.version.digest.DigestValidatorState;
import org.eclipse.oomph.version.digest.ReleaseDigest;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DigestValidator
extends VersionValidator {
    private static final Map<IRelease, ReleaseDigest> RELEASE_DIGESTS = new WeakHashMap<IRelease, ReleaseDigest>();

    public String getVersion() {
        return Activator.getVersion();
    }

    public void updateBuildState(IBuildState buildState, IRelease release, IProject project, IResourceDelta delta, IModel componentModel, IProgressMonitor monitor) throws Exception {
        DigestValidatorState validatorState = (DigestValidatorState)buildState.getValidatorState();
        IPath releasePath = release.getFile().getFullPath();
        ReleaseDigest releaseDigest = this.getReleaseDigest(releasePath, release, monitor);
        long timeStamp = releaseDigest.getTimeStamp();
        if (timeStamp != buildState.getValidatorTimeStamp()) {
            delta = null;
            buildState.setValidatorTimeStamp(timeStamp);
        }
        this.beforeValidation(validatorState, componentModel);
        if (validatorState == null || delta == null) {
            if (VersionUtil.DEBUG) {
                System.out.println("Digest: Full validation...");
            }
            buildState.setValidatorState(null);
            validatorState = this.validateFull((IResource)project, null, componentModel, monitor);
        } else {
            if (VersionUtil.DEBUG) {
                System.out.println("Digest: Incremental validation...");
            }
            validatorState = this.validateDelta(delta, validatorState, componentModel, monitor);
        }
        this.afterValidation(validatorState);
        if (validatorState == null) {
            throw new IllegalStateException("No validation state");
        }
        byte[] validatorDigest = validatorState.getDigest();
        if (VersionUtil.DEBUG) {
            System.out.println("DIGEST  = " + this.formatDigest(validatorDigest));
        }
        byte[] releasedProjectDigest = (byte[])releaseDigest.get(project.getName());
        if (VersionUtil.DEBUG) {
            System.out.println("RELEASE = " + this.formatDigest(releasedProjectDigest));
        }
        boolean changedSinceRelease = !MessageDigest.isEqual(validatorDigest, releasedProjectDigest);
        buildState.setChangedSinceRelease(changedSinceRelease);
        buildState.setValidatorState((Serializable)validatorState);
    }

    public DigestValidatorState validateFull(IResource resource, DigestValidatorState parentState, IModel componentModel, IProgressMonitor monitor) throws Exception {
        if (resource.getType() != 4 && !this.isConsidered(resource)) {
            return null;
        }
        if (VersionUtil.DEBUG) {
            System.out.println("Digest: " + resource.getFullPath());
        }
        DigestValidatorState result = new DigestValidatorState();
        result.setName(resource.getName());
        result.setParent(parentState);
        if (resource instanceof IContainer) {
            IContainer container = (IContainer)resource;
            ArrayList<DigestValidatorState> memberStates = new ArrayList<DigestValidatorState>();
            IResource[] iResourceArray = container.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource member = iResourceArray[n2];
                DigestValidatorState memberState = this.validateFull(member, result, componentModel, monitor);
                if (memberState != null) {
                    memberStates.add(memberState);
                }
                ++n2;
            }
            byte[] digest = this.getFolderDigest(memberStates);
            if (VersionUtil.DEBUG) {
                System.out.println("Considered: " + container.getFullPath() + " --> " + this.formatDigest(digest));
            }
            result.setDigest(digest);
            result.setChildren(memberStates.toArray(new DigestValidatorState[memberStates.size()]));
        } else {
            IFile file = (IFile)resource;
            byte[] digest = this.getFileDigest(file);
            if (VersionUtil.DEBUG) {
                System.out.println("Considered: " + file.getFullPath() + " --> " + this.formatDigest(digest));
            }
            result.setDigest(digest);
        }
        return result;
    }

    public DigestValidatorState validateDelta(IResourceDelta delta, DigestValidatorState validatorState, IModel componentModel, IProgressMonitor monitor) throws Exception {
        IResource resource = delta.getResource();
        if (!resource.exists() || resource.getType() != 4 && !this.isConsidered(resource)) {
            return null;
        }
        DigestValidatorState result = validatorState;
        switch (delta.getKind()) {
            case 1: {
                result = new DigestValidatorState();
                result.setName(resource.getName());
            }
            case 4: {
                boolean changed;
                if (resource instanceof IContainer) {
                    HashSet<DigestValidatorState> memberStates = new HashSet<DigestValidatorState>();
                    IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren();
                    int n = iResourceDeltaArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResourceDelta memberDelta = iResourceDeltaArray[n2];
                        IResource memberResource = memberDelta.getResource();
                        DigestValidatorState memberState = validatorState != null ? validatorState.getChild(memberResource.getName()) : null;
                        DigestValidatorState newMemberState = this.validateDelta(memberDelta, memberState, componentModel, monitor);
                        if (newMemberState != null) {
                            newMemberState.setParent(result);
                            memberStates.add(newMemberState);
                        }
                        ++n2;
                    }
                    if (validatorState != null) {
                        IContainer container = (IContainer)resource;
                        DigestValidatorState[] digestValidatorStateArray = validatorState.getChildren();
                        int n3 = digestValidatorStateArray.length;
                        n = 0;
                        while (n < n3) {
                            DigestValidatorState oldChild = digestValidatorStateArray[n];
                            IResource member = container.findMember(oldChild.getName());
                            if (member != null) {
                                memberStates.add(oldChild);
                            }
                            ++n;
                        }
                    }
                    byte[] digest = this.getFolderDigest(memberStates);
                    result.setDigest(digest);
                    result.setChildren(memberStates.toArray(new DigestValidatorState[memberStates.size()]));
                    break;
                }
                boolean bl = changed = result == validatorState;
                if (changed && (delta.getFlags() & 0x100) == 0) {
                    return validatorState;
                }
                IFile file = (IFile)resource;
                byte[] digest = this.getFileDigest(file);
                result.setDigest(digest);
                break;
            }
            case 2: {
                result = null;
            }
        }
        return result;
    }

    protected boolean isConsidered(IResource resource) {
        return !resource.isDerived();
    }

    protected void beforeValidation(DigestValidatorState validatorState, IModel componentModel) throws Exception {
    }

    protected void afterValidation(DigestValidatorState validatorState) throws Exception {
    }

    private ReleaseDigest getReleaseDigest(IPath releasePath, IRelease release, IProgressMonitor monitor) throws IOException, CoreException, ClassNotFoundException {
        IFile file = DigestValidator.getDigestFile(releasePath);
        long localTimeStamp = file.getLocalTimeStamp();
        ReleaseDigest releaseDigest = RELEASE_DIGESTS.get(release);
        if (releaseDigest != null && localTimeStamp != releaseDigest.getTimeStamp()) {
            releaseDigest = null;
        }
        if (releaseDigest == null) {
            if (file.exists() && !MessageDigest.isEqual((releaseDigest = this.readDigestFile(file)).getReleaseSpecDigest(), release.getDigest())) {
                releaseDigest = null;
            }
            if (releaseDigest == null) {
                releaseDigest = this.createReleaseDigest(release, file, null, monitor);
            }
            releaseDigest.setTimeStamp(localTimeStamp);
            RELEASE_DIGESTS.put(release, releaseDigest);
        }
        return releaseDigest;
    }

    private byte[] getFolderDigest(Collection<DigestValidatorState> states) throws Exception {
        ArrayList<DigestValidatorState> list = new ArrayList<DigestValidatorState>(states);
        Collections.sort(list);
        MessageDigest digest = MessageDigest.getInstance("SHA");
        for (DigestValidatorState state : list) {
            byte[] bytes = state.getDigest();
            if (bytes == null) continue;
            digest.update(state.getName().getBytes());
            digest.update(bytes);
        }
        return digest.digest();
    }

    private byte[] getFileDigest(IFile file) throws Exception {
        return VersionUtil.getSHA1((IFile)file);
    }

    private String formatDigest(byte[] digest) {
        StringBuilder builder = new StringBuilder();
        byte[] byArray = digest;
        int n = digest.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            if (builder.length() != 0) {
                builder.append(", ");
            }
            builder.append("(byte)");
            builder.append(b);
            ++n2;
        }
        return builder.toString();
    }

    private ReleaseDigest readDigestFile(IFile file) throws IOException, CoreException, ClassNotFoundException {
        ObjectInputStream stream = null;
        try {
            stream = new ObjectInputStream(file.getContents());
            ReleaseDigest releaseDigest = (ReleaseDigest)stream.readObject();
            return releaseDigest;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception ex) {
                    Activator.log(ex);
                }
            }
        }
    }

    private void writeReleaseDigest(ReleaseDigest releaseDigest, IFile target, IProgressMonitor monitor) throws IOException, CoreException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(releaseDigest);
        oos.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        if (target.exists()) {
            int i = 1;
            while (true) {
                try {
                    target.move(target.getFullPath().addFileExtension("bak" + i), true, monitor);
                }
                catch (Exception exception) {
                    ++i;
                    continue;
                }
                break;
            }
        }
        target.create((InputStream)bais, true, monitor);
        monitor.worked(1);
    }

    private void addWarning(List<String> warnings, String msg) {
        Activator.log((IStatus)new Status(2, "org.eclipse.oomph.version.digest", msg));
        if (warnings != null) {
            warnings.add(msg);
        }
    }

    public ReleaseDigest createReleaseDigest(IRelease release, IFile target, List<String> warnings, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(null, release.getSize() + 1);
        try {
            ReleaseDigest releaseDigest = new ReleaseDigest(release.getDigest());
            for (Map.Entry entry : release.getElements().entrySet()) {
                String name = ((IElement)entry.getKey()).getName();
                monitor.subTask(name);
                try {
                    try {
                        IElement element = (IElement)entry.getValue();
                        if (element.getName().endsWith(".source")) continue;
                        IModel componentModel = IReleaseManager.INSTANCE.getComponentModel(element.trimVersion());
                        if (componentModel == null) {
                            this.addWarning(warnings, String.valueOf(name) + ": Component not found");
                            continue;
                        }
                        IResource resource = componentModel.getUnderlyingResource();
                        if (resource == null) {
                            String type = componentModel instanceof IPluginModelBase ? "Plug-in" : "Feature";
                            this.addWarning(warnings, String.valueOf(name) + ": " + type + " is not in workspace");
                            continue;
                        }
                        Version version = VersionUtil.getComponentVersion((IModel)componentModel);
                        if (!element.getVersion().equals((Object)version)) {
                            String type = componentModel instanceof IPluginModelBase ? "Plug-in" : "Feature";
                            this.addWarning(warnings, String.valueOf(name) + ": " + type + " version is not " + element.getVersion());
                        }
                        IProject project = resource.getProject();
                        this.beforeValidation(null, componentModel);
                        DigestValidatorState state = this.validateFull((IResource)project, null, componentModel, monitor);
                        this.afterValidation(state);
                        releaseDigest.put(state.getName(), state.getDigest());
                    }
                    finally {
                        monitor.worked(1);
                    }
                }
                catch (Exception ex) {
                    this.addWarning(warnings, String.valueOf(name) + ": " + Activator.getStatus(ex).getMessage());
                }
            }
            this.writeReleaseDigest(releaseDigest, target, monitor);
            ReleaseDigest releaseDigest2 = releaseDigest;
            return releaseDigest2;
        }
        catch (CoreException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new CoreException(Activator.getStatus(ex));
        }
        finally {
            monitor.done();
        }
    }

    public static IFile getDigestFile(IPath releasePath) {
        return VersionUtil.getFile((IPath)releasePath, (String)"digest");
    }

    public static class BuildModel
    extends DigestValidator {
        private Set<String> considered = new HashSet<String>();

        protected void beforeValidation(DigestValidatorState validatorState, IModel componentModel) throws Exception {
            this.considered.clear();
            this.considered.add("");
            IBuild build = VersionUtil.getBuild((IModel)componentModel);
            IBuildEntry binIncludes = build.getEntry("bin.includes");
            if (binIncludes != null) {
                String[] stringArray = binIncludes.getTokens();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String binInclude = stringArray[n2];
                    IBuildEntry sources = build.getEntry("source." + binInclude);
                    if (sources != null) {
                        String[] stringArray2 = sources.getTokens();
                        int n3 = stringArray2.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String source = stringArray2[n4];
                            this.consider(source);
                            ++n4;
                        }
                    } else {
                        this.consider(binInclude);
                    }
                    ++n2;
                }
            }
        }

        protected void afterValidation(DigestValidatorState validatorState) throws Exception {
            this.considered.clear();
        }

        protected boolean isConsidered(IResource resource) {
            IPath path = resource.getProjectRelativePath();
            while (!path.isEmpty()) {
                if (this.considered.contains(path.toString())) {
                    return true;
                }
                path = path.removeLastSegments(1);
            }
            return false;
        }

        private void consider(String path) {
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            this.considered.add(path);
        }
    }
}

