/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.sync;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.eclipse.oomph.setup.internal.sync.DataProvider;
import org.eclipse.oomph.setup.internal.sync.SetupSyncPlugin;
import org.eclipse.oomph.setup.internal.sync.Snapshot;
import org.eclipse.oomph.setup.internal.sync.Synchronization;
import org.eclipse.oomph.setup.internal.sync.SynchronizerException;
import org.eclipse.oomph.setup.internal.sync.SynchronizerListener;
import org.eclipse.oomph.setup.sync.SyncAction;
import org.eclipse.oomph.util.ConcurrentArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Synchronizer {
    private static final LocalLock LOCAL_LOCK = new LocalLock();
    private final ConcurrentArray<SynchronizerListener> listeners = new ConcurrentArray<SynchronizerListener>(){

        protected SynchronizerListener[] newArray(int length) {
            return new SynchronizerListener[length];
        }
    };
    private final Snapshot localSnapshot;
    private final Snapshot remoteSnapshot;
    private Synchronization synchronization;

    public Synchronizer(Snapshot localSnapshot, Snapshot remoteSnapshot) {
        this.localSnapshot = localSnapshot;
        this.remoteSnapshot = remoteSnapshot;
    }

    public Synchronizer(DataProvider localDataProvider, DataProvider remoteDataProvider, File syncFolder) {
        this(new Snapshot(localDataProvider, syncFolder), new Snapshot(remoteDataProvider, syncFolder));
    }

    public Snapshot getLocalSnapshot() {
        return this.localSnapshot;
    }

    public Snapshot getRemoteSnapshot() {
        return this.remoteSnapshot;
    }

    public Synchronization synchronize() throws IOException, SynchronizerException {
        return this.synchronize(false);
    }

    public synchronized Synchronization synchronize(boolean deferLocal) throws IOException, SynchronizerException {
        if (this.synchronization != null) {
            return null;
        }
        LOCAL_LOCK.acquire();
        this.synchronization = this.createSynchronization(deferLocal);
        return this.synchronization;
    }

    protected Synchronization createSynchronization(boolean deferLocal) throws IOException {
        return new Synchronization(this, deferLocal);
    }

    public void addListener(SynchronizerListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeListener(SynchronizerListener listener) {
        this.listeners.remove((Object)listener);
    }

    protected void syncStarted() {
        SynchronizerListener[] synchronizerListenerArray = (SynchronizerListener[])this.listeners.get();
        int n = synchronizerListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            SynchronizerListener listener = synchronizerListenerArray[n2];
            try {
                listener.syncStarted(this.synchronization);
            }
            catch (Throwable ex) {
                SetupSyncPlugin.INSTANCE.log(ex);
            }
            ++n2;
        }
    }

    protected void workingCopyCreated(Snapshot.WorkingCopy workingCopy) {
        SynchronizerListener[] synchronizerListenerArray = (SynchronizerListener[])this.listeners.get();
        int n = synchronizerListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            SynchronizerListener listener = synchronizerListenerArray[n2];
            try {
                listener.workingCopyCreated(this.synchronization, workingCopy);
            }
            catch (Throwable ex) {
                SetupSyncPlugin.INSTANCE.log(ex);
            }
            ++n2;
        }
    }

    protected void actionsComputed(Map<String, SyncAction> actions) {
        SynchronizerListener[] synchronizerListenerArray = (SynchronizerListener[])this.listeners.get();
        int n = synchronizerListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            SynchronizerListener listener = synchronizerListenerArray[n2];
            try {
                listener.actionsComputed(this.synchronization, actions);
            }
            catch (Throwable ex) {
                SetupSyncPlugin.INSTANCE.log(ex);
            }
            ++n2;
        }
    }

    protected void actionResolved(SyncAction action, String id) {
        SynchronizerListener[] synchronizerListenerArray = (SynchronizerListener[])this.listeners.get();
        int n = synchronizerListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            SynchronizerListener listener = synchronizerListenerArray[n2];
            try {
                listener.actionResolved(this.synchronization, action, id);
            }
            catch (Throwable ex) {
                SetupSyncPlugin.INSTANCE.log(ex);
            }
            ++n2;
        }
    }

    protected void commitStarted() {
        SynchronizerListener[] synchronizerListenerArray = (SynchronizerListener[])this.listeners.get();
        int n = synchronizerListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            SynchronizerListener listener = synchronizerListenerArray[n2];
            try {
                listener.commitStarted(this.synchronization);
            }
            catch (Throwable ex) {
                SetupSyncPlugin.INSTANCE.log(ex);
            }
            ++n2;
        }
    }

    protected void commitFinished(Throwable exception) {
        SynchronizerListener[] synchronizerListenerArray = (SynchronizerListener[])this.listeners.get();
        int n = synchronizerListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            SynchronizerListener listener = synchronizerListenerArray[n2];
            try {
                listener.commitFinished(this.synchronization, exception);
            }
            catch (Throwable ex) {
                SetupSyncPlugin.INSTANCE.log(ex);
            }
            ++n2;
        }
    }

    protected synchronized void releaseLock() {
        if (this.synchronization != null) {
            Synchronization oldSynchronization = this.synchronization;
            this.synchronization = null;
            LOCAL_LOCK.release();
            SynchronizerListener[] synchronizerListenerArray = (SynchronizerListener[])this.listeners.get();
            int n = synchronizerListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                SynchronizerListener listener = synchronizerListenerArray[n2];
                try {
                    listener.lockReleased(oldSynchronization);
                }
                catch (Throwable ex) {
                    SetupSyncPlugin.INSTANCE.log(ex);
                }
                ++n2;
            }
        }
    }

    private static final class LocalLock {
        public void acquire() {
        }

        public void release() {
        }
    }
}

