/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.ui.actions;

import java.util.ArrayList;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.ChangeCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.oomph.setup.SetupTaskContainer;
import org.eclipse.oomph.ui.UIUtil;

public abstract class AbstractContainerAction
extends Action {
    private ISelectionProvider selectionProvider;
    private SetupTaskContainer container;

    public AbstractContainerAction() {
    }

    public AbstractContainerAction(String text, ImageDescriptor image) {
        super(text, image);
    }

    public AbstractContainerAction(String text, int style) {
        super(text, style);
    }

    public AbstractContainerAction(String text) {
        super(text);
    }

    public final ISelectionProvider getSelectionProvider() {
        return this.selectionProvider;
    }

    public final SetupTaskContainer getContainer() {
        return this.container;
    }

    public final void selectionChanged(SelectionChangedEvent event) {
        if (this.getStyle() != 2 || !this.isChecked()) {
            Object element;
            IStructuredSelection structuredSelection;
            this.selectionProvider = event.getSelectionProvider();
            ISelection selection = event.getSelection();
            if (selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() == 1 && (element = structuredSelection.getFirstElement()) instanceof EObject) {
                this.container = this.getSetupTaskContainer((EObject)element);
                if (this.container != null) {
                    this.setEnabled(true);
                    return;
                }
            }
            this.container = null;
            this.setEnabled(false);
        }
    }

    public final void run() {
        if ((this.getStyle() == 1 || this.isChecked()) && this.runInit(this.container)) {
            ChangeCommand command = new ChangeCommand((Notifier)this.container.eResource()){

                protected void doExecute() {
                    AbstractContainerAction.this.runModify(AbstractContainerAction.this.container);
                }
            };
            EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)this.container);
            CommandStack commandStack = editingDomain.getCommandStack();
            commandStack.execute((Command)command);
            this.runDone(this.container);
            if (this.getStyle() == 2) {
                this.setChecked(false);
            }
        }
    }

    protected boolean runInit(SetupTaskContainer container) {
        return true;
    }

    protected abstract void runModify(SetupTaskContainer var1);

    protected void runDone(SetupTaskContainer container) {
        this.expandItem((EObject)container);
    }

    protected final void expandItem(final EObject object) {
        IViewerProvider viewerProvider;
        Viewer viewer;
        if (this.selectionProvider instanceof IViewerProvider && (viewer = (viewerProvider = (IViewerProvider)this.selectionProvider).getViewer()) instanceof TreeViewer) {
            UIUtil.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    TreeViewer treeViewer = (TreeViewer)viewer;
                    this.expand(treeViewer, object);
                    IStructuredSelection selection = (IStructuredSelection)treeViewer.getSelection();
                    ArrayList<EObject> list = selection.toList();
                    list = new ArrayList<EObject>(list);
                    list.add(object);
                    treeViewer.setSelection((ISelection)new StructuredSelection(list));
                }

                private void expand(TreeViewer treeViewer, EObject object2) {
                    treeViewer.setExpandedState((Object)object2, true);
                    EObject eContainer = object2.eContainer();
                    if (eContainer != null) {
                        this.expand(treeViewer, eContainer);
                    }
                }
            });
        }
    }

    private SetupTaskContainer getSetupTaskContainer(EObject object) {
        while (object != null && !(object instanceof SetupTaskContainer)) {
            object = object.eContainer();
        }
        return (SetupTaskContainer)object;
    }
}

