/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.installer;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.ui.ImageURIRegistry;
import org.eclipse.emf.common.ui.dialogs.ResourceDialog;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.DragAndDropCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.provider.DiagnosticDecorator;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.oomph.base.ModelElement;
import org.eclipse.oomph.base.provider.BaseEditUtil;
import org.eclipse.oomph.base.util.BaseResource;
import org.eclipse.oomph.base.util.BaseUtil;
import org.eclipse.oomph.internal.ui.AccessUtil;
import org.eclipse.oomph.jreinfo.JRE;
import org.eclipse.oomph.jreinfo.JREManager;
import org.eclipse.oomph.jreinfo.ui.JREController;
import org.eclipse.oomph.jreinfo.ui.JREInfoUIPlugin;
import org.eclipse.oomph.p2.Requirement;
import org.eclipse.oomph.p2.core.AgentManager;
import org.eclipse.oomph.p2.core.BundlePool;
import org.eclipse.oomph.p2.core.P2Util;
import org.eclipse.oomph.p2.internal.ui.AgentManagerDialog;
import org.eclipse.oomph.p2.internal.ui.P2ContentProvider;
import org.eclipse.oomph.p2.internal.ui.P2LabelProvider;
import org.eclipse.oomph.p2.internal.ui.P2UIPlugin;
import org.eclipse.oomph.setup.CatalogSelection;
import org.eclipse.oomph.setup.Product;
import org.eclipse.oomph.setup.ProductCatalog;
import org.eclipse.oomph.setup.ProductVersion;
import org.eclipse.oomph.setup.Scope;
import org.eclipse.oomph.setup.SetupFactory;
import org.eclipse.oomph.setup.SetupPackage;
import org.eclipse.oomph.setup.SetupTask;
import org.eclipse.oomph.setup.Workspace;
import org.eclipse.oomph.setup.internal.core.SetupContext;
import org.eclipse.oomph.setup.internal.core.util.CatalogManager;
import org.eclipse.oomph.setup.internal.core.util.SetupCoreUtil;
import org.eclipse.oomph.setup.internal.installer.AugmentedJREController;
import org.eclipse.oomph.setup.internal.installer.InstallerUI;
import org.eclipse.oomph.setup.internal.installer.Messages;
import org.eclipse.oomph.setup.internal.installer.SetupInstallerPlugin;
import org.eclipse.oomph.setup.p2.P2Task;
import org.eclipse.oomph.setup.provider.CatalogSelectionItemProvider;
import org.eclipse.oomph.setup.provider.IndexItemProvider;
import org.eclipse.oomph.setup.provider.InstallationItemProvider;
import org.eclipse.oomph.setup.provider.ProductCatalogItemProvider;
import org.eclipse.oomph.setup.provider.ProductItemProvider;
import org.eclipse.oomph.setup.provider.SetupItemProviderAdapterFactory;
import org.eclipse.oomph.setup.ui.JREDownloadHandler;
import org.eclipse.oomph.setup.ui.SetupTransferSupport;
import org.eclipse.oomph.setup.ui.SetupUIPlugin;
import org.eclipse.oomph.setup.ui.wizards.CatalogSelector;
import org.eclipse.oomph.setup.ui.wizards.ConfigurationProcessor;
import org.eclipse.oomph.setup.ui.wizards.MarketPlaceListingProcessor;
import org.eclipse.oomph.setup.ui.wizards.ProjectPage;
import org.eclipse.oomph.setup.ui.wizards.SetupWizard;
import org.eclipse.oomph.setup.ui.wizards.SetupWizardPage;
import org.eclipse.oomph.ui.FilteredTreeWithoutWorkbench;
import org.eclipse.oomph.ui.PersistentButton;
import org.eclipse.oomph.ui.StatusDialog;
import org.eclipse.oomph.ui.ToolButton;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.OS;
import org.eclipse.oomph.util.PropertiesUtil;
import org.eclipse.oomph.util.Request;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.URLTransfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProductPage
extends SetupWizardPage {
    public static final String PAGE_NAME = "ProductPage";
    private static final Product NO_PRODUCT = ProductPage.createNoProduct();
    private static final Pattern RELEASE_LABEL_PATTERN = Pattern.compile(".*\\(([^)]*)\\)[^)]*");
    private static final boolean OS_CHOOSE = PropertiesUtil.isProperty((String)"oomph.setup.os.choose");
    private final SetupWizard.SelectionMemento selectionMemento;
    private ComposedAdapterFactory adapterFactory;
    private CatalogSelector catalogSelector;
    private TreeViewer productViewer;
    private Browser descriptionBrowser;
    private DescriptionViewer descriptionViewer;
    private Label versionLabel;
    private ComboViewer versionComboViewer;
    private ToolButton bitness32Button;
    private ToolButton bitness64Button;
    private JREController javaController;
    private Label javaLabel;
    private ComboViewer javaViewer;
    private ToolButton javaButton;
    private Button poolButton;
    private ComboViewer poolComboViewer;
    private ToolButton managePoolsButton;
    private BundlePool currentBundlePool;
    private boolean currentBundlePoolChanging;
    private ProjectPage.ConfigurationListener configurationListener;
    private SetupTransferSupport.DropListener dropListener;

    public ProductPage(SetupWizard.SelectionMemento selectionMemento) {
        super(PAGE_NAME);
        this.selectionMemento = selectionMemento;
        this.setTitle(Messages.ProductPage_title);
        this.setDescription(Messages.ProductPage_description);
    }

    public void dispose() {
        super.dispose();
        this.adapterFactory.dispose();
    }

    protected Control createUI(Composite parent) {
        this.adapterFactory = new ComposedAdapterFactory((AdapterFactory)this.getAdapterFactory());
        this.adapterFactory.insertAdapterFactory((AdapterFactory)new ItemProviderAdapterFactory());
        BaseEditUtil.replaceReflectiveItemProvider((ComposedAdapterFactory)this.adapterFactory);
        ResourceSet resourceSet = this.getResourceSet();
        AdapterFactoryEditingDomain editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)this.adapterFactory, (CommandStack)new BasicCommandStack(){

            public void execute(Command command) {
                super.execute(command);
                final Collection affectedObjects = command.getAffectedObjects();
                UIUtil.asyncExec((Runnable)new Runnable(){

                    public void run() {
                        ProductPage.this.productViewer.setSelection((ISelection)new StructuredSelection(affectedObjects.toArray()), true);
                    }
                });
            }
        }, resourceSet);
        Composite mainComposite = new Composite(parent, 0);
        mainComposite.setLayout((Layout)UIUtil.createGridLayout((int)1));
        SashForm productSash = this.createProductSash(mainComposite, editingDomain);
        productSash.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite lowerComposite = new Composite(mainComposite, 0);
        lowerComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        lowerComposite.setLayout((Layout)UIUtil.createGridLayout((int)4));
        this.versionLabel = new Label(lowerComposite, 0);
        this.versionLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.versionLabel.setText(Messages.ProductPage_ProductVersion_label);
        AccessUtil.setKey((Widget)this.versionLabel, (Object)"productVersion");
        this.versionComboViewer = new ComboViewer(lowerComposite, 8);
        this.versionComboViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory));
        this.versionComboViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory){

            public Object[] getElements(Object object) {
                return ProductPage.getValidProductVersions((Product)object, null, ProductPage.this.getWizard().getOS()).toArray();
            }
        });
        this.versionComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ProductPage.this.updateProductVersionDetails(false);
            }
        });
        this.versionComboViewer.setInput((Object)NO_PRODUCT);
        final Combo versionCombo = this.versionComboViewer.getCombo();
        versionCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        AccessUtil.setKey((Widget)versionCombo, (Object)"versionChoice");
        if (OS_CHOOSE) {
            ComboViewer osComboViewer = new ComboViewer(lowerComposite, 8);
            osComboViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory));
            osComboViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory){

                public Object[] getElements(Object object) {
                    return OS.INSTANCES.toArray();
                }
            });
            osComboViewer.setInput((Object)OS.INSTANCES);
            for (OS os : OS.INSTANCES) {
                if (!os.isCurrent()) continue;
                osComboViewer.setSelection((ISelection)new StructuredSelection((Object)os));
                break;
            }
            osComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    OS os = (OS)selection.getFirstElement();
                    ProductPage.this.getWizard().setOS(os);
                    ProductPage.this.javaController.setBitness(os.getBitness());
                }
            });
            new Label(lowerComposite, 0);
        } else if (InstallerUI.BITNESS_CHOOSE && JREManager.BITNESS_CHANGEABLE) {
            this.bitness32Button = new ToolButton(lowerComposite, 16, SetupUIPlugin.INSTANCE.getSWTImage("32bit.png"), true);
            this.bitness32Button.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            this.bitness32Button.setSelection(false);
            this.bitness32Button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ProductPage.this.bitness32Button.setSelection(true);
                    ProductPage.this.bitness64Button.setSelection(false);
                    ProductPage.this.javaController.setBitness(32);
                }
            });
            this.bitness64Button = new ToolButton(lowerComposite, 16, SetupUIPlugin.INSTANCE.getSWTImage("64bit.png"), true);
            this.bitness64Button.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            this.bitness64Button.setSelection(true);
            this.bitness64Button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ProductPage.this.bitness32Button.setSelection(false);
                    ProductPage.this.bitness64Button.setSelection(true);
                    ProductPage.this.javaController.setBitness(64);
                }
            });
        } else {
            new Label(lowerComposite, 0);
            new Label(lowerComposite, 0);
        }
        this.javaLabel = new Label(lowerComposite, 131072);
        this.javaLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.javaLabel.setText(Messages.ProductPage_JVM_label);
        this.javaViewer = new ComboViewer(lowerComposite, 8);
        this.javaViewer.getCombo().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.javaViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.javaViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.javaViewer.setInput(Collections.singletonList(new JRE(new File(""), 0, 0, 0, 0, false, 0L)));
        this.javaButton = new ToolButton(lowerComposite, 8, JREInfoUIPlugin.INSTANCE.getSWTImage("jre"), true);
        this.javaButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        this.javaButton.setToolTipText(Messages.ProductPage_ManageVirtualMachanges_message);
        this.javaButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProductPage.this.javaController.configureJREs();
            }
        });
        JREDownloadHandler downloadHandler = new JREDownloadHandler(){

            protected Product getProduct() {
                return ProductPage.this.getSelectedProduct();
            }
        };
        this.javaController = new AugmentedJREController(this.javaLabel, (StructuredViewer)this.javaViewer, (Request.Handler)downloadHandler){

            protected void modelEmpty(boolean empty) {
                super.modelEmpty(empty);
                ProductPage.this.setPageComplete(!empty);
            }

            protected String getArch() {
                OS os = ProductPage.this.getWizard().getOS();
                return os.isMac() ? os.getOsgiArch() : super.getArch();
            }

            protected void jreChanged(JRE jre) {
                SetupWizard wizard = ProductPage.this.getWizard();
                wizard.setVMPath(ProductPage.getVMOption(jre));
                wizard.setOS(wizard.getOS().getForBitness(this.getBitness()));
                this.updateSetupContext(wizard.getSetupContext(), jre);
            }

            protected void setLabel(String text) {
                super.setLabel(String.valueOf(text) + ":");
            }
        };
        if (InstallerUI.SHOW_BUNDLE_POOL_UI) {
            PersistentButton.DialogSettingsPersistence useBundlePool = new PersistentButton.DialogSettingsPersistence(this.getDialogSettings(), "useBundlePool");
            this.poolButton = PersistentButton.create((Composite)lowerComposite, (int)131104, (boolean)true, (PersistentButton.Persistence)useBundlePool);
            AccessUtil.setKey((Widget)this.poolButton, (Object)"pools");
            this.poolButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            this.poolButton.setText(Messages.ProductPage_BundlePool_label);
            if (this.poolButton.getSelection()) {
                this.initBundlePool();
            } else {
                this.setCurrentBundlePool(null);
            }
            this.poolButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (ProductPage.this.poolButton.getSelection()) {
                        IStructuredSelection selection = (IStructuredSelection)ProductPage.this.poolComboViewer.getSelection();
                        BundlePool pool = (BundlePool)selection.getFirstElement();
                        if (pool != null) {
                            ProductPage.this.setCurrentBundlePool(pool);
                        } else {
                            ProductPage.this.initBundlePool();
                        }
                    } else {
                        ProductPage.this.setCurrentBundlePool(null);
                    }
                    ProductPage.this.updateProductDetails(false);
                }
            });
            P2LabelProvider labelProvider = new P2LabelProvider();
            labelProvider.setAbsolutePools(true);
            this.poolComboViewer = new ComboViewer(lowerComposite, 8);
            this.poolComboViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
            this.poolComboViewer.setContentProvider((IContentProvider)new P2ContentProvider.AllBundlePools());
            this.poolComboViewer.setInput((Object)P2Util.getAgentManager());
            this.poolComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection selection;
                    BundlePool pool;
                    if (ProductPage.this.currentBundlePoolChanging) {
                        return;
                    }
                    if (ProductPage.this.poolButton.getSelection() && (pool = (BundlePool)(selection = (IStructuredSelection)ProductPage.this.poolComboViewer.getSelection()).getFirstElement()) != ProductPage.this.currentBundlePool) {
                        ProductPage.this.setCurrentBundlePool(pool);
                        ProductPage.this.updateProductDetails(false);
                    }
                }
            });
            Combo poolCombo = this.poolComboViewer.getCombo();
            poolCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            AccessUtil.setKey((Widget)poolCombo, (Object)"poolChoice");
            this.managePoolsButton = new ToolButton(lowerComposite, 8, P2UIPlugin.INSTANCE.getSWTImage("obj16/bundlePool"), true);
            this.managePoolsButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
            this.managePoolsButton.setToolTipText(Messages.ProductPage_ManageBundlePools_message);
            this.managePoolsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ProductPage.this.manageBundlePools();
                }
            });
            AccessUtil.setKey((Widget)this.managePoolsButton, (Object)"managePools");
        }
        final CatalogManager catalogManager = this.catalogSelector.getCatalogManager();
        this.versionComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ProductVersion version = ProductPage.this.getSelectedProductVersion();
                if (version != null) {
                    String requiredJavaVersion = version.getRequiredJavaVersion();
                    ProductPage.this.javaController.setJavaVersion(requiredJavaVersion);
                    ProductPage.saveProductVersionSelection(catalogManager, version);
                }
                versionCombo.setToolTipText(ProductPage.getToolTipText(version));
            }
        });
        this.updateProductDetails(true);
        return mainComposite;
    }

    private SashForm createProductSash(Composite composite, final AdapterFactoryEditingDomain editingDomain) {
        SashForm sashForm = new SashForm(composite, 66048);
        Composite treeComposite = new Composite((Composite)sashForm, 0);
        treeComposite.setLayout((Layout)UIUtil.createGridLayout((int)1));
        final CatalogManager catalogManager = this.getCatalogManager();
        this.catalogSelector = new CatalogSelector(catalogManager, true);
        Composite filterComposite = new Composite(treeComposite, 0);
        filterComposite.setLayout((Layout)UIUtil.createGridLayout((int)2));
        filterComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Composite filterPlaceholder = new Composite(filterComposite, 0);
        filterPlaceholder.setLayout((Layout)UIUtil.createGridLayout((int)1));
        filterPlaceholder.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ToolBar filterToolBar = new ToolBar(filterComposite, 0x820000);
        final ToolItem addProductButton = new ToolItem(filterToolBar, 0);
        addProductButton.setToolTipText(Messages.ProductPage_AddUserProducts_message);
        addProductButton.setImage(SetupUIPlugin.INSTANCE.getSWTImage("add_project"));
        addProductButton.setEnabled(false);
        AccessUtil.setKey((Widget)addProductButton, (Object)"addProduct");
        final HashSet userProductCatalogs = new HashSet();
        addProductButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddUserProductDialog dialog = new AddUserProductDialog(ProductPage.this.getShell(), userProductCatalogs, ProductPage.this.catalogSelector, editingDomain);
                dialog.open();
            }
        });
        final ToolItem removeProductButton = new ToolItem(filterToolBar, 0);
        removeProductButton.setToolTipText(Messages.ProductPage_RemoveUserProduct_message);
        removeProductButton.setImage(SetupUIPlugin.INSTANCE.getSWTImage("remove_project"));
        removeProductButton.setEnabled(false);
        AccessUtil.setKey((Widget)removeProductButton, (Object)"removeProduct");
        final ArrayList userProducts = new ArrayList();
        SelectionAdapter removeProductSelectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                UniqueEList parents = new UniqueEList();
                for (Product product : userProducts) {
                    ProductCatalog parentProductCatalog = product.getProductCatalog();
                    parentProductCatalog.getProducts().remove((Object)product);
                    parents.add(parentProductCatalog);
                }
                for (ProductCatalog parent : parents) {
                    BaseUtil.saveEObject((EObject)parent);
                }
                ProductPage.this.productViewer.setSelection((ISelection)new StructuredSelection((List)parents));
            }
        };
        removeProductButton.addSelectionListener((SelectionListener)removeProductSelectionAdapter);
        ToolItem collapseAllButton = new ToolItem(filterToolBar, 0);
        collapseAllButton.setToolTipText(Messages.ProductPage_CollapseAll_message);
        collapseAllButton.setImage(SetupUIPlugin.INSTANCE.getSWTImage("collapse-all"));
        AccessUtil.setKey((Widget)collapseAllButton, (Object)"collapse");
        this.configurationListener = new ProjectPage.ConfigurationListener(this.getWizard(), catalogManager, filterToolBar);
        this.getWizard().addConfigurationListener(this.configurationListener);
        ToolItem catalogsButton = new ToolItem(filterToolBar, 4);
        catalogsButton.setToolTipText(Messages.ProductPage_SelectCatalogs_message);
        catalogsButton.setImage(SetupUIPlugin.INSTANCE.getSWTImage("catalogs"));
        this.catalogSelector.configure(this.getWizard(), catalogsButton, true);
        AccessUtil.setKey((Widget)catalogsButton, (Object)"catalogs");
        final FilteredTreeWithoutWorkbench filteredTree = new FilteredTreeWithoutWorkbench(treeComposite, 2048);
        Control filterControl = filteredTree.getChildren()[0];
        filterControl.setParent(filterPlaceholder);
        AccessUtil.setKey((Widget)filteredTree.getFilterControl(), (Object)"filter");
        AccessUtil.setKey((Widget)filteredTree.getViewer().getTree(), (Object)"productTree");
        this.addHelpCallout((Control)filteredTree.getViewer().getTree(), 1);
        this.productViewer = filteredTree.getViewer();
        this.productViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory));
        this.productViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory){
            private final AtomicBoolean selectionMementoTried;
            {
                super($anonymous0);
                this.selectionMementoTried = new AtomicBoolean();
            }

            private boolean applySelectionMemento() {
                ResourceSet resourceSet;
                EObject object;
                URI uri = ProductPage.this.selectionMemento.getProductVersion();
                if (uri != null && (object = (resourceSet = ProductPage.this.getResourceSet()).getEObject(uri, true)) instanceof ProductVersion) {
                    ProductVersion productVersion = (ProductVersion)object;
                    Product product = productVersion.getProduct();
                    ProductPage.this.productViewer.expandToLevel((Object)product, 1);
                    ProductPage.this.productViewer.setSelection((ISelection)new StructuredSelection((Object)product));
                    ProductPage.this.versionComboViewer.setSelection((ISelection)new StructuredSelection((Object)productVersion));
                    ProductPage.this.updateProductDetails(false);
                    ProductPage.this.gotoNextPage();
                    return true;
                }
                return false;
            }

            public void notifyChanged(Notification notification) {
                super.notifyChanged(notification);
                if (notification.getFeature() == SetupPackage.Literals.CATALOG_SELECTION__PRODUCT_CATALOGS) {
                    ProductPage.this.getShell().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            Object[] elements;
                            if (!selectionMementoTried.getAndSet(true) && this.applySelectionMemento()) {
                                return;
                            }
                            if (ProductPage.this.productViewer.getExpandedElements().length == 0 && (elements = this.getElements(ProductPage.this.productViewer.getInput())).length > 0) {
                                EMap defaultProductVersions;
                                ProductPage.this.productViewer.expandToLevel(elements[0], 1);
                                if (ProductPage.this.productViewer.getSelection().isEmpty() && !(defaultProductVersions = catalogManager.getSelection().getDefaultProductVersions()).isEmpty()) {
                                    Product defaultProduct = (Product)((Map.Entry)defaultProductVersions.get(0)).getKey();
                                    ProductPage.this.productViewer.setSelection((ISelection)new StructuredSelection((Object)defaultProduct), true);
                                    return;
                                }
                                ProductPage.this.productViewer.setSelection((ISelection)new StructuredSelection(elements[0]));
                                ProductPage.this.setErrorMessage(null);
                            }
                        }
                    });
                }
            }
        });
        int dndOperations = 7;
        Transfer[] transfers = new Transfer[]{LocalTransfer.getInstance(), LocalSelectionTransfer.getTransfer(), FileTransfer.getInstance(), URLTransfer.getInstance()};
        this.productViewer.addDropSupport(dndOperations, transfers, (DropTargetListener)new ProjectPage.URIDropAdapter((EditingDomain)editingDomain, (Viewer)this.productViewer));
        Tree productTree = this.productViewer.getTree();
        productTree.setLayoutData((Object)new GridData(1808));
        Composite descriptionComposite = new Composite((Composite)sashForm, 2048);
        descriptionComposite.setLayout((Layout)new FillLayout());
        if (UIUtil.isBrowserAvailable()) {
            this.descriptionBrowser = new Browser(descriptionComposite, 0);
            this.descriptionBrowser.addLocationListener((LocationListener)new LocationAdapter(){

                public void changing(LocationEvent event) {
                    if (!"about:blank".equals(event.location)) {
                        OS.INSTANCE.openSystemBrowser(event.location);
                        event.doit = false;
                    }
                }
            });
            AccessUtil.setKey((Widget)this.descriptionBrowser, (Object)"description");
        } else {
            descriptionComposite.setForeground(productTree.getForeground());
            descriptionComposite.setBackground(productTree.getBackground());
            this.descriptionViewer = new DescriptionViewer(descriptionComposite, productTree.getFont());
        }
        sashForm.setWeights(new int[]{14, 5});
        CatalogSelection selection = catalogManager.getSelection();
        this.productViewer.setInput((Object)selection);
        collapseAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProductPage.this.productViewer.collapseAll();
            }
        });
        this.productViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)ProductPage.this.productViewer.getSelection();
                Object element = selection.getFirstElement();
                if (element instanceof Product) {
                    if (ProductPage.this.isPageComplete()) {
                        ProductPage.this.gotoNextPage();
                    }
                    return;
                }
                boolean expanded = ProductPage.this.productViewer.getExpandedState(element);
                ProductPage.this.productViewer.setExpandedState(element, !expanded);
            }
        });
        this.productViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                userProductCatalogs.clear();
                userProducts.clear();
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ProductCatalog productCatalog;
                    Object value = objectArray[n2];
                    if (value instanceof Product) {
                        Product product = (Product)value;
                        ProductCatalog productCatalog2 = product.getProductCatalog();
                        if (ConfigurationProcessor.isUserProductCatalog((Scope)productCatalog2)) {
                            userProductCatalogs.add(productCatalog2);
                            userProducts.add(product);
                        }
                    } else if (value instanceof ProductCatalog && ConfigurationProcessor.isUserProductCatalog((Scope)(productCatalog = (ProductCatalog)value))) {
                        userProductCatalogs.add(productCatalog);
                    }
                    ++n2;
                }
                removeProductButton.setEnabled(!userProducts.isEmpty());
                boolean hasUserProductCatalogs = false;
                for (Scope scope : ProductPage.this.catalogSelector.getCatalogs()) {
                    if (!ConfigurationProcessor.isUserProductCatalog((Scope)scope)) continue;
                    hasUserProductCatalogs = true;
                    break;
                }
                addProductButton.setEnabled(hasUserProductCatalogs);
                ProductPage.this.updateProductDetails(false);
            }
        });
        this.dropListener = new SetupTransferSupport.DropListener(){

            public void resourcesDropped(Collection<? extends Resource> resources) {
                SetupWizard setupWizard = ProductPage.this.getWizard();
                setupWizard.setConfigurationResources(resources);
                MarketPlaceListingProcessor marketPlaceListingProcessor = new MarketPlaceListingProcessor(setupWizard);
                if (marketPlaceListingProcessor.isMarketPlaceListing()) {
                    marketPlaceListingProcessor.processMarketPlaceListing();
                    IStatus status = marketPlaceListingProcessor.getStatus();
                    if (!status.isOK()) {
                        new StatusDialog(ProductPage.this.getShell(), Messages.ProductPage_MPCProblems_title, null, status, 4).open();
                    }
                    return;
                }
                ConfigurationProcessor configurationProcessor = new ConfigurationProcessor(ProductPage.this.getWizard()){

                    protected boolean applyEmptyProductVersion() {
                        this.applyInstallation();
                        ProductPage.this.updateSetupContext();
                        return true;
                    }

                    protected boolean applyProductVersion(ProductVersion productVersion) {
                        this.applyInstallation();
                        while (ProductPage.this.getShell().getDisplay().readAndDispatch()) {
                        }
                        filteredTree.clearText();
                        ProductPage.this.productViewer.setSelection((ISelection)new StructuredSelection((Object)productVersion.getProduct()), true);
                        ProductPage.this.versionComboViewer.setSelection((ISelection)new StructuredSelection((Object)productVersion), true);
                        while (ProductPage.this.getShell().getDisplay().readAndDispatch()) {
                        }
                        if (ProductPage.this.isCurrentPage() && ProductPage.this.isPageComplete()) {
                            ProductPage.this.gotoNextPage();
                        } else {
                            ProductPage.this.updateSetupContext();
                        }
                        return true;
                    }
                };
                configurationProcessor.processInstallation();
                IStatus status = configurationProcessor.getStatus();
                if (!status.isOK()) {
                    new StatusDialog(ProductPage.this.getShell(), Messages.ProductPage_InstallatinProblems_title, null, status, 4).open();
                }
            }
        };
        this.getWizard().getTransferSupport().addDropListener(this.dropListener);
        return sashForm;
    }

    public void enterPage(boolean forward) {
        this.getWizard().setSetupContext(SetupContext.create((ResourceSet)this.getResourceSet(), null));
        final Collection configurationResources = this.getWizard().getConfigurationResources();
        final SetupTransferSupport transferSupport = this.getWizard().getTransferSupport();
        ProjectPage.hookTransferControl((Shell)this.getShell(), (Control)this.getControl(), (SetupTransferSupport)transferSupport, (ProjectPage.ConfigurationListener)this.configurationListener);
        if (forward && !configurationResources.isEmpty()) {
            UIUtil.asyncExec((Control)this.getShell(), (Runnable)new Runnable(){
                private int count;

                public void run() {
                    SetupWizard.IndexLoader indexLoader = ProductPage.this.getWizard().getIndexLoader();
                    if (indexLoader != null) {
                        indexLoader.awaitIndexLoad();
                    }
                    if (++this.count < 10) {
                        UIUtil.asyncExec((Control)ProductPage.this.getShell(), (Runnable)this);
                    } else {
                        transferSupport.resourcesDropped(configurationResources);
                    }
                }
            });
        }
    }

    public void leavePage(boolean forward) {
        ProjectPage.unhookTransferControl((Shell)this.getShell(), (Control)this.getControl(), (SetupTransferSupport)this.getWizard().getTransferSupport(), (ProjectPage.ConfigurationListener)this.configurationListener);
        if (forward) {
            this.updateSetupContext();
        }
    }

    private void updateSetupContext() {
        ProductVersion productVersion = this.getSelectedProductVersion();
        if (productVersion != null) {
            this.selectionMemento.setProductVersion(EcoreUtil.getURI((EObject)productVersion));
            this.getWizard().setSetupContext(SetupContext.create((ResourceSet)this.getResourceSet(), (ProductVersion)productVersion));
        }
    }

    public boolean refreshJREs() {
        if (this.javaController != null) {
            this.javaController.refresh();
            return true;
        }
        return false;
    }

    public void sendStats(boolean success) {
        Workspace workspace;
        super.sendStats(success);
        SetupContext setupContext = this.getWizard().getSetupContext();
        if (!success && (workspace = setupContext.getWorkspace()) != null && !workspace.getStreams().isEmpty()) {
            return;
        }
        ProductVersion productVersion = setupContext.getInstallation().getProductVersion();
        OS os = this.getPerformer().getOS();
        SetupCoreUtil.sendStats((boolean)success, (Scope)productVersion, (OS)os);
    }

    private void updateProductDetails(boolean initial) {
        ProductVersion version;
        Product product = this.getSelectedProduct();
        if (product == null) {
            product = NO_PRODUCT;
        }
        boolean productSelected = product != NO_PRODUCT;
        this.versionComboViewer.setInput((Object)product);
        if (productSelected && (version = ProductPage.getDefaultProductVersion(this.catalogSelector.getCatalogManager(), product, this.getWizard().getOS())) != null) {
            this.versionComboViewer.setSelection((ISelection)new StructuredSelection((Object)version));
            return;
        }
        this.updateProductVersionDetails(initial);
    }

    private void updateProductVersionDetails(boolean initial) {
        Product scope;
        boolean productSelected;
        Product product;
        ProductVersion productVersion = this.getSelectedProductVersion();
        Product product2 = product = productVersion == null ? this.getSelectedProduct() : productVersion.getProduct();
        if (product == null) {
            product = NO_PRODUCT;
        }
        boolean bl = productSelected = product != NO_PRODUCT;
        String error = productSelected ? (productVersion == null ? Messages.ProductPage_IncompatibleVersion_message : null) : Messages.ProductPage_Select_message;
        Object object = scope = productSelected ? product : this.getSelectedProductCatalog();
        if (this.descriptionBrowser != null) {
            String html = ProductPage.safe(this.getDescriptionHTML((Scope)(productVersion != null ? productVersion : scope)));
            this.descriptionBrowser.setEnabled(scope != null);
            this.descriptionBrowser.setText(html);
        } else {
            String productVersionLabel;
            String html = ProductPage.safe(scope == null ? null : scope.getDescription());
            URI brandingSiteURI = SetupWizard.getBrandingSiteURI((Scope)(productVersion == null ? product : productVersion));
            String plain = StringUtil.isEmpty((String)html) ? Messages.ProductPage_NoDescription_message : UIUtil.stripHTML((String)html);
            String label = SetupCoreUtil.getLabel((Scope)scope);
            if (productVersion != null && !StringUtil.isEmpty((String)(productVersionLabel = this.getLabel(productVersion)))) {
                label = String.valueOf(label) + " \u2013 " + productVersionLabel;
            }
            this.descriptionViewer.update(SetupWizard.getBrandingImage((Scope)product), label, productVersion != null && "true".equals(BaseUtil.getAnnotation((ModelElement)productVersion, (String)"http://www.eclipse.org/oomph/setup/BrandingInfo", (String)"incubating")), plain, brandingSiteURI == null ? null : brandingSiteURI.toString());
        }
        this.versionLabel.setEnabled(productSelected);
        this.versionComboViewer.getControl().setEnabled(productSelected);
        if (InstallerUI.BITNESS_CHOOSE && JREManager.BITNESS_CHANGEABLE && !OS_CHOOSE) {
            this.bitness32Button.setEnabled(productSelected);
            this.bitness64Button.setEnabled(productSelected);
        }
        this.javaLabel.setEnabled(productSelected);
        this.javaViewer.getControl().setEnabled(productSelected);
        this.javaButton.setEnabled(productSelected);
        if (this.poolButton != null) {
            this.currentBundlePoolChanging = true;
            if (this.currentBundlePool != null) {
                this.poolComboViewer.setSelection((ISelection)new StructuredSelection((Object)this.currentBundlePool));
            } else {
                if (error == null && productSelected && this.poolButton.getSelection()) {
                    error = Messages.ProductPage_SelectBundlePool_message;
                }
                this.poolComboViewer.setSelection((ISelection)StructuredSelection.EMPTY);
            }
            this.currentBundlePoolChanging = false;
        }
        if (!initial) {
            this.setErrorMessage(error);
            this.setPageComplete(error == null);
        }
    }

    private String getDescriptionHTML(Scope scope) {
        if (scope == null) {
            return null;
        }
        String imageURI = SetupWizard.getLocalBrandingImageURI((Scope)scope);
        Scope effectiveScope = scope instanceof ProductVersion ? scope.getParentScope() : scope;
        String description = effectiveScope.getDescription();
        String label = effectiveScope.getLabel();
        if (StringUtil.isEmpty((String)label)) {
            label = effectiveScope.getName();
        }
        String versionLabel = null;
        if (!StringUtil.isEmpty((String)label) && scope instanceof ProductVersion) {
            versionLabel = this.getLabel((ProductVersion)scope);
        }
        URI brandingSiteURI = SetupWizard.getBrandingSiteURI((Scope)scope);
        StringBuilder result = new StringBuilder();
        result.append("<html><body style='margin:5px;'>");
        if (brandingSiteURI != null) {
            result.append("<a style='text-decoration: none; color: inherit;' href='");
            result.append(brandingSiteURI);
            result.append("'>");
        }
        result.append("<img src='");
        result.append(imageURI);
        result.append("' width='42' height='42' align='absmiddle'></img>");
        result.append("<span><b>&nbsp;&nbsp;&nbsp;<span style='font-family:Arial,Verdana,sans-serif; font-size:100%'>");
        result.append(DiagnosticDecorator.escapeContent((String)ProductPage.safe(label)));
        if (!StringUtil.isEmpty((String)versionLabel)) {
            result.append(" &ndash; ");
            result.append(DiagnosticDecorator.escapeContent((String)versionLabel));
        }
        if ("true".equals(BaseUtil.getAnnotation((ModelElement)scope, (String)"http://www.eclipse.org/oomph/setup/BrandingInfo", (String)"incubating"))) {
            URI incubationURI = ImageURIRegistry.INSTANCE.getImageURI(ExtendedImageRegistry.INSTANCE.getImage((Object)SetupInstallerPlugin.INSTANCE.getSWTImage("simple/eclipse_incubation.png")));
            result.append("&nbsp;<img title='Contains incubating components' style='height: 2ex;' src='");
            result.append(incubationURI);
            result.append("' align='absmiddle'></img>");
        }
        if (brandingSiteURI != null) {
            result.append("</a>");
        }
        result.append("</b>");
        if (brandingSiteURI != null && !StringUtil.isEmpty((String)versionLabel)) {
            result.append("<a style='float: right; padding-top: 12px; padding-right: 15px; font-family:Arial,Verdana,sans-serif; font-size:75%' href='");
            result.append(brandingSiteURI);
            result.append("'>");
            result.append("details");
            result.append("</a>");
        }
        result.append("</span>");
        result.append("<br/><hr/></span><span style='font-family:Arial,Verdana,sans-serif; font-size:75%'>");
        result.append(ProductPage.safe(description));
        result.append("</span></body></html>");
        return result.toString();
    }

    private String getLabel(ProductVersion productVersion) {
        String label = productVersion.getLabel();
        if (StringUtil.isEmpty((String)label)) {
            label = productVersion.getName();
        } else {
            int end;
            int start = label.indexOf(40);
            if (start != -1 && (end = label.indexOf(41, start)) != -1) {
                label = label.substring(start + 1, end);
            }
        }
        return label;
    }

    private void setCurrentBundlePool(BundlePool pool) {
        if (pool != null) {
            P2Util.getAgentManager().setDefaultBundlePool(SetupUIPlugin.INSTANCE.getSymbolicName(), pool);
            System.setProperty("oomph.p2.pool", pool.getLocation().getAbsolutePath());
        } else {
            System.setProperty("oomph.p2.pool", "@none");
        }
        this.currentBundlePool = pool;
    }

    private void initBundlePool() {
        String client = SetupUIPlugin.INSTANCE.getSymbolicName();
        AgentManager agentManager = P2Util.getAgentManager();
        BundlePool pool = agentManager.getDefaultBundlePool(client);
        this.setCurrentBundlePool(pool);
    }

    private void manageBundlePools() {
        AgentManagerDialog dialog = new AgentManagerDialog(this.getShell()){

            protected void createButtonsForButtonBar(Composite parent) {
                super.createButtonsForButtonBar(parent);
                Button button = this.getButton(0);
                if (button != null) {
                    button.setEnabled(false);
                }
            }

            protected void elementChanged(Object element) {
                Button button = this.getButton(0);
                if (button != null) {
                    button.setEnabled(this.getSelectedBundlePool() != null);
                }
            }
        };
        IStructuredSelection selection = (IStructuredSelection)this.poolComboViewer.getSelection();
        BundlePool pool = (BundlePool)selection.getFirstElement();
        if (pool != null) {
            dialog.setSelectedPool(pool);
        }
        int result = dialog.open();
        this.poolComboViewer.refresh();
        if (result == 0) {
            pool = dialog.getSelectedBundlePool();
            this.poolComboViewer.setSelection((ISelection)(pool == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)pool)));
            if (pool != null) {
                this.poolButton.setSelection(true);
            }
        }
    }

    private ProductCatalog getSelectedProductCatalog() {
        IStructuredSelection selection = (IStructuredSelection)this.productViewer.getSelection();
        Object element = selection.getFirstElement();
        if (element instanceof ProductCatalog) {
            return (ProductCatalog)element;
        }
        return null;
    }

    private Product getSelectedProduct() {
        IStructuredSelection selection = (IStructuredSelection)this.productViewer.getSelection();
        Object element = selection.getFirstElement();
        if (element instanceof Product) {
            return (Product)element;
        }
        return null;
    }

    private ProductVersion getSelectedProductVersion() {
        IStructuredSelection selection = (IStructuredSelection)this.versionComboViewer.getSelection();
        Object element = selection.getFirstElement();
        if (element instanceof ProductVersion) {
            return (ProductVersion)element;
        }
        return null;
    }

    public static ProductVersion getDefaultProductVersion(CatalogManager catalogManager, Product product) {
        return ProductPage.getDefaultProductVersion(catalogManager, product, OS.INSTANCE);
    }

    public static ProductVersion getDefaultProductVersion(CatalogManager catalogManager, Product product, OS os) {
        ProductVersion version = (ProductVersion)catalogManager.getSelection().getDefaultProductVersions().get((Object)product);
        List<ProductVersion> validProductVersions = ProductPage.getValidProductVersions(product, null, os);
        if (!validProductVersions.contains(version)) {
            ProductVersion firstReleasedProductVersion = null;
            ProductVersion latestProductVersion = null;
            ProductVersion latestReleasedProductVersion = null;
            for (ProductVersion productVersion : validProductVersions) {
                String versionName = productVersion.getName();
                if ("latest.released".equals(versionName)) {
                    latestReleasedProductVersion = productVersion;
                    continue;
                }
                if ("latest".equals(versionName)) {
                    latestProductVersion = productVersion;
                    continue;
                }
                if (firstReleasedProductVersion != null) continue;
                firstReleasedProductVersion = productVersion;
            }
            version = latestReleasedProductVersion != null ? (latestReleasedProductVersion.getLabel().contains("(Luna)") && latestProductVersion != null && latestProductVersion.getLabel().contains("(Mars") ? latestProductVersion : latestReleasedProductVersion) : (firstReleasedProductVersion != null ? firstReleasedProductVersion : latestProductVersion);
            if (version != null) {
                ProductPage.saveProductVersionSelection(catalogManager, version);
            }
        }
        return version;
    }

    public static String getToolTipText(ProductVersion version) {
        if (version == null) {
            return null;
        }
        String label = SetupCoreUtil.getLabel((Scope)version);
        Matcher matcher = RELEASE_LABEL_PATTERN.matcher(label);
        if (matcher.matches()) {
            String sublabel = matcher.group(1);
            for (ProductVersion otherVersion : version.getProduct().getVersions()) {
                String otherVersionLabel = SetupCoreUtil.getLabel((Scope)otherVersion);
                if (!sublabel.equals(otherVersionLabel)) continue;
                label = sublabel;
                break;
            }
        }
        String result = NLS.bind((String)Messages.ProductPage_InstallVersion_message, (Object)label);
        String name = version.getName();
        result = "latest.released".equals(name) ? String.valueOf(result) + Messages.ProductPage_UpdateRelease_message : ("latest".equals(name) ? String.valueOf(result) + Messages.ProductPage_Update_message : String.valueOf(result) + Messages.ProductPage_UpdateServiceRelease_message);
        return result;
    }

    public static void saveProductVersionSelection(CatalogManager catalogManager, ProductVersion version) {
        EMap defaultProductVersions = catalogManager.getSelection().getDefaultProductVersions();
        Product product = version.getProduct();
        defaultProductVersions.put((Object)product, (Object)version);
        defaultProductVersions.move(0, defaultProductVersions.indexOfKey((Object)product));
        catalogManager.saveSelection();
    }

    private static Product createNoProduct() {
        Product product = SetupFactory.eINSTANCE.createProduct();
        product.setName(Messages.ProductPage_NoProductSelected_label);
        product.setLabel(product.getName());
        ProductVersion version = SetupFactory.eINSTANCE.createProductVersion();
        version.setName(Messages.ProductPage_NoProductVersionSelected_label);
        version.setLabel(version.getName());
        product.getVersions().add((Object)version);
        return product;
    }

    private static String safe(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }

    public static String getVMOption(JRE jre) {
        if (jre == null || jre.equals((Object)JREManager.INSTANCE.getSystemJRE())) {
            return null;
        }
        File javaHome = jre.getJavaHome();
        if (javaHome == null) {
            return null;
        }
        return new File(javaHome, "bin").toString();
    }

    public static List<ProductVersion> getValidProductVersions(Product product, Pattern filter) {
        return ProductPage.getValidProductVersions(product, filter, OS.INSTANCE);
    }

    public static List<ProductVersion> getValidProductVersions(Product product, Pattern filter, OS os) {
        ProductVersion version;
        Iterator it;
        ArrayList<ProductVersion> versions = new ArrayList<ProductVersion>((Collection<ProductVersion>)product.getVersions());
        if (OS.INSTANCE.isMac()) {
            it = versions.iterator();
            while (it.hasNext()) {
                version = (ProductVersion)it.next();
                String label = version.getLabel();
                if (label == null || !label.contains("Luna") && !label.contains("Kepler") && !label.contains("Juno")) continue;
                it.remove();
            }
        }
        if (filter != null && !StringUtil.isEmpty((String)filter.pattern())) {
            it = versions.iterator();
            while (it.hasNext()) {
                version = (ProductVersion)it.next();
                String name = version.getQualifiedName();
                if (name != null && filter.matcher(name).matches()) continue;
                it.remove();
            }
        }
        if (os != null) {
            it = versions.iterator();
            block2: while (it.hasNext()) {
                version = (ProductVersion)it.next();
                for (SetupTask setupTask : version.getSetupTasks()) {
                    if (!(setupTask instanceof P2Task)) continue;
                    P2Task p2Task = (P2Task)setupTask;
                    for (Requirement requirement : p2Task.getRequirements()) {
                        String requirementFilter;
                        if (requirement.isOptional() || (requirementFilter = requirement.getFilter()) == null || !requirementFilter.contains("osgi.arch=") || SetupWizard.matchesFilterContext((String)requirementFilter, (OS)os)) continue;
                        it.remove();
                        continue block2;
                    }
                }
            }
        }
        return versions;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class AddUserProductDialog
    extends ResourceDialog {
        private final Set<ProductCatalog> productCatalogs;
        private CatalogSelector catalogSelector;
        private final AdapterFactoryEditingDomain editingDomain;
        private ComboViewer catalogViewer;

        public AddUserProductDialog(Shell parent, Set<ProductCatalog> productCatalog, CatalogSelector catalogSelector, AdapterFactoryEditingDomain editingDomain) {
            super(parent, Messages.ProductPage_AddUserProducts_title, 4098);
            this.productCatalogs = productCatalog;
            this.catalogSelector = catalogSelector;
            this.editingDomain = editingDomain;
        }

        protected Control createDialogArea(Composite parent) {
            Composite main = new Composite(parent, 0);
            main.setLayout((Layout)UIUtil.createGridLayout((int)1));
            main.setLayoutData((Object)new GridData(1808));
            Composite upperComposite = new Composite(main, 0);
            GridLayout upperLayout = new GridLayout(2, false);
            upperLayout.marginTop = 10;
            upperLayout.marginWidth = 10;
            upperComposite.setLayout((Layout)upperLayout);
            upperComposite.setLayoutData((Object)new GridData(1808));
            AddUserProductDialog.applyDialogFont((Control)upperComposite);
            Label label = new Label(upperComposite, 0);
            label.setText(Messages.ProductPage_Catalog_label);
            label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            this.catalogViewer = new ComboViewer(upperComposite, 8);
            this.catalogViewer.getCombo().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.catalogViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            this.catalogViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    return SetupCoreUtil.getLabel((Scope)((Scope)element));
                }
            });
            ArrayList catalogs = new ArrayList(this.catalogSelector.getCatalogs());
            Iterator it = catalogs.iterator();
            while (it.hasNext()) {
                if (ConfigurationProcessor.isUserProductCatalog((Scope)((Scope)it.next()))) continue;
                it.remove();
            }
            this.catalogViewer.setInput(catalogs);
            if (catalogs.size() == 1) {
                this.catalogViewer.setSelection((ISelection)new StructuredSelection(catalogs.get(0)));
            } else if (this.productCatalogs.size() == 1 && catalogs.containsAll(this.productCatalogs)) {
                this.catalogViewer.setSelection((ISelection)new StructuredSelection((Object)this.productCatalogs.iterator().next()));
            }
            this.catalogViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    AddUserProductDialog.this.validate();
                }
            });
            Composite lowerComposite = new Composite(main, 0);
            GridLayout lowerLayout = new GridLayout();
            lowerLayout.marginHeight = 0;
            lowerLayout.marginWidth = 0;
            lowerLayout.verticalSpacing = 0;
            lowerComposite.setLayout((Layout)lowerLayout);
            lowerComposite.setLayoutData((Object)new GridData(1808));
            AddUserProductDialog.applyDialogFont((Control)lowerComposite);
            parent.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    AddUserProductDialog.this.validate();
                }
            });
            return super.createDialogArea(lowerComposite);
        }

        protected void prepareBrowseFileSystemButton(Button browseFileSystemButton) {
            browseFileSystemButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    FileDialog fileDialog = new FileDialog(AddUserProductDialog.this.getShell(), AddUserProductDialog.this.style);
                    fileDialog.setFilterExtensions(new String[]{"*.setup"});
                    fileDialog.open();
                    String filterPath = fileDialog.getFilterPath();
                    String[] fileNames = fileDialog.getFileNames();
                    StringBuffer uris = new StringBuffer();
                    int i = 0;
                    int len = fileNames.length;
                    while (i < len) {
                        uris.append(URI.createFileURI((String)(String.valueOf(filterPath) + File.separator + fileNames[i])).toString());
                        uris.append("  ");
                        ++i;
                    }
                    AddUserProductDialog.this.uriField.setText((String.valueOf(AddUserProductDialog.this.uriField.getText()) + "  " + uris.toString()).trim());
                }
            });
        }

        protected void validate() {
            Button button = this.getButton(0);
            if (button != null) {
                button.setEnabled(this.getSelectedCatalog() != null);
            }
        }

        protected boolean processResources() {
            int invalidProductsSize;
            ArrayList<Product> validProducts = new ArrayList<Product>();
            ArrayList<Product> invalidProducts = new ArrayList<Product>();
            ArrayList<URI> invalidURIs = new ArrayList<URI>();
            ResourceSet resourceSet = this.editingDomain.getResourceSet();
            for (URI uri : this.getURIs()) {
                BaseResource resource = BaseUtil.loadResourceSafely((ResourceSet)resourceSet, (URI)uri);
                Product product = (Product)EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)SetupPackage.Literals.PRODUCT);
                if (product == null) {
                    invalidURIs.add(uri);
                    continue;
                }
                if (product.eContainer() != null) {
                    invalidProducts.add(product);
                    continue;
                }
                validProducts.add(product);
            }
            if (!validProducts.isEmpty()) {
                ProductCatalog selectedCatalog = this.getSelectedCatalog();
                if (!this.catalogSelector.getSelectedCatalogs().contains(selectedCatalog)) {
                    this.catalogSelector.select((Scope)selectedCatalog, true);
                }
                Command command = DragAndDropCommand.create((EditingDomain)this.editingDomain, (Object)selectedCatalog, (float)0.5f, (int)4, (int)4, validProducts);
                this.editingDomain.getCommandStack().execute(command);
                return true;
            }
            StringBuilder message = new StringBuilder();
            int invalidURIsSize = invalidURIs.size();
            if (invalidURIsSize != 0) {
                if (invalidURIsSize == 1) {
                    message.append(Messages.ProductPage_URIPrefix_message);
                } else {
                    message.append(Messages.ProductPage_URIsPrefix_message);
                }
                int i = 0;
                while (i < invalidURIsSize) {
                    if (i != 0) {
                        message.append(", ");
                        if (i + 1 == invalidURIsSize) {
                            message.append(Messages.ProductPage_And_message);
                        }
                    }
                    message.append('\'');
                    message.append(invalidURIs.get(i));
                    message.append('\'');
                    ++i;
                }
                if (invalidURIsSize == 1) {
                    message.append(Messages.ProductPage_InvalidProduct_message);
                } else {
                    message.append(Messages.ProductPage_InvalidProducts_message);
                }
            }
            if ((invalidProductsSize = invalidProducts.size()) != 0) {
                if (message.length() != 0) {
                    message.append("\n\n");
                }
                if (invalidProductsSize == 1) {
                    message.append(Messages.ProductPage_Product_message);
                } else {
                    message.append(Messages.ProductPage_Products_message);
                }
                int i = 0;
                while (i < invalidProductsSize) {
                    if (i != 0) {
                        message.append(", ");
                        if (i + 1 == invalidProductsSize) {
                            message.append(Messages.ProductPage_And_message);
                        }
                    }
                    message.append('\'');
                    message.append(((Product)invalidProducts.get(i)).getLabel());
                    message.append('\'');
                    ++i;
                }
                if (invalidProductsSize == 1) {
                    message.append(Messages.ProductPage_AlreadyContained_message);
                } else {
                    message.append(Messages.ProductPage_AlreadyContainedPlural_message);
                }
            }
            if (message.length() == 0) {
                message.append(Messages.ProductPage_NoURIsSpecified_message);
            }
            ErrorDialog.openError((Shell)this.getShell(), (String)Messages.ProductPage_ErrorAdding_title, null, (IStatus)new Status(4, SetupUIPlugin.INSTANCE.getSymbolicName(), message.toString()));
            return false;
        }

        private ProductCatalog getSelectedCatalog() {
            IStructuredSelection selection = (IStructuredSelection)this.catalogViewer.getSelection();
            ProductCatalog selectedCatalog = (ProductCatalog)selection.getFirstElement();
            return selectedCatalog;
        }
    }

    private static class DescriptionViewer {
        private ScrolledComposite scrolledComposite;
        private Composite descriptionComposite;
        private CLabel descriptionLabel;
        private Link detailsLink;
        private String detailsLocation;
        private Text descriptionText;
        private ControlAdapter resizeListener;
        private CLabel descriptionLabelImage;

        public DescriptionViewer(Composite container, Font font) {
            Color foreground = container.getForeground();
            Color background = container.getBackground();
            this.scrolledComposite = new ScrolledComposite(container, 512);
            this.scrolledComposite.setExpandHorizontal(true);
            this.scrolledComposite.setExpandVertical(true);
            this.resizeListener = new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    Point size = DescriptionViewer.this.descriptionComposite.computeSize(((DescriptionViewer)DescriptionViewer.this).scrolledComposite.getClientArea().width, -1);
                    DescriptionViewer.this.scrolledComposite.setMinSize(size);
                }
            };
            this.scrolledComposite.addControlListener((ControlListener)this.resizeListener);
            this.descriptionComposite = new Composite((Composite)this.scrolledComposite, 0);
            this.descriptionComposite.setLayout((Layout)new GridLayout());
            this.descriptionComposite.setForeground(foreground);
            this.descriptionComposite.setBackground(background);
            this.scrolledComposite.setContent((Control)this.descriptionComposite);
            Composite labelComposite = new Composite(this.descriptionComposite, 0);
            GridLayout labelCompositeLayout = new GridLayout(3, false);
            labelCompositeLayout.marginHeight = 0;
            labelCompositeLayout.marginWidth = 0;
            labelCompositeLayout.marginRight = 12;
            labelComposite.setLayout((Layout)labelCompositeLayout);
            labelComposite.setLayoutData((Object)new GridData(4, 4, true, true));
            labelComposite.setForeground(foreground);
            labelComposite.setBackground(background);
            this.descriptionLabel = new CLabel(labelComposite, 0);
            this.descriptionLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            this.descriptionLabel.setForeground(foreground);
            this.descriptionLabel.setBackground(background);
            this.descriptionLabel.setFont(SetupUIPlugin.getFont((Font)font, (Object)URI.createURI((String)"font:///+2/bold")));
            this.descriptionLabelImage = new CLabel(labelComposite, 0);
            this.descriptionLabelImage.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.descriptionLabelImage.setForeground(foreground);
            this.descriptionLabelImage.setBackground(background);
            this.descriptionLabelImage.setFont(SetupUIPlugin.getFont((Font)font, (Object)URI.createURI((String)"font:///+2/bold")));
            this.descriptionLabelImage.setImage(SetupInstallerPlugin.INSTANCE.getSWTImage("simple/eclipse_incubation.png"));
            this.descriptionLabelImage.setToolTipText(Messages.ProductPage_Incubating_message);
            this.detailsLink = new Link(labelComposite, 0);
            this.detailsLink.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
            this.detailsLink.setText("<a>details</a>");
            this.detailsLink.setBackground(background);
            this.detailsLink.setToolTipText(Messages.ProductPage_OpenDescription_message);
            this.detailsLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    OS.INSTANCE.openSystemBrowser(DescriptionViewer.this.detailsLocation);
                }
            });
            Label separator = new Label(this.descriptionComposite, 258);
            separator.setLayoutData((Object)new GridData(768));
            this.descriptionText = new Text(this.descriptionComposite, 72);
            this.descriptionText.setLayoutData((Object)new GridData(1808));
            this.descriptionText.setForeground(foreground);
            this.descriptionText.setBackground(background);
        }

        public void update(Image image, String title, boolean incubating, String body, String details) {
            this.descriptionLabel.setImage(image);
            this.descriptionLabel.setText(title);
            this.descriptionLabelImage.setVisible(incubating);
            this.descriptionText.setText(body);
            if (details == null) {
                this.detailsLink.setVisible(false);
                this.detailsLocation = null;
            } else {
                this.detailsLink.setVisible(true);
                this.detailsLocation = details;
            }
            this.descriptionLabel.getParent().layout(true);
            this.resizeListener.controlResized(null);
        }
    }

    private static final class ItemProviderAdapterFactory
    extends SetupItemProviderAdapterFactory
    implements SetupPackage.Literals {
        private ItemProviderAdapterFactory() {
        }

        public Adapter createCatalogSelectionAdapter() {
            if (this.catalogSelectionItemProvider == null) {
                this.catalogSelectionItemProvider = new CatalogSelectionItemProvider((AdapterFactory)this){

                    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
                        if (this.childrenFeatures == null) {
                            this.childrenFeatures = new ArrayList();
                            this.childrenFeatures.add(CATALOG_SELECTION__PRODUCT_CATALOGS);
                        }
                        return this.childrenFeatures;
                    }

                    protected Object overlayImage(Object object, Object image) {
                        return image;
                    }
                };
            }
            return this.catalogSelectionItemProvider;
        }

        public Adapter createIndexAdapter() {
            if (this.indexItemProvider == null) {
                this.indexItemProvider = new IndexItemProvider((AdapterFactory)this){

                    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
                        if (this.childrenFeatures == null) {
                            this.childrenFeatures = new ArrayList();
                            this.childrenFeatures.add(INDEX__PRODUCT_CATALOGS);
                        }
                        return this.childrenFeatures;
                    }

                    protected Object overlayImage(Object object, Object image) {
                        return image;
                    }
                };
            }
            return this.indexItemProvider;
        }

        public Adapter createProductCatalogAdapter() {
            return new ProductCatalogItemProvider((AdapterFactory)this){

                public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
                    if (this.childrenFeatures == null) {
                        this.childrenFeatures = new ArrayList();
                        this.childrenFeatures.add(PRODUCT_CATALOG__PRODUCTS);
                    }
                    return this.childrenFeatures;
                }

                protected Command createPrimaryDragAndDropCommand(EditingDomain domain, Object owner, float location, int operations, int operation, Collection<?> collection) {
                    final ProductCatalog targetProductCatalog = (ProductCatalog)owner;
                    Resource.Internal directResource = ((InternalEObject)targetProductCatalog).eDirectResource();
                    if (directResource != null && SetupContext.isUserScheme((String)directResource.getURI().scheme())) {
                        final ResourceSet resourceSet = domain.getResourceSet();
                        return new DragAndDropCommand(domain, resourceSet, location, operations, operation, collection){
                            final Set<Product> products;
                            final Set<Product> affectedObjects;
                            {
                                super($anonymous0, $anonymous1, $anonymous2, $anonymous3, $anonymous4, $anonymous5);
                                this.products = new LinkedHashSet<Product>();
                                this.affectedObjects = new LinkedHashSet<Product>();
                            }

                            public void execute() {
                                EList targetProducts = targetProductCatalog.getProducts();
                                block0: for (Product product : this.products) {
                                    if (this.operation != 4) {
                                        if (product.eContainer() != null) {
                                            product = (Product)EcoreUtil.copy((EObject)product);
                                        } else {
                                            Resource resource = product.eResource();
                                            resource.getContents().clear();
                                            resourceSet.getResources().remove((Object)resource);
                                        }
                                    }
                                    this.affectedObjects.add(product);
                                    String name = product.getName();
                                    for (Product otherProduct : targetProducts) {
                                        if (!name.equals(otherProduct.getName())) continue;
                                        targetProducts.set(targetProducts.indexOf((Object)otherProduct), (Object)product);
                                        continue block0;
                                    }
                                    targetProducts.add((Object)product);
                                }
                                BaseUtil.saveEObject((EObject)targetProductCatalog);
                            }

                            protected boolean prepare() {
                                this.products.clear();
                                for (Object value : this.collection) {
                                    Product product;
                                    if (value instanceof URI) {
                                        URI uri = (URI)value;
                                        BaseResource resource = BaseUtil.loadResourceSafely((ResourceSet)resourceSet, (URI)uri);
                                        Product product2 = (Product)EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)SetupPackage.Literals.PRODUCT);
                                        if (product2 == null || product2.getName() == null || this.operation != 1 && product2.eContainer() != null) continue;
                                        this.products.add(product2);
                                        continue;
                                    }
                                    if (!(value instanceof Product) || (product = (Product)value).getName() == null || this.operation != 1 && product.eContainer() != null) continue;
                                    this.products.add(product);
                                }
                                if (this.operation == 2) {
                                    this.operation = 4;
                                }
                                return !this.products.isEmpty();
                            }

                            public Collection<?> getAffectedObjects() {
                                return this.affectedObjects;
                            }

                            public void redo() {
                                throw new UnsupportedOperationException();
                            }
                        };
                    }
                    return UnexecutableCommand.INSTANCE;
                }

                protected Command createDragAndDropCommand(EditingDomain domain, ResourceSet resourceSet, float location, int operations, int operation, Collection<URI> collection) {
                    return this.createPrimaryDragAndDropCommand(domain, this.getTarget(), location, operations, operation, collection);
                }

                protected Object overlayImage(Object object, Object image) {
                    return image;
                }
            };
        }

        public Adapter createProductAdapter() {
            if (this.productItemProvider == null) {
                this.productItemProvider = new ProductItemProvider((AdapterFactory)this){

                    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
                        if (this.childrenFeatures == null) {
                            this.childrenFeatures = new ArrayList();
                        }
                        return this.childrenFeatures;
                    }

                    protected Command createDragAndDropCommand(EditingDomain domain, ResourceSet resourceSet, float location, int operations, int operation, Collection<URI> collection) {
                        return UnexecutableCommand.INSTANCE;
                    }

                    protected Object overlayImage(Object object, Object image) {
                        return image;
                    }
                };
            }
            return this.productItemProvider;
        }

        public Adapter createInstallationAdapter() {
            if (this.installationItemProvider == null) {
                this.installationItemProvider = new InstallationItemProvider((AdapterFactory)this){

                    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
                        if (this.childrenFeatures == null) {
                            this.childrenFeatures = new ArrayList();
                            this.childrenFeatures.add(INSTALLATION__PRODUCT_VERSION);
                        }
                        return this.childrenFeatures;
                    }

                    protected Object overlayImage(Object object, Object image) {
                        return image;
                    }
                };
            }
            return this.installationItemProvider;
        }
    }
}

