/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.tweaklets;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.e4.compatibility.E4Util;
import org.eclipse.ui.internal.registry.EditorDescriptor;
import org.eclipse.ui.internal.tweaklets.TabBehaviour;

public class TabBehaviourMRU
extends TabBehaviour {
    @Override
    public boolean alwaysShowPinAction() {
        return false;
    }

    @Override
    public IEditorReference findReusableEditor(WorkbenchPage page) {
        boolean reuse = WorkbenchPlugin.getDefault().getPreferenceStore().getBoolean("REUSE_OPEN_EDITORS_BOOLEAN");
        if (!reuse) {
            return null;
        }
        IEditorReference[] editors = page.getSortedEditors();
        int length = editors.length;
        if (length < page.getEditorReuseThreshold()) {
            return null;
        }
        if (length > page.getEditorReuseThreshold()) {
            ArrayList<IEditorReference> refs = new ArrayList<IEditorReference>();
            ArrayList<IEditorReference> keep = new ArrayList<IEditorReference>(Arrays.asList(editors));
            int extra = length - page.getEditorReuseThreshold();
            IEditorReference[] iEditorReferenceArray = editors;
            int n = editors.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference editor = iEditorReferenceArray[n2];
                if (extra == 0) break;
                if (!editor.isPinned() && !editor.isDirty()) {
                    refs.add(editor);
                    --extra;
                }
                ++n2;
            }
            for (IEditorReference ref : refs) {
                page.closeEditor(ref, false);
                keep.remove(ref);
            }
            editors = keep.toArray(new IEditorReference[keep.size()]);
        }
        IEditorReference dirtyEditor = null;
        int i = editors.length - 1;
        while (i > -1) {
            IEditorReference editor = editors[i];
            if (!editor.isPinned()) {
                if (editor.isDirty()) {
                    if (dirtyEditor == null) {
                        dirtyEditor = editor;
                    }
                } else {
                    return editor;
                }
            }
            --i;
        }
        if (dirtyEditor == null) {
            return null;
        }
        return null;
    }

    @Override
    public IEditorReference reuseInternalEditor(WorkbenchPage page, Object manager, Object editorPresentation, EditorDescriptor desc, IEditorInput input, IEditorReference reusableEditorRef) {
        E4Util.unsupported("reuseInternalEditor: we reuse nothing");
        return reusableEditorRef;
    }
}

