/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.jdt.provider;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.oomph.setup.jdt.JDTPackage;
import org.eclipse.oomph.setup.jdt.JRELibrary;
import org.eclipse.oomph.setup.jdt.provider.JDTEditPlugin;
import org.eclipse.oomph.util.StringUtil;

public class JRELibraryItemProvider
extends ItemProviderAdapter
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource {
    public JRELibraryItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addLibraryPathPropertyDescriptor(object);
            this.addExternalAnnotationsPathPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addLibraryPathPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_JRELibrary_libraryPath_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_JRELibrary_libraryPath_feature", "_UI_JRELibrary_type"), (EStructuralFeature)JDTPackage.Literals.JRE_LIBRARY__LIBRARY_PATH, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addExternalAnnotationsPathPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_JRELibrary_externalAnnotationsPath_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_JRELibrary_externalAnnotationsPath_feature", "_UI_JRELibrary_type"), (EStructuralFeature)JDTPackage.Literals.JRE_LIBRARY__EXTERNAL_ANNOTATIONS_PATH, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    public boolean hasChildren(Object object) {
        return this.hasChildren(object, true);
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/JRELibrary"));
    }

    protected boolean shouldComposeCreationImage() {
        return true;
    }

    public String getText(Object object) {
        JRELibrary jreLibrary = (JRELibrary)object;
        String libraryPath = jreLibrary.getLibraryPath();
        if (StringUtil.isEmpty((String)libraryPath)) {
            return this.getString("_UI_JRELibrary_type");
        }
        String label = libraryPath;
        String externalAnnotationsPath = jreLibrary.getExternalAnnotationsPath();
        if (externalAnnotationsPath != null) {
            label = externalAnnotationsPath.length() == 0 ? String.valueOf(label) + " ~ \"\"" : String.valueOf(label) + " ~ " + externalAnnotationsPath;
        }
        return label;
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(JRELibrary.class)) {
            case 0: 
            case 1: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }

    public ResourceLocator getResourceLocator() {
        return JDTEditPlugin.INSTANCE;
    }
}

