/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.constraints.pb;

import java.math.BigInteger;
import org.sat4j.minisat.core.ILits;
import org.sat4j.pb.constraints.pb.IWatchPb;

public interface IWeakeningStrategy {
    public static final IWeakeningStrategy UNASSIGNED_FIRST = new IWeakeningStrategy(){

        @Override
        public int findLiteralToRemove(ILits voc, IWatchPb wpb, BigInteger[] coefsBis, int indLitImplied, BigInteger degreeBis) {
            int ind;
            int lit = -1;
            int size = wpb.size();
            for (ind = 0; ind < size && lit == -1; ++ind) {
                if (coefsBis[ind].signum() == 0 || !voc.isUnassigned(wpb.get(ind))) continue;
                assert (coefsBis[ind].compareTo(degreeBis) < 0);
                lit = ind;
            }
            if (lit == -1) {
                for (ind = 0; ind < size && lit == -1; ++ind) {
                    if (coefsBis[ind].signum() == 0 || !voc.isSatisfied(wpb.get(ind)) || ind == indLitImplied) continue;
                    lit = ind;
                }
            }
            return lit;
        }

        public String toString() {
            return "Weaken first using unassigned literals";
        }
    };
    public static final IWeakeningStrategy SATISFIED_FIRST = new IWeakeningStrategy(){

        @Override
        public int findLiteralToRemove(ILits voc, IWatchPb wpb, BigInteger[] coefsBis, int indLitImplied, BigInteger degreeBis) {
            int ind;
            int lit = -1;
            int size = wpb.size();
            for (ind = 0; ind < size && lit == -1; ++ind) {
                if (coefsBis[ind].signum() == 0 || !voc.isSatisfied(wpb.get(ind))) continue;
                assert (coefsBis[ind].compareTo(degreeBis) < 0);
                lit = ind;
            }
            if (lit == -1) {
                for (ind = 0; ind < size && lit == -1; ++ind) {
                    if (coefsBis[ind].signum() == 0 || !voc.isUnassigned(wpb.get(ind)) || ind == indLitImplied) continue;
                    lit = ind;
                }
            }
            return lit;
        }

        public String toString() {
            return "Weaken first using satisfied literals";
        }
    };
    public static final IWeakeningStrategy ANY = new IWeakeningStrategy(){

        @Override
        public int findLiteralToRemove(ILits voc, IWatchPb wpb, BigInteger[] coefsBis, int indLitImplied, BigInteger degreeBis) {
            int lit = -1;
            int size = wpb.size();
            for (int ind = 0; ind < size && lit == -1; ++ind) {
                if (coefsBis[ind].signum() == 0 || voc.isFalsified(wpb.get(ind)) || ind == indLitImplied) continue;
                assert (coefsBis[ind].compareTo(degreeBis) < 0);
                lit = ind;
            }
            return lit;
        }

        public String toString() {
            return "Weaken with no priority";
        }
    };

    public int findLiteralToRemove(ILits var1, IWatchPb var2, BigInteger[] var3, int var4, BigInteger var5);
}

