/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.jobs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.internal.jobs.InternalJob;
import org.eclipse.core.internal.jobs.JobManager;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobGroup;

public class InternalJobGroup {
    private static final long MAX_WAIT_INTERVAL = 100L;
    final Object jobGroupStateLock = new Object();
    private static final JobManager manager = JobManager.getInstance();
    private final String name;
    private final int maxThreads;
    private volatile int state = 0;
    private volatile MultiStatus result;
    private final Set<InternalJob> runningJobs = new HashSet<InternalJob>();
    private final Set<InternalJob> otherActiveJobs = new HashSet<InternalJob>();
    private final List<IStatus> results = new ArrayList<IStatus>();
    private boolean cancelingDueToError;
    private int failedJobsCount;
    private int canceledJobsCount;
    private int seedJobsCount;
    private int seedJobsRemainingCount;

    protected InternalJobGroup(String name, int maxThreads, int seedJobsCount) {
        Assert.isNotNull((Object)name);
        Assert.isLegal((maxThreads >= 0 ? 1 : 0) != 0);
        Assert.isLegal((seedJobsCount >= 0 ? 1 : 0) != 0);
        this.name = name;
        this.maxThreads = maxThreads;
        this.seedJobsCount = seedJobsCount;
        this.seedJobsRemainingCount = seedJobsCount;
    }

    protected String getName() {
        return this.name;
    }

    protected int getMaxThreads() {
        return this.maxThreads;
    }

    protected MultiStatus getResult() {
        return this.result;
    }

    protected int getState() {
        return this.state;
    }

    protected List<Job> getActiveJobs() {
        return manager.find(this);
    }

    protected void cancel() {
        manager.cancel(this);
    }

    protected boolean join(long timeout, IProgressMonitor monitor) throws InterruptedException, OperationCanceledException {
        return manager.join(this, timeout, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void jobStateChanged(InternalJob job, int oldState, int newState) {
        assert (Thread.holdsLock(InternalJobGroup.manager.lock));
        switch (oldState) {
            case 0: {
                break;
            }
            case 1: 
            case 2: {
                this.otherActiveJobs.remove(job);
                break;
            }
            case 4: {
                this.runningJobs.remove(job);
                break;
            }
            default: {
                Assert.isLegal((boolean)false, (String)("Invalid job state: " + String.valueOf(job) + ", state: " + oldState));
            }
        }
        switch (newState) {
            case 0: {
                break;
            }
            case 1: 
            case 2: {
                this.otherActiveJobs.add(job);
                break;
            }
            case 4: {
                this.runningJobs.add(job);
                break;
            }
            default: {
                Assert.isLegal((boolean)false, (String)("Invalid job state: " + String.valueOf(job) + ", state: " + newState));
            }
        }
        if (job.internalGetState() == 32 && this.getGroupOfCurrentlyRunningJob() != job.getJobGroup()) {
            --this.seedJobsRemainingCount;
        }
        if (oldState == 4 && newState == 0) {
            IStatus jobResult = job.getResult();
            Assert.isLegal((jobResult != null ? 1 : 0) != 0);
            if (this.cancelingDueToError && jobResult.getSeverity() == 8) {
                return;
            }
            this.results.add(jobResult);
            int jobResultSeverity = jobResult.getSeverity();
            if (jobResultSeverity == 4) {
                ++this.failedJobsCount;
            } else if (jobResultSeverity == 8) {
                ++this.canceledJobsCount;
            }
        }
        if (this.getState() == 0 && this.getActiveJobsCount() > 0) {
            Object object = this.jobGroupStateLock;
            synchronized (object) {
                this.state = 1;
                this.jobGroupStateLock.notifyAll();
            }
        }
    }

    private JobGroup getGroupOfCurrentlyRunningJob() {
        Job job = manager.currentJob();
        return job == null ? null : job.getJobGroup();
    }

    final void updateCancelingReason(boolean cancelDueToError) {
        assert (Thread.holdsLock(InternalJobGroup.manager.lock));
        this.cancelingDueToError = cancelDueToError;
        if (!cancelDueToError) {
            this.results.add(Status.CANCEL_STATUS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final List<Job> cancelAndNotify(boolean cancelDueToError) {
        Object object = this.jobGroupStateLock;
        synchronized (object) {
            switch (this.getState()) {
                case 0: {
                    return Collections.emptyList();
                }
                case 2: {
                    if (!cancelDueToError) {
                        this.updateCancelingReason(cancelDueToError);
                    }
                    return Collections.emptyList();
                }
            }
            this.state = 2;
            this.updateCancelingReason(cancelDueToError);
            this.jobGroupStateLock.notifyAll();
            return this.internalGetActiveJobs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void endJobGroup(MultiStatus groupResult) {
        assert (Thread.holdsLock(InternalJobGroup.manager.lock));
        Object object = this.jobGroupStateLock;
        synchronized (object) {
            if (this.seedJobsRemainingCount > 0 && !groupResult.matches(8)) {
                throw new IllegalStateException("Invalid initial jobs remaining count");
            }
            this.state = 0;
            if (this.result != null) {
                IStatus[] children1 = this.result.getChildren();
                IStatus[] children2 = groupResult.getChildren();
                if (children1.length > 0 || children2.length > 0) {
                    IStatus s;
                    ArrayList<IStatus> combined = new ArrayList<IStatus>(children1.length + children2.length);
                    IStatus[] iStatusArray = children1;
                    int n = children1.length;
                    int n2 = 0;
                    while (n2 < n) {
                        s = iStatusArray[n2];
                        combined.add(s);
                        ++n2;
                    }
                    iStatusArray = children2;
                    n = children2.length;
                    n2 = 0;
                    while (n2 < n) {
                        s = iStatusArray[n2];
                        combined.add(s);
                        ++n2;
                    }
                    groupResult = this.computeGroupResult(combined);
                }
            }
            this.result = groupResult;
            this.results.clear();
            this.cancelingDueToError = false;
            this.failedJobsCount = 0;
            this.canceledJobsCount = 0;
            this.seedJobsRemainingCount = this.seedJobsCount == 0 ? 0 : 1;
            this.jobGroupStateLock.notifyAll();
        }
    }

    final List<Job> internalGetActiveJobs() {
        assert (Thread.holdsLock(InternalJobGroup.manager.lock));
        ArrayList<Job> activeJobs = new ArrayList<Job>(this.runningJobs.size() + this.otherActiveJobs.size());
        for (InternalJob job : this.runningJobs) {
            activeJobs.add((Job)job);
        }
        for (InternalJob job : this.otherActiveJobs) {
            activeJobs.add((Job)job);
        }
        return activeJobs;
    }

    final int getSeedJobsRemainingCount() {
        assert (Thread.holdsLock(InternalJobGroup.manager.lock));
        return this.seedJobsRemainingCount;
    }

    final int getActiveJobsCount() {
        assert (Thread.holdsLock(InternalJobGroup.manager.lock));
        return this.runningJobs.size() + this.otherActiveJobs.size();
    }

    final int getRunningJobsCount() {
        assert (Thread.holdsLock(InternalJobGroup.manager.lock));
        return this.runningJobs.size();
    }

    final int getFailedJobsCount() {
        assert (Thread.holdsLock(InternalJobGroup.manager.lock));
        return this.failedJobsCount;
    }

    final int getCanceledJobsCount() {
        assert (Thread.holdsLock(InternalJobGroup.manager.lock));
        return this.canceledJobsCount;
    }

    final List<IStatus> getCompletedJobResults() {
        assert (Thread.holdsLock(InternalJobGroup.manager.lock));
        return new ArrayList<IStatus>(this.results);
    }

    protected boolean shouldCancel(IStatus lastCompletedJobResult, int numberOfFailedJobs, int numberOfCanceledJobs) {
        return numberOfFailedJobs > 0;
    }

    protected MultiStatus computeGroupResult(List<IStatus> jobResults) {
        ArrayList<IStatus> importantResults = new ArrayList<IStatus>();
        for (IStatus jobResult : jobResults) {
            if (jobResult.getSeverity() == 0) continue;
            importantResults.add(jobResult);
        }
        if (importantResults.isEmpty()) {
            return new MultiStatus("org.eclipse.core.jobs", 0, this.name, null);
        }
        String pluginId = ((IStatus)importantResults.get(0)).getPlugin();
        IStatus[] groupResults = importantResults.toArray(new IStatus[importantResults.size()]);
        return new MultiStatus(pluginId, 0, groupResults, this.name, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean doJoin(long remainingTime) throws InterruptedException {
        Object object = this.jobGroupStateLock;
        synchronized (object) {
            block4: {
                if (this.getState() != 0) break block4;
                return true;
            }
            long sleepTime = remainingTime != 0L && remainingTime <= 100L ? remainingTime : 100L;
            this.jobGroupStateLock.wait(sleepTime);
            return this.getState() == 0;
        }
    }
}

