/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.ObjectUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class XMLUtil {
    private XMLUtil() {
    }

    public static DocumentBuilder createDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setValidating(false);
        return documentBuilderFactory.newDocumentBuilder();
    }

    public static Document loadDocument(DocumentBuilder documentBuilder, InputStream inputStream) throws SAXException, IOException {
        try {
            Document document = documentBuilder.parse(inputStream);
            return document;
        }
        finally {
            IOUtil.close(inputStream);
        }
    }

    public static Document loadDocument(DocumentBuilder documentBuilder, File file) throws SAXException, IOException {
        return documentBuilder.parse(file);
    }

    public static Element loadRootElement(DocumentBuilder documentBuilder, InputStream inputStream) throws Exception {
        Document document = XMLUtil.loadDocument(documentBuilder, inputStream);
        return document.getDocumentElement();
    }

    public static Element loadRootElement(DocumentBuilder documentBuilder, File file) throws Exception {
        Document document = XMLUtil.loadDocument(documentBuilder, file);
        return document.getDocumentElement();
    }

    public static int handleElements(NodeList nodeList, ElementHandler handler) throws Exception {
        int count = 0;
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            if (node instanceof Element) {
                Element element = (Element)node;
                handler.handleElement(element);
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static int handleChildElements(Element rootElement, ElementHandler handler) throws Exception {
        NodeList childNodes = rootElement.getChildNodes();
        return XMLUtil.handleElements(childNodes, handler);
    }

    public static int handleElementsByTagName(Element rootElement, String tagName, ElementHandler handler) throws Exception {
        int count = 0;
        NodeList nodeList = rootElement.getElementsByTagName(tagName);
        count += XMLUtil.handleElements(nodeList, handler);
        int pos = tagName.indexOf(58);
        if (pos != -1) {
            tagName = tagName.substring(pos + 1);
            nodeList = rootElement.getElementsByTagName(tagName);
            count += XMLUtil.handleElements(nodeList, handler);
        }
        return count;
    }

    public static interface ElementHandler {
        public void handleElement(Element var1) throws Exception;
    }

    public static final class ElementUpdater {
        private final String tagName;
        private String textValue;
        private int index;

        public ElementUpdater(final Element rootElement, String tagName) throws Exception {
            this.tagName = tagName;
            XMLUtil.handleElementsByTagName(rootElement, tagName, new ElementHandler(){

                @Override
                public void handleElement(Element element) throws Exception {
                    if (element.getParentNode() == rootElement) {
                        textValue = element.getTextContent();
                    }
                    if (textValue == null) {
                        ++index;
                    }
                }
            });
        }

        public String update(String text, String newValue) {
            if (!ObjectUtil.equals(this.textValue, newValue)) {
                StringBuilder builder = new StringBuilder();
                int i = 0;
                while (i < this.index) {
                    builder.append(".*?<" + this.tagName + ">.*?</" + this.tagName + ">");
                    ++i;
                }
                builder.append(".*?<" + this.tagName + ">(.*?)</" + this.tagName + ">.*");
                Pattern pattern = Pattern.compile(builder.toString(), 32);
                Matcher matcher = pattern.matcher(text);
                if (matcher.matches()) {
                    text = String.valueOf(text.substring(0, matcher.start(1))) + newValue + text.substring(matcher.end(1));
                }
            }
            return text;
        }
    }
}

