/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.security.auth;

import java.util.Hashtable;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.eclipse.equinox.internal.security.auth.AuthPlugin;
import org.eclipse.equinox.internal.security.auth.ConfigurationFactory;
import org.eclipse.equinox.internal.security.auth.nls.SecAuthMessages;
import org.eclipse.osgi.util.NLS;

public class ConfigurationFederator
extends Configuration {
    private Configuration[] federatedConfigs = null;
    private Hashtable<String, AppConfigurationEntry[]> configCache = new Hashtable(5);
    private Hashtable<String, String> configToProviderMap = new Hashtable(5);
    private final Configuration defaultConfiguration;

    public ConfigurationFederator(Configuration defaultConfiguration) {
        this.defaultConfiguration = defaultConfiguration;
    }

    @Override
    public synchronized AppConfigurationEntry[] getAppConfigurationEntry(String name) {
        Configuration[] configs;
        AppConfigurationEntry[] returnValue = this.configCache.get(name);
        if (returnValue != null) {
            return returnValue;
        }
        Configuration[] allConfigs = configs = this.getFederatedConfigs();
        if (this.defaultConfiguration != null) {
            allConfigs = new Configuration[configs.length + 1];
            System.arraycopy(configs, 0, allConfigs, 0, configs.length);
            allConfigs[configs.length] = this.defaultConfiguration;
        }
        Configuration[] configurationArray = allConfigs;
        int n = allConfigs.length;
        int n2 = 0;
        while (n2 < n) {
            Configuration c = configurationArray[n2];
            boolean found = false;
            AppConfigurationEntry[] config = c.getAppConfigurationEntry(name);
            if (config != null) {
                String cachedProviderName = this.configToProviderMap.get(name);
                if (cachedProviderName != null && !cachedProviderName.equals(c.getClass().getName())) {
                    message = NLS.bind((String)SecAuthMessages.duplicateJaasConfig1, (Object)name, (Object)cachedProviderName);
                    AuthPlugin.getDefault().logError(message, null);
                } else if (found) {
                    message = NLS.bind((String)SecAuthMessages.duplicateJaasConfig2, (Object)name, (Object)cachedProviderName);
                    AuthPlugin.getDefault().logError(message, null);
                } else if (config != null && config.length != 0) {
                    returnValue = config;
                    this.configToProviderMap.put(name, c.getClass().getName());
                    this.configCache.put(name, returnValue);
                    found = true;
                }
            }
            ++n2;
        }
        if (returnValue == null || returnValue.length == 0) {
            String message = NLS.bind((String)SecAuthMessages.nonExistantJaasConfig, (Object)name);
            AuthPlugin.getDefault().logError(message, null);
        }
        return returnValue;
    }

    @Override
    public synchronized void refresh() {
        Configuration[] configurationArray = this.federatedConfigs;
        int n = this.federatedConfigs.length;
        int n2 = 0;
        while (n2 < n) {
            Configuration federatedConfig = configurationArray[n2];
            federatedConfig.refresh();
            ++n2;
        }
        if (this.defaultConfiguration != null) {
            this.defaultConfiguration.refresh();
        }
        this.configCache.clear();
        this.configToProviderMap.clear();
    }

    private Configuration[] getFederatedConfigs() {
        if (this.federatedConfigs == null) {
            this.federatedConfigs = ConfigurationFactory.getInstance().getConfigurations();
        }
        return this.federatedConfigs;
    }
}

