/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.jface.tablecomboviewer;

import org.eclipse.jface.viewers.AbstractTableViewer;
import org.eclipse.jface.viewers.ColumnViewerEditor;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.nebula.jface.tablecomboviewer.TableComboViewerRow;
import org.eclipse.nebula.widgets.tablecombo.TableCombo;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class TableComboViewer
extends AbstractTableViewer {
    private TableCombo tableCombo;
    private TableComboViewerRow cachedRow;

    public TableComboViewer(Composite parent) {
        this(parent, 2818);
    }

    public TableComboViewer(Composite parent, int style) {
        this(new TableCombo(parent, style));
    }

    public TableComboViewer(TableCombo tableCombo) {
        this.tableCombo = tableCombo;
        this.hookControl((Control)tableCombo);
    }

    protected void doClear(int index) {
        if (this.isWidgetDisposed()) {
            return;
        }
        this.tableCombo.getTable().clear(index);
    }

    private boolean isWidgetDisposed() {
        return this.tableCombo.isDisposed() || this.tableCombo.getTable().isDisposed();
    }

    protected void doClearAll() {
        if (this.isWidgetDisposed()) {
            return;
        }
        this.tableCombo.getTable().clearAll();
    }

    protected void doDeselectAll() {
        if (this.isWidgetDisposed()) {
            return;
        }
        this.tableCombo.getTable().deselectAll();
    }

    protected Widget doGetColumn(int index) {
        if (this.isWidgetDisposed()) {
            return null;
        }
        return this.tableCombo.getTable().getColumn(index);
    }

    protected Item doGetItem(int index) {
        if (this.isWidgetDisposed()) {
            return null;
        }
        return this.tableCombo.getTable().getItem(index);
    }

    protected int doGetItemCount() {
        if (this.isWidgetDisposed()) {
            return 0;
        }
        return this.tableCombo.getTable().getItemCount();
    }

    protected Item[] doGetItems() {
        if (this.isWidgetDisposed()) {
            return new Item[0];
        }
        return this.tableCombo.getTable().getItems();
    }

    protected Item[] doGetSelection() {
        if (this.isWidgetDisposed()) {
            return new Item[0];
        }
        return this.tableCombo.getTable().getSelection();
    }

    protected int[] doGetSelectionIndices() {
        if (this.isWidgetDisposed()) {
            return new int[0];
        }
        return this.tableCombo.getTable().getSelectionIndices();
    }

    protected int doIndexOf(Item item) {
        if (this.isWidgetDisposed()) {
            return -1;
        }
        return this.tableCombo.getTable().indexOf((TableItem)item);
    }

    protected void doRemove(int[] indices) {
        if (this.isWidgetDisposed()) {
            return;
        }
        this.tableCombo.getTable().remove(indices);
    }

    protected void doRemove(int start, int end) {
        if (this.isWidgetDisposed()) {
            return;
        }
        this.tableCombo.getTable().remove(start, end);
    }

    protected void doRemoveAll() {
        if (this.isWidgetDisposed()) {
            return;
        }
        this.tableCombo.getTable().removeAll();
    }

    protected void doResetItem(Item item) {
        if (this.isWidgetDisposed()) {
            return;
        }
        TableItem tableItem = (TableItem)item;
        int columnCount = Math.max(1, this.tableCombo.getTable().getColumnCount());
        int i = 0;
        while (i < columnCount) {
            tableItem.setText(i, "");
            if (tableItem.getImage(i) != null) {
                tableItem.setImage(i, null);
            }
            ++i;
        }
    }

    protected void doSelect(int[] indices) {
        if (this.isWidgetDisposed()) {
            return;
        }
        this.tableCombo.select(indices != null && indices.length > 0 ? indices[0] : -1);
    }

    protected void doSetItemCount(int count) {
        if (this.isWidgetDisposed()) {
            return;
        }
        this.tableCombo.getTable().setItemCount(count);
    }

    protected void doSetSelection(Item[] items) {
        if (this.isWidgetDisposed()) {
            return;
        }
        if (items != null && items.length > 0) {
            this.tableCombo.select(this.tableCombo.getTable().indexOf((TableItem)items[0]));
        } else {
            this.tableCombo.select(-1);
        }
    }

    protected void doSetSelection(int[] indices) {
        if (this.isWidgetDisposed()) {
            return;
        }
        this.tableCombo.select(indices != null && indices.length > 0 ? indices[0] : -1);
    }

    protected void doShowItem(Item item) {
        if (this.isWidgetDisposed()) {
            return;
        }
        this.tableCombo.getTable().showItem((TableItem)item);
    }

    protected void doShowSelection() {
        if (this.isWidgetDisposed()) {
            return;
        }
        this.tableCombo.getTable().showSelection();
    }

    protected ViewerRow internalCreateNewRowPart(int style, int rowIndex) {
        TableItem item = rowIndex >= 0 ? new TableItem(this.tableCombo.getTable(), style, rowIndex) : new TableItem(this.tableCombo.getTable(), style);
        return this.getViewerRowFromItem((Widget)item);
    }

    protected ColumnViewerEditor createViewerEditor() {
        return null;
    }

    protected int doGetColumnCount() {
        return this.tableCombo.getTable().getColumnCount();
    }

    protected Item getItemAt(Point point) {
        return this.tableCombo.getTable().getItem(point);
    }

    protected ViewerRow getViewerRowFromItem(Widget item) {
        if (this.cachedRow == null) {
            this.cachedRow = new TableComboViewerRow((TableItem)item);
        } else {
            this.cachedRow.setItem((TableItem)item);
        }
        return this.cachedRow;
    }

    public Control getControl() {
        return this.tableCombo;
    }

    public TableCombo getTableCombo() {
        return this.tableCombo;
    }

    protected void handleLabelProviderChanged(LabelProviderChangedEvent event) {
        super.handleLabelProviderChanged(event);
        this.setSelection(this.getSelection());
    }
}

