/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.e4.core.commands.ExpressionContext;
import org.eclipse.e4.ui.internal.workbench.ContributionsAnalyzer;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.commands.MParameter;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuFactoryImpl;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISourceProvider;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.commands.ICommandImageService;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.services.IWorkbenchLocationService;
import org.eclipse.ui.internal.services.WorkbenchSourceProvider;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.services.ISourceProviderService;
import org.eclipse.ui.views.IViewDescriptor;
import org.eclipse.ui.views.IViewRegistry;

public class ShowInMenu
extends ContributionItem
implements IWorkbenchContribution {
    private static final String NO_TARGETS_MSG = WorkbenchMessages.Workbench_showInNoTargets;
    private IWorkbenchWindow window;
    private boolean dirty = true;
    private IMenuListener menuListener = manager -> {
        manager.markDirty();
        this.dirty = true;
    };
    private IServiceLocator locator;
    private MenuManager currentManager;

    public ShowInMenu() {
    }

    public ShowInMenu(IWorkbenchWindow window, String id) {
        super(id);
        this.window = window;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isDynamic() {
        return true;
    }

    public void fill(Menu menu, int index) {
        if (this.getParent() instanceof MenuManager) {
            ((MenuManager)this.getParent()).addMenuListener(this.menuListener);
        }
        if (!this.dirty) {
            return;
        }
        if (this.currentManager != null && this.currentManager.getSize() > 0) {
            this.currentManager.removeAll();
        }
        this.currentManager = new MenuManager();
        this.fillMenu((IMenuManager)this.currentManager);
        int itemCount = menu.getItemCount();
        IContributionItem[] items = this.currentManager.getItems();
        if (items.length == 0) {
            MenuItem item = new MenuItem(menu, 0, index == -1 ? itemCount : index);
            item.setText(NO_TARGETS_MSG);
            item.setEnabled(false);
        } else {
            IContributionItem[] iContributionItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                IContributionItem item = iContributionItemArray[n2];
                if (item.isVisible()) {
                    if (index == -1) {
                        item.fill(menu, -1);
                    } else {
                        item.fill(menu, index);
                        int newItemCount = menu.getItemCount();
                        index += newItemCount - itemCount;
                        itemCount = newItemCount;
                    }
                }
                ++n2;
            }
        }
        this.dirty = false;
    }

    private void fillMenu(IMenuManager innerMgr) {
        IViewDescriptor[] viewDescs;
        IWorkbenchPage page = this.locator.getService(IWorkbenchPage.class);
        if (page == null) {
            return;
        }
        WorkbenchPartReference r = (WorkbenchPartReference)page.getActivePartReference();
        if (r != null && r.getModel() != null) {
            ((WorkbenchPage)page).updateShowInSources(r.getModel());
        }
        innerMgr.removeAll();
        IWorkbenchPart sourcePart = this.getSourcePart();
        ShowInContext context = this.getContext(sourcePart);
        if (context == null) {
            return;
        }
        if (context.getInput() == null && (context.getSelection() == null || context.getSelection().isEmpty())) {
            return;
        }
        IViewDescriptor[] iViewDescriptorArray = viewDescs = this.getViewDescriptors(sourcePart);
        int n = viewDescs.length;
        int n2 = 0;
        while (n2 < n) {
            IViewDescriptor viewDesc = iViewDescriptorArray[n2];
            IContributionItem cci = this.getContributionItem(viewDesc);
            if (cci != null) {
                innerMgr.add(cci);
            }
            ++n2;
        }
        if (sourcePart != null && innerMgr instanceof MenuManager) {
            ISourceProviderService sps = this.locator.getService(ISourceProviderService.class);
            ISourceProvider sp = sps.getSourceProvider("showInSelection");
            if (sp instanceof WorkbenchSourceProvider) {
                ((WorkbenchSourceProvider)sp).checkActivePart(true);
            }
            String location = "popup:org.eclipse.ui.menus.showInMenu";
            location = location.substring(location.indexOf(58) + 1);
            WorkbenchWindow workbenchWindow = (WorkbenchWindow)this.getWindow();
            MApplication application = (MApplication)workbenchWindow.getModel().getContext().get(MApplication.class);
            MMenu menuModel = MenuFactoryImpl.eINSTANCE.createMenu();
            ArrayList toContribute = new ArrayList();
            ArrayList menuContributionsToRemove = new ArrayList();
            ExpressionContext eContext = new ExpressionContext(workbenchWindow.getModel().getContext());
            ContributionsAnalyzer.gatherMenuContributions((MMenu)menuModel, (List)application.getMenuContributions(), (String)location, toContribute, (ExpressionContext)eContext, (boolean)true);
            ContributionsAnalyzer.addMenuContributions((MMenu)menuModel, toContribute, menuContributionsToRemove);
            ICommandImageService imgService = workbenchWindow.getService(ICommandImageService.class);
            for (MMenuElement menuElement : menuModel.getChildren()) {
                if (!(menuElement instanceof MHandledMenuItem)) continue;
                MCommand command = ((MHandledMenuItem)menuElement).getCommand();
                String commandId = command.getElementId();
                CommandContributionItemParameter ccip = new CommandContributionItemParameter(workbenchWindow, commandId, commandId, 8);
                String label = menuElement.getLabel();
                if (label != null && label.length() > 0) {
                    ccip.label = label;
                    String mnemonics = menuElement.getMnemonics();
                    ccip.mnemonic = mnemonics != null && mnemonics.length() == 1 ? mnemonics : label.substring(0, 1);
                }
                String iconURI = menuElement.getIconURI();
                try {
                    ccip.icon = iconURI != null && !iconURI.isEmpty() ? ImageDescriptor.createFromURL((URL)new URL(iconURI)) : imgService.getImageDescriptor(commandId);
                }
                catch (MalformedURLException e) {
                    ccip.icon = imgService.getImageDescriptor(commandId);
                }
                List menuParameters = ((MHandledMenuItem)menuElement).getParameters();
                if (menuParameters != null && !menuParameters.isEmpty()) {
                    ccip.parameters = new HashMap(menuParameters.size());
                    for (MParameter menuParam : menuParameters) {
                        ccip.parameters.put(menuParam.getName(), menuParam.getValue());
                    }
                }
                innerMgr.add((IContributionItem)new CommandContributionItem(ccip));
            }
        }
    }

    protected IContributionItem getContributionItem(IViewDescriptor viewDescriptor) {
        CommandContributionItemParameter parm = new CommandContributionItemParameter(this.locator, viewDescriptor.getId(), "org.eclipse.ui.navigate.showIn", 8);
        HashMap<String, String> targetId = new HashMap<String, String>();
        targetId.put("org.eclipse.ui.navigate.showIn.targetId", viewDescriptor.getId());
        parm.parameters = targetId;
        parm.label = viewDescriptor.getLabel();
        if (parm.label.length() > 0) {
            parm.mnemonic = parm.label.substring(0, 1);
        }
        parm.icon = viewDescriptor.getImageDescriptor();
        return new CommandContributionItem(parm);
    }

    private ArrayList<Object> getShowInPartIds(IWorkbenchPart sourcePart) {
        String[] partIds;
        IShowInTargetList targetList;
        ArrayList<Object> targetIds = new ArrayList<Object>();
        WorkbenchPage page = (WorkbenchPage)this.getWindow().getActivePage();
        if (page != null) {
            String srcId = sourcePart == null ? null : sourcePart.getSite().getId();
            List<String> pagePartIds = page.getShowInPartIds();
            for (String pagePartId : pagePartIds) {
                if (pagePartId.equals(srcId)) continue;
                targetIds.add(pagePartId);
            }
        }
        if ((targetList = (IShowInTargetList)Adapters.adapt((Object)sourcePart, IShowInTargetList.class)) != null && (partIds = targetList.getShowInTargetIds()) != null) {
            String[] stringArray = partIds;
            int n = partIds.length;
            int n2 = 0;
            while (n2 < n) {
                String partId = stringArray[n2];
                if (!targetIds.contains(partId)) {
                    targetIds.add(partId);
                }
                ++n2;
            }
        }
        page.sortShowInPartIds(targetIds);
        return targetIds;
    }

    protected IWorkbenchPart getSourcePart() {
        IWorkbenchWindow window = this.getWindow();
        if (window == null) {
            return null;
        }
        IWorkbenchPage page = window.getActivePage();
        return page != null ? page.getActivePart() : null;
    }

    protected ShowInContext getContext(IWorkbenchPart sourcePart) {
        if (sourcePart != null) {
            IShowInSource source = (IShowInSource)Adapters.adapt((Object)sourcePart, IShowInSource.class);
            if (source != null) {
                ShowInContext context = source.getShowInContext();
                if (context != null) {
                    return context;
                }
            } else if (sourcePart instanceof IEditorPart) {
                IEditorInput input = ((IEditorPart)sourcePart).getEditorInput();
                ISelectionProvider sp = sourcePart.getSite().getSelectionProvider();
                ISelection sel = sp == null ? null : sp.getSelection();
                return new ShowInContext(input, sel);
            }
        }
        return null;
    }

    private IViewDescriptor[] getViewDescriptors(IWorkbenchPart sourcePart) {
        ArrayList<Object> ids = this.getShowInPartIds(sourcePart);
        ArrayList<IViewDescriptor> descs = new ArrayList<IViewDescriptor>();
        IViewRegistry reg = WorkbenchPlugin.getDefault().getViewRegistry();
        for (Object object : ids) {
            String id = (String)object;
            IViewDescriptor desc = reg.find(id);
            if (desc == null) continue;
            descs.add(desc);
        }
        return descs.toArray(new IViewDescriptor[descs.size()]);
    }

    @Override
    public void initialize(IServiceLocator serviceLocator) {
        this.locator = serviceLocator;
    }

    protected IWorkbenchWindow getWindow() {
        IWorkbench wb;
        if (this.locator == null) {
            return null;
        }
        IWorkbenchLocationService wls = this.locator.getService(IWorkbenchLocationService.class);
        if (this.window == null) {
            this.window = wls.getWorkbenchWindow();
        }
        if (this.window == null && (wb = wls.getWorkbench()) != null) {
            this.window = wb.getActiveWorkbenchWindow();
        }
        return this.window;
    }

    public void dispose() {
        if (this.currentManager != null && this.currentManager.getSize() > 0) {
            this.currentManager.removeAll();
            this.currentManager = null;
        }
        if (this.getParent() instanceof MenuManager) {
            ((MenuManager)this.getParent()).removeMenuListener(this.menuListener);
        }
        this.window = null;
        this.locator = null;
    }
}

