/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.version.ui.quickfixes;

import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.oomph.version.ui.quickfixes.AbstractResolution;

public abstract class AbstractDocumentResolution
extends AbstractResolution {
    public AbstractDocumentResolution(IMarker marker, String label, String imageKey) {
        super(marker, label, imageKey);
    }

    @Override
    protected final void apply(IMarker marker) throws Exception {
        IPath fullPath = ((IFile)marker.getResource()).getFullPath();
        ITextFileBufferManager.DEFAULT.connect(fullPath, LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
        try {
            ITextFileBuffer buffer = ITextFileBufferManager.DEFAULT.getTextFileBuffer(fullPath, LocationKind.IFILE);
            boolean wasDirty = buffer.isDirty();
            IDocument document = buffer.getDocument();
            if (this.apply(marker, document) && !wasDirty && !buffer.isShared()) {
                buffer.commit((IProgressMonitor)new NullProgressMonitor(), true);
            }
        }
        finally {
            ITextFileBufferManager.DEFAULT.disconnect(fullPath, LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    protected abstract boolean apply(IMarker var1, IDocument var2) throws Exception;
}

