/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.ui;

import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.ui.ImageURIRegistry;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.provider.DecoratingColumLabelProvider;
import org.eclipse.emf.edit.ui.provider.DiagnosticDecorator;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.swt.graphics.Image;

public class ToolTipLabelProvider
extends DecoratingColumLabelProvider {
    private AdapterFactoryItemDelegator itemDelegator;

    public ToolTipLabelProvider(ComposedAdapterFactory adapterFactory) {
        super((ILabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory), new ILabelDecorator(){

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return true;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public String decorateText(String text, Object element) {
                return text;
            }

            public Image decorateImage(Image image, Object element) {
                return image;
            }
        });
        this.itemDelegator = new AdapterFactoryItemDelegator((AdapterFactory)adapterFactory);
    }

    public String getToolTipText(Object element) {
        return ToolTipLabelProvider.renderHTML(this.itemDelegator, element);
    }

    public static String renderHTML(AdapterFactoryItemDelegator itemDelegator, Object element) {
        StringBuilder result = new StringBuilder();
        List propertyDescriptors = itemDelegator.getPropertyDescriptors(element);
        if (propertyDescriptors != null) {
            result.append("<table border='1'>");
            for (IItemPropertyDescriptor propertyDescriptor : propertyDescriptors) {
                String valueText;
                result.append("<tr>");
                String displayName = propertyDescriptor.getDisplayName(element);
                result.append("<td>").append(DiagnosticDecorator.escapeContent((String)displayName)).append("</td>");
                result.append("<td>");
                IItemLabelProvider propertyLabelProvider = propertyDescriptor.getLabelProvider(element);
                Object propertyValue = propertyDescriptor.getPropertyValue(element);
                Object image = propertyLabelProvider.getImage(propertyValue);
                if (image != null) {
                    result.append(DiagnosticDecorator.enquote((String)("<img src='" + ImageURIRegistry.INSTANCE.getImageURI(ExtendedImageRegistry.INSTANCE.getImage(image)) + "'/> ")));
                }
                if (!StringUtil.isEmpty((String)(valueText = propertyLabelProvider.getText(propertyValue)))) {
                    result.append(DiagnosticDecorator.escapeContent((String)valueText));
                } else {
                    result.append("&nbsp;");
                }
                if (valueText == null && image == null) {
                    result.append("&nbsp;");
                }
                result.append("</td>");
                result.append("</tr>");
            }
            result.append("</table>");
        }
        return result.length() == 0 ? null : result.toString();
    }
}

