/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.ostools;

import java.io.File;
import java.io.IOException;
import org.eclipse.oomph.ostools.AbstractLocationHandler;
import org.eclipse.oomph.util.OS;

public class PromptHandler
extends AbstractLocationHandler {
    private static final String[] LINUX_TERMINALS = new String[]{"gnome-terminal", "xterm"};

    protected void execute(File location) throws Exception {
        if (OS.INSTANCE.isWin()) {
            Runtime.getRuntime().exec("cmd /c cd /d \"" + location + "\" && start cmd.exe");
        } else if (OS.INSTANCE.isMac()) {
            ProcessBuilder builder = new ProcessBuilder("/Applications/Utilities/Terminal.app/Contents/MacOS/Terminal", location.toString());
            builder.start();
        } else if (OS.INSTANCE.isLinux()) {
            String[] stringArray = LINUX_TERMINALS;
            int n = LINUX_TERMINALS.length;
            int n2 = 0;
            while (n2 < n) {
                String terminal = stringArray[n2];
                try {
                    ProcessBuilder builder = new ProcessBuilder(terminal);
                    builder.directory(location);
                    builder.start();
                    return;
                }
                catch (Exception exception) {
                    ++n2;
                }
            }
            throw new IOException("Could not start any terminal: " + LINUX_TERMINALS);
        }
    }
}

