/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.management.mbeans;

import com.sun.messaging.jmq.Version;
import com.sun.messaging.jmq.io.MQAddress;
import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.api.ClusterManager;
import com.sun.messaging.jmq.jmsserver.cluster.api.ClusteredBroker;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.config.ConfigListener;
import com.sun.messaging.jmq.jmsserver.config.PropertyUpdateException;
import com.sun.messaging.jmq.jmsserver.core.BrokerMQAddress;
import com.sun.messaging.jmq.jmsserver.management.mbeans.MQMBeanReadOnly;
import com.sun.messaging.jmq.jmsserver.management.util.ClusterUtil;
import com.sun.messaging.jmq.jmsserver.management.util.MQAddressUtil;
import com.sun.messaging.jms.management.server.BrokerNotification;
import com.sun.messaging.jms.management.server.ClusterNotification;
import java.lang.management.MemoryUsage;
import java.util.Map;
import java.util.Properties;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.openmbean.CompositeData;

public class BrokerMonitor
extends MQMBeanReadOnly
implements ConfigListener {
    private Properties brokerProps = null;
    private static MBeanAttributeInfo[] attrs;
    private static String[] brokerNotificationTypes;
    private static String[] clusterNotificationTypes;
    private static MBeanNotificationInfo[] notifs;

    public BrokerMonitor() {
        this.initProps();
        BrokerConfig cfg = Globals.getConfig();
        cfg.addListener("imq.instancename", this);
        cfg.addListener("imq.portmapper.port", this);
        cfg.addListener("imq.product.version", this);
        cfg.addListener("imq.system.max_count", this);
    }

    public String getBrokerID() {
        return Globals.getBrokerID();
    }

    public Boolean getEmbedded() {
        return Broker.isInProcess();
    }

    public Boolean isEmbedded() {
        return this.getEmbedded();
    }

    public String getInstanceName() {
        return this.brokerProps.getProperty("imq.instancename");
    }

    public Integer getPort() throws MBeanException {
        String s = this.brokerProps.getProperty("imq.portmapper.port");
        Integer i = null;
        try {
            i = Integer.valueOf(s);
        }
        catch (Exception e) {
            this.handleGetterException("Port", e);
        }
        return i;
    }

    public String getHost() {
        return Globals.getBrokerHostName();
    }

    public String getResourceState() {
        return Globals.getMemManager().getCurrentLevelName();
    }

    public MQAddress getMQAddress() {
        MQAddress addr = null;
        try {
            addr = MQAddressUtil.getPortMapperMQAddress(this.getPort());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return addr;
    }

    public String getVersion() {
        return this.brokerProps.getProperty("imq.product.version");
    }

    @Override
    public String getMBeanName() {
        return "BrokerMonitor";
    }

    @Override
    public String getMBeanDescription() {
        return mbr.getString("MB1042");
    }

    @Override
    public MBeanAttributeInfo[] getMBeanAttributeInfo() {
        return attrs;
    }

    @Override
    public MBeanOperationInfo[] getMBeanOperationInfo() {
        return null;
    }

    @Override
    public MBeanNotificationInfo[] getMBeanNotificationInfo() {
        return notifs;
    }

    @Override
    public void validate(String name, String value) throws PropertyUpdateException {
    }

    @Override
    public boolean update(String name, String value) {
        this.initProps();
        return true;
    }

    public void notifyResourceStateChange(String oldResourceState, String newResourceState, MemoryUsage heapMemoryUsage) {
        BrokerNotification n = new BrokerNotification("mq.broker.resource.state.change", this, this.sequenceNumber++);
        n.setOldResourceState(oldResourceState);
        n.setNewResourceState(newResourceState);
        n.setHeapMemoryUsage(heapMemoryUsage);
        this.sendNotification(n);
    }

    public void notifyQuiesceStart() {
        this.sendNotification(new BrokerNotification("mq.broker.quiesce.start", this, this.sequenceNumber++));
    }

    public void notifyQuiesceComplete() {
        this.sendNotification(new BrokerNotification("mq.broker.quiesce.complete", this, this.sequenceNumber++));
    }

    public void notifyShutdownStart() {
        this.sendNotification(new BrokerNotification("mq.broker.shutdown.start", this, this.sequenceNumber++));
    }

    public void notifyTakeoverStart(String brokerID) {
        BrokerNotification n = new BrokerNotification("mq.broker.takeover.start", this, this.sequenceNumber++);
        n.setFailedBrokerID(brokerID);
        CompositeData cd = this.getLocalBrokerInfo();
        if (cd != null) {
            n.setBrokerAddress((String)cd.get("Address"));
            n.setBrokerID((String)cd.get("ID"));
        }
        this.sendNotification(n);
    }

    public void notifyTakeoverComplete(String brokerID) {
        BrokerNotification n = new BrokerNotification("mq.broker.takeover.complete", this, this.sequenceNumber++);
        n.setFailedBrokerID(brokerID);
        CompositeData cd = this.getLocalBrokerInfo();
        if (cd != null) {
            n.setBrokerAddress((String)cd.get("Address"));
            n.setBrokerID((String)cd.get("ID"));
        }
        this.sendNotification(n);
    }

    public void notifyTakeoverFail(String brokerID) {
        BrokerNotification n = new BrokerNotification("mq.broker.takeover.fail", this, this.sequenceNumber++);
        n.setFailedBrokerID(brokerID);
        CompositeData cd = this.getLocalBrokerInfo();
        if (cd != null) {
            n.setBrokerAddress((String)cd.get("Address"));
            n.setBrokerID((String)cd.get("ID"));
        }
        this.sendNotification(n);
    }

    public void notifyClusterBrokerJoin(String brokerID) {
        ClusterNotification n = new ClusterNotification("mq.cluster.broker.join", this, this.sequenceNumber++);
        n.setBrokerID(brokerID);
        n.setBrokerAddress(ClusterUtil.getBrokerAddress(brokerID));
        n.setClusterID(Globals.getClusterID());
        n.setHighlyAvailable(Globals.getHAEnabled());
        boolean isMaster = false;
        isMaster = n.isHighlyAvailable() ? false : false;
        n.setMasterBroker(isMaster);
        this.sendNotification(n);
    }

    private CompositeData getLocalBrokerInfo() {
        ClusterManager cm = Globals.getClusterManager();
        CompositeData cd = null;
        if (cm == null) {
            return null;
        }
        MQAddress address = cm.getMQAddress();
        String id = null;
        try {
            id = cm.lookupBrokerID(BrokerMQAddress.createAddress(address.toString()));
        }
        catch (Exception e) {
            return null;
        }
        if (id == null || id.equals("")) {
            return null;
        }
        try {
            ClusteredBroker cb = cm.getBroker(id);
            if (cb == null) {
                return null;
            }
            cd = ClusterUtil.getConfigCompositeData(cb);
        }
        catch (Exception e) {
            return null;
        }
        return cd;
    }

    private void initProps() {
        this.brokerProps = Globals.getConfig().toProperties();
        Version version = Globals.getVersion();
        this.brokerProps.putAll((Map<?, ?>)version.getProps());
    }

    static {
        MBeanAttributeInfo[] mBeanAttributeInfoArray = new MBeanAttributeInfo[7];
        mBeanAttributeInfoArray[0] = new MBeanAttributeInfo("BrokerID", String.class.getName(), mbr.getString("MB1028"), true, false, false);
        mBeanAttributeInfoArray[1] = new MBeanAttributeInfo("Embedded", Boolean.class.getName(), mbr.getString("MB1029"), true, false, true);
        mBeanAttributeInfoArray[2] = new MBeanAttributeInfo("InstanceName", String.class.getName(), mbr.getString("MB1030"), true, false, false);
        mBeanAttributeInfoArray[3] = new MBeanAttributeInfo("ResourceState", String.class.getName(), mbr.getString("MB1242"), true, false, false);
        mBeanAttributeInfoArray[4] = new MBeanAttributeInfo("Port", Integer.class.getName(), mbr.getString("MB1031"), true, false, false);
        mBeanAttributeInfoArray[5] = new MBeanAttributeInfo("Host", String.class.getName(), mbr.getString("MB1268"), true, false, false);
        mBeanAttributeInfoArray[6] = new MBeanAttributeInfo("Version", String.class.getName(), mbr.getString("MB1032"), true, false, false);
        attrs = mBeanAttributeInfoArray;
        brokerNotificationTypes = new String[]{"mq.broker.resource.state.change", "mq.broker.quiesce.complete", "mq.broker.quiesce.start", "mq.broker.shutdown.start", "mq.broker.takeover.complete", "mq.broker.takeover.fail", "mq.broker.takeover.start"};
        clusterNotificationTypes = new String[]{"mq.cluster.broker.join"};
        MBeanNotificationInfo[] mBeanNotificationInfoArray = new MBeanNotificationInfo[2];
        mBeanNotificationInfoArray[0] = new MBeanNotificationInfo(brokerNotificationTypes, BrokerNotification.class.getName(), mbr.getString("MB1026"));
        mBeanNotificationInfoArray[1] = new MBeanNotificationInfo(clusterNotificationTypes, ClusterNotification.class.getName(), mbr.getString("MB1024"));
        notifs = mBeanNotificationInfoArray;
    }
}

