/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.equinox.access;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.passage.lic.base.restrictions.BaseRestrictionLevelDescriptor;
import org.eclipse.passage.lic.runtime.restrictions.RestrictionExecutorRegistry;
import org.eclipse.passage.lic.runtime.restrictions.RestrictionLevelDescriptor;
import org.osgi.service.component.annotations.Component;

@Component
public class EquinoxRestrictionExecutorRegistry
implements RestrictionExecutorRegistry {
    private final Map<String, RestrictionLevelDescriptor> supportedLevels = new LinkedHashMap<String, RestrictionLevelDescriptor>();

    public EquinoxRestrictionExecutorRegistry() {
        String info = "info";
        this.supportedLevels.put(info, (RestrictionLevelDescriptor)new BaseRestrictionLevelDescriptor(info, "Info", "Inform about functionality restriction without pausing the execution flow"));
        String warn = "warn";
        this.supportedLevels.put(warn, (RestrictionLevelDescriptor)new BaseRestrictionLevelDescriptor(warn, "Warning", "Pause the execution flow with warning, but allow to proceed without functionality blocking"));
        String error = "error";
        this.supportedLevels.put(error, (RestrictionLevelDescriptor)new BaseRestrictionLevelDescriptor(error, "Error", "Interrupt the execution for the restricted functionality with error, but allow to use other scenarios"));
        String fatal = "fatal";
        this.supportedLevels.put(fatal, (RestrictionLevelDescriptor)new BaseRestrictionLevelDescriptor(fatal, "Fatal", "Terminate the execution with fatal error"));
    }

    public Iterable<String> getRestrictionLevelIdentifiers() {
        return this.supportedLevels.keySet();
    }

    public String getDefaultRestrictionLevelIdentifier() {
        return "warn";
    }

    public RestrictionLevelDescriptor getRestrictionLevel(String identifier) {
        return this.supportedLevels.get(identifier);
    }

    public Iterable<? extends RestrictionLevelDescriptor> getRestrictionLevels() {
        return this.supportedLevels.values();
    }
}

