/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.eclipse.passage.lic.internal.json.FeaturePermissionAggregator;
import org.eclipse.passage.lic.internal.json.JsonTransport;
import org.eclipse.passage.lic.internal.json.LicensingConditionAggregator;
import org.eclipse.passage.lic.net.LicensingRequests;
import org.eclipse.passage.lic.runtime.access.FeaturePermission;
import org.eclipse.passage.lic.runtime.conditions.LicensingCondition;

public class RequestProducer {
    static Logger logger = Logger.getLogger(RequestProducer.class.getName());
    private static final String REQUEST_ACTION_CONDITIONS_EVALUATE = "evaluateConditions";
    private static final String CHARSET_UTF_8 = "UTF-8";
    public static final String PARAMETER_CONFIGURATION = "configuration";

    public Iterable<? extends FeaturePermission> evaluateConditionsRequest(CloseableHttpClient httpClient, HttpHost host, Map<String, String> requestAttributes, Iterable<LicensingCondition> conditions) {
        try {
            requestAttributes.put("action", REQUEST_ACTION_CONDITIONS_EVALUATE);
            URIBuilder builder = LicensingRequests.createRequestUriBuilder(requestAttributes);
            FeaturePermissionAggregator transferObject = this.processingEvaluateConditions(httpClient, host, builder, conditions);
            return transferObject.getFeaturePermissions();
        }
        catch (Exception e) {
            Logger.getLogger(RequestProducer.class.getName()).info(e.getMessage());
            return Collections.emptyList();
        }
    }

    private FeaturePermissionAggregator processingEvaluateConditions(CloseableHttpClient httpClient, HttpHost host, URIBuilder builder, Iterable<LicensingCondition> conditions) throws URISyntaxException, ClientProtocolException, IOException {
        HttpPost httpPost = new HttpPost(builder.build());
        ObjectMapper mapper = JsonTransport.createObjectMapper();
        LicensingConditionAggregator transferObject = new LicensingConditionAggregator();
        for (LicensingCondition d : conditions) {
            transferObject.addLicensingCondition(d);
        }
        String objectAsString = mapper.writeValueAsString((Object)transferObject);
        StringEntity entity = new StringEntity(objectAsString, CHARSET_UTF_8);
        httpPost.setEntity((HttpEntity)entity);
        httpPost.setHeader("Content-type", "application/json");
        ResponseHandler<FeaturePermissionAggregator> responseHandler = new ResponseHandler<FeaturePermissionAggregator>(){

            public FeaturePermissionAggregator handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                HttpEntity entity = response.getEntity();
                ObjectMapper mapper = JsonTransport.createObjectMapper();
                try {
                    Throwable throwable = null;
                    Object var5_7 = null;
                    try (InputStream inputContext = entity.getContent();){
                        FeaturePermissionAggregator transferObject = null;
                        transferObject = (FeaturePermissionAggregator)mapper.readValue(inputContext, FeaturePermissionAggregator.class);
                        return transferObject;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    logger.info(e.getMessage());
                    return null;
                }
            }
        };
        return (FeaturePermissionAggregator)httpClient.execute(host, (HttpRequest)httpPost, (ResponseHandler)responseHandler);
    }
}

